################################################################################
# Common Make rules                                                            #
# Copyright Atheros Communications LLC                                         #
################################################################################
# $Id: //depot/sw/branches/1.3_USB_LINUX_port/make/mix/src/Makefile.inc#1 $

# Global Definitions
CC=$(CROSS)gcc
LD=$(CROSS)ld
SHELL=/bin/sh

ifeq ($(KERNELVERSION),)
KERNELVERSION=`uname -r`
endif

ifeq ($(KERNELDIR),)
KERNELDIR=/lib/modules/$(KERNELVERSION)/build
endif
MODULES_DIR=/lib/modules/$(KERNELVERSION)/kernel/drivers/usb

# We can move most of the Include definitions from the subdirectories to here
INCLUDES=-I$(KERNELDIR)/include -I.
DEFS=-DLinux -D__KERNEL__ -DMODULE -DNDIS_WDM -DBUILD_AR5212 -DBUILD_AR5523 -DWLAN_CONFIG_LEAP -DLEAP_IN_DRIVER
# -DDEBUG -DDEBUG_PRINTF -D_DEBUG -DDBUG=1 -DDBG -DNDEBUG

# We get a lot of unused variable warnings; dont use -Wall for the final release
CFLAGS=-Wimplicit -O2
EXTRA_CFLAGS = $(DEFS) -I$(USB_ROOT_DIR)/include -I$(USB_HOST_DIR)/include -I$(USB_FW_DIR) -I$(WLAN_HOST_DIR)/include

UUENCODE		= uuencode
UUDECODE		= uudecode
USB_ROOT_DIR    = $(ROOT_DIR)/USB
USB_HOST_DIR	= $(USB_ROOT_DIR)/transport/usb/host
USB_DRV_DIR		= $(USB_HOST_DIR)/drv
USB_FW_DIR		= $(USB_HOST_DIR)/linux

WLAN_HOST_DIR   = $(ROOT_DIR)/USB/wlan/host
WLAN_TARGET_DIR = $(ROOT_DIR)/USB/wlan/target
WLAN_WDC_DIR    = $(WLAN_HOST_DIR)/wdc
WLAN_COMMON_DIR = $(WLAN_HOST_DIR)/common
WLAN_CRYPTO_DIR = $(WLAN_HOST_DIR)/common/crypto
WLAN_STA_DIR    = $(WLAN_HOST_DIR)/sta
WLAN_LINUX_DIR   = $(WLAN_HOST_DIR)/linux

%.o: %.c
	@echo "<== Compiling File $(CWD)/$< ==>"
	@$(CC) $(CFLAGS) $(INCLUDES) $(DEFS) -c $< -o $@

%.d: %.c
	@echo "<== Creating Dependency for $(CWD)/$< ==>"
	@$(SHELL) -ec "$(CC) -M $(CFLAGS) $(INCLUDES) $(DEFS) $< | sed 's/$*\.o/& $@/g' > $@"

