/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/include/athPlatform.h#1 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 */

#ifndef _ATHPLATFORM_H
#define _ATHPLATFORM_H

#ifdef __cplusplus
extern "C" {
#endif

#if defined(PCI_NDIS)
#define sysPciRead32(_addr)         (*((volatile ULONG *)(_addr)))
#define sysPciWrite32(_addr, _val)  (*((ULONG *)(_addr)) = (ULONG)(_val))

#elif defined(PPC8240)
#define sysPciRead32(_addr)         sysPciInLong(_addr)
#define sysPciWrite32(_addr, _val)  sysPciOutLong(_addr, _val)

#elif defined(AR531X)
#define sysPciRead32(_addr)         (*((volatile ULONG *)(_addr)))
#define sysPciWrite32(_addr, _val)  (*((volatile ULONG *)(_addr)) = (_val))

#elif defined(AR5523)
#define sysPciRead32(_addr)         (*((volatile ULONG *)(_addr)))
#define sysPciWrite32(_addr, _val)  (*((volatile ULONG *)(_addr)) = (_val))

#elif defined(AR_PB32)
#define sysPciRead32(_addr)         sysInLong(_addr)
#define sysPciWrite32(_addr, _val)  sysOutLong(_addr, _val)

#else
#define sysPciRead32(_addr)         BUS_TO_CPU_SWAP_32(IO_READ_32(_addr))
#define sysPciWrite32(_addr, _val)  IO_WRITE_32(_addr, CPU_TO_BUS_SWAP_32(_val))

#endif

#ifdef __cplusplus
}
#endif

#endif /* _ATHPLATFORM_H_ */

