/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/include/linuxdrv.h#3 $
 *
 * Linux Stub definitions.  This header is used both by firmware download
 * and NDIS drivers. Contains stub/dummy functions for both
 *
 * Copyright (c) 2004 Atheros Communications, Inc.,
 * All Rights Reserved
 * 
 */

#ifndef _LINUXDRV_H
#define _LINUXDRV_H

/* These definitions should typically go inside wlantype.h, but requires
 * a lot of OS dependent header files to be included.  wlantype.h does
 * it very late, so lets just define them here */
typedef spinlock_t              KSPIN_LOCK,*PKSPIN_LOCK;
typedef struct urb              URB,*PURB;
typedef void                    *PVOID;
typedef PVOID                   PIRP;
typedef PVOID                   PIO_WORKITEM;
typedef PVOID                   PATHUSB_WORKER_THREAD_CONTEXT;
typedef PVOID                   USBD_CONFIGURATION_HANDLE;
typedef struct usb_device *     PUSB_DEVICE;
typedef struct usb_interface *  PUSB_INTERFACE;
typedef unsigned char           CCHAR;
typedef unsigned char           *NDIS_STRING;
typedef unsigned long           KDPC, *PKDPC;
typedef unsigned int            KIRQL;
typedef int                     NTSTATUS;
typedef int                     NDIS_STATUS, *PNDIS_STATUS;
typedef int                     NDIS_OID;
typedef long                    USBD_STATUS;
typedef atomic_t                A_ATOMIC;
typedef struct list_head        LIST_ENTRY, *PLIST_ENTRY;
typedef void (*PFN_USBTIMER_CALLBACK)(unsigned long);
typedef struct sk_buff          *PSKB_PACKET;
typedef struct sk_buff          *PSKB_BUFFER;
typedef struct sk_buff          *PNDIS_PACKET,**PPNDIS_PACKET;
typedef struct sk_buff          *PNDIS_BUFFER;
typedef PVOID                   PNDIS_WORK_ITEM;
typedef struct net_device       *NDIS_HANDLE;
typedef unsigned long           NDIS_ENVIRONMENT_TYPE;

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0))
typedef struct tq_struct        ATHUSB_WORK_ITEM;
#define ATHUSB_INIT_WORK(a,b,c)         INIT_TQUEUE(a,b,c)
#define ATHUSB_SCHEDULE_TASK(pQueue)    schedule_task((pQueue))
#else
typedef struct work_struct      ATHUSB_WORK_ITEM;
#define ATHUSB_INIT_WORK(a,b,c)         INIT_WORK(a,b,c)
#define ATHUSB_SCHEDULE_TASK(pQueue)    schedule_work((pQueue))
#endif
#define IN
#define OUT

#define NT_SUCCESS(ntStatus)        ((ntStatus) == 0)
#define USBD_SUCCESS(usbdStatus)    ((usbdStatus) == 0)
#define STATUS_SUCCESS                  0
#define NDIS_STATUS_SUCCESS             0
#define NDIS_STATUS_INVALID_DATA        (-EINVAL)
#define NDIS_STATUS_UNSUCCESSFUL        (-EINVAL)
#define NDIS_STATUS_NOT_SUPPORTED       (-EINVAL)
#define NDIS_STATUS_FAILURE             (-EINVAL)
#define NDIS_STATUS_RESOURCES           (-ENOMEM)
#define NDIS_STATUS_NOT_ACCEPTED        (-EINVAL)
#define NDIS_STATUS_PENDING             (-EINPROGRESS)
#define NDIS_STATUS_RESET_IN_PROGRESS   (-EINPROGRESS)
#define NDIS_STATUS_HARD_ERRORS         (-EINVAL)
#define NDIS_STATUS_MEDIA_CONNECT       (1)
#define NDIS_STATUS_MEDIA_DISCONNECT    (2)
#define NDIS_STATUS_REQUEST_ABORTED     (3)

#define NDIS_ERROR_CODE_OUT_OF_RESOURCES            (-ENOMEM)
#define NDIS_ERROR_CODE_HARDWARE_FAILURE            (-ENODEV)
#define NDIS_ERROR_CODE_UNSUPPORTED_CONFIGURATION   (-EINVAL)
#define DISPATCH_LEVEL                  2
#define PASSIVE_LEVEL                   1
#define STATUS_MORE_PROCESSING_REQUIRED (1 << 0) 
#define STATUS_CANCELLED                (-ENOENT) 
#define STATUS_DEVICE_NOT_CONNECTED     (-ENOENT)
#define STATUS_INSUFFICIENT_RESOURCES   (-ENOMEM)
#define STATUS_NO_MEMORY                (-ENOMEM)
#define STATUS_UNSUCCESSFUL             (-EINVAL)
#define STATUS_TIMEOUT                  (-ETIMEDOUT)
#define NDIS_802_11_AUTH_REQUEST_GROUP_ERROR        0
#define NDIS_802_11_AUTH_REQUEST_PAIRWISE_ERROR     1
#define ETH_LENGTH_OF_ADDRESS           ETH_ALEN

#define NDIS_PACKET_TYPE_DIRECTED       (1 << 0)
#define NDIS_PACKET_TYPE_MULTICAST      (1 << 1)
#define NDIS_PACKET_TYPE_BROADCAST      (1 << 2)
#define NDIS_PACKET_TYPE_ALL_MULTICAST  (1 << 3)

#define USBD_PORT_ENABLED               (1 << 0)
#define USBD_PORT_CONNECTED             (1 << 1)
#define USBD_STATUS_DEVICE_GONE         (-ENOENT)
#define USBD_STATUS_CANCELED            (-ENOENT)
#define USBD_STATUS_PENDING             (-EINPROGRESS)

typedef struct _UNICODE_STRING {
    USHORT  Length;
    USHORT  MaximumLength;
    PUCHAR  Buffer;
} UNICODE_STRING, *PUNICODE_STRING;
typedef UNICODE_STRING  ANSI_STRING, *PANSI_STRING;

typedef union _LARGE_INTEGER {
    struct {
        long LowPart;
        long  HighPart;
    };
    struct {
        long LowPart;
        long  HighPart;
    }u;
    long long QuadPart;
}LARGE_INTEGER, *PLARGE_INTEGER;

typedef struct LINUX_NDIS_EVENT {
    ULONG                  SignalState;
    wait_queue_head_t      NdisEvent;
}NDIS_EVENT, *PNDIS_EVENT;
typedef struct LINUX_NDIS_EVENT  KEVENT;

struct _ATHUSB_USB_ADAPTER;
typedef struct LINUX_KTIMER {
    struct _ATHUSB_USB_ADAPTER *pAthUsbAdapter;
    struct timer_list   osTimer;
    A_UINT32            timeVal;
    PFN_USBTIMER_CALLBACK  pTimerFunc;
}KTIMER,*PKTIMER;

typedef struct LINUX_NDIS_SPIN_LOCK {
    KSPIN_LOCK      SpinLock;
    KIRQL           OldIrql;
}NDIS_SPIN_LOCK, *PNDIS_SPIN_LOCK;


//
// A structure representing the instance information associated with
// this particular device.
//
typedef struct _DEVICE_EXTENSION {
    UCHAR                   RecvEndPoints[10];
    UCHAR                   SendEndPoints[10];

    PVOID                   FirmwareObject;
} DEVICE_EXTENSION, *PDEVICE_EXTENSION;

typedef struct _DEVICE_OBJECT {
    PUSB_DEVICE                 pUsbDevice;
    PUSB_INTERFACE              pUsbInterface;
    PVOID                       pStubHandle;
    struct _DEVICE_EXTENSION    DeviceExtension;
}DEVICE_OBJECT, *PDEVICE_OBJECT;

/* USB Device definitions */
typedef struct usb_device_descriptor    USB_DEVICE_DESCRIPTOR, *PUSB_DEVICE_DESCRIPTOR;
typedef struct usb_config_descriptor    USB_CONFIGURATION_DESCRIPTOR, *PUSB_CONFIGURATION_DESCRIPTOR;
typedef struct usb_interface_descriptor USBD_INTERFACE_INFORMATION, *PUSBD_INTERFACE_INFORMATION;
typedef struct usb_interface_descriptor USB_INTERFACE_DESCRIPTOR, *PUSB_INTERFACE_DESCRIPTOR;
typedef struct usb_endpoint_descriptor  USBD_PIPE_INFORMATION,*PUSBD_PIPE_INFORMATION;

/* List Entry Definitions */
#define InitializeListHead(ListHead)        INIT_LIST_HEAD((ListHead))
#define InsertTailList(ListHead,Entry)      list_add_tail((Entry),(ListHead))
#define IsListEmpty(ListHead)               list_empty((ListHead))
#define RemoveEntryList(ListEntry)          list_del((ListEntry));
#define Flink                               next
#define Blink                               prev

#define NdisReadConfiguration(pStatus, pParamValue, ConfigHandle, pRegVarName, pRegVarType)         (*(pStatus) = NDIS_STATUS_UNSUCCESSFUL)
#define NdisCloseConfiguration(ConfigHandle)
#define NdisAllocateSpinLock(pSpinLock)     spin_lock_init(pSpinLock)
#define NdisAcquireSpinLock(pSpinLock)      spin_lock(pSpinLock)
#define NdisReleaseSpinLock(pSpinLock)      spin_unlock(pSpinLock)
#define NdisFreeSpinLock(pSinLock)
#define NdisMUnmapIoSpace(NicHandle, baseAddress, mpLength)
#define NdisMFreeMapRegisters(NicHandle)
#define NdisMSetInformationComplete(NicHandle, Status)
#define NdisMResetComplete(NicHandle, Status, Flag)
#define NdisGetSystemUpTime(pSystemUpTime)  (*pSystemUpTime = tickGet())
#define NdisMSleep(uSeconds)                do {            \
    if (uSeconds > 20000)                                   \
        mdelay (uSeconds/1000);                             \
    else                                                    \
        udelay(uSeconds);                                   \
}while(0)
#define NdisAllocatePacketPool(Status, PoolHandle, NumDescs, Length)    \
            (*(Status) = NDIS_STATUS_SUCCESS)
#define NdisFreePacketPool(PoolHandle)
#define NdisFreePacket(pOSPacket)      dev_kfree_skb_any(pOSPacket)
#define NdisAllocateBufferPool(Status, PoolHandle, NumDescs)            \
            (*(Status) = NDIS_STATUS_SUCCESS)
#define NdisFreeBufferPool(PoolHandle)
#define NdisMSendComplete(pNetDevice,pPacket,Status)  dev_kfree_skb_any(pPacket)
#define NDIS_STRING_CONST(x)     (x)

static __inline__ PLIST_ENTRY RemoveHeadList(PLIST_ENTRY ListHead) {
    PLIST_ENTRY ListEntry;
    ListEntry = ListHead->next;
    ListHead->next = ListEntry->next;
    ListEntry->next->prev = ListHead;
    return (ListEntry);
}

static __inline__ void ExInterlockedInsertTailList(PLIST_ENTRY pListHead,PLIST_ENTRY pListEntry,PKSPIN_LOCK pAthLock) {

    spin_lock(pAthLock);
    InsertTailList(pListHead, pListEntry);
    spin_unlock(pAthLock);
}

static __inline__ PLIST_ENTRY ExInterlockedRemoveHeadList(PLIST_ENTRY ListHead, PKSPIN_LOCK pAthLock) {
    PLIST_ENTRY ListEntry;

    spin_lock(pAthLock);
    ListEntry = RemoveHeadList(ListHead);
    spin_unlock(pAthLock);
    return (ListEntry);
}

#define CONTAINING_RECORD(Address,Type,Field)   ((Type *)((PCHAR)(Address) - (PCHAR)(&((Type *)0)->Field)))
#define FIELD_OFFSET(Type,Field)   ((A_UINT32)(&(((Type *)0)->Field)))

/* Atomic Functions */
#define InterlockedIncrement(Addend)            atomic_inc(Addend)
#define InterlockedDecrement(Addend)            atomic_dec(Addend)
#define InterlockedDecrementAndTest(Addend)     atomic_dec_and_test(Addend)
#define InterlockedExchange(Addend,Value)       atomic_set(Addend,Value);
#define athReadAtomic(AtomicVar)                atomic_read(&(AtomicVar))

#define NdisInterlockedIncrement(Addend)        atomic_inc(Addend)
#define NdisInterlockedDecrement(Addend)        atomic_dec(Addend)

/* Other Functions */
#define RtlZeroMemory(Destination,Length)   memset(Destination,0,Length)
#define RtlCopyMemory(Destination,Source,Length)   \
            memcpy(Destination,Source,Length)

/* Dummy Functions for Linux */
#define NDIS_ASSERT(x)
#define IoFreeIrp(PIRP)
#define IoReuseIrp(PIRP,STATUS)
#define IoQueueWorkItem(IoWorkItem, Routine, QueueType, Context)
#define PAGED_CODE()
#define KernelMode  0
#define Executive   0
#define NonPagedPool   0
#define PagedPool   1

int usb_get_string(struct usb_device *dev, unsigned short langid, unsigned char index, void *buf, int size);

/*
#if DBG
extern int asserts;
#undef ASSERT
#define oldAssert( exp )        ((!(exp)) ?                 \
     (printk("Assertion failed %s,%s,%s,line=%d\n",#exp,__FILE__,__FUNCTION__,__LINE__),FALSE) : TRUE)
#define ASSERT(x)   if (asserts)    oldAssert(x)
#else
#define ASSERT(x)
#endif */
#endif /* _LINUXDRV_H */

