/*************************************************************************
 * Copyright © 2000-2002 Atheros Communications, Inc., All Rights Reserved
 *
 * Atheros and the Atheros logo and design are trademarks of Atheros
 * Communications, Inc.
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/include/linuxioctl.h#9 $
 *
 * Linux Wireless Extension Ioctl macros shared by WPA supplicant
 */

#ifndef _LINUXIOCTL_H_
#define _LINUXIOCTL_H_

#ifdef __cplusplus
extern "C" {
#endif

#define MLME_REQUEST_DEAUTH         1
#define MLME_REQUEST_DISASSOC       2

struct athusb_mlme {
    unsigned char   mlmeRequest;
    unsigned short  mlmeReason;
};

struct athusb_wpakey {
    unsigned char   wpaAlgorithm;
    unsigned char   Address[ETH_ALEN];
    unsigned int    KeyIndex;
    unsigned int    DefaultTx;
    unsigned char   Sequence[IW_ENCODING_TOKEN_MAX];
    unsigned int    SeqLength;
    unsigned char   KeyData[IW_ENCODING_TOKEN_MAX];
    unsigned int    KeyLength;
};

#define ATHUSB_IOCTL_SET_VALUE       (SIOCIWFIRSTPRIV+0)
#define ATHUSB_IOCTL_GET_VALUE       (SIOCIWFIRSTPRIV+1)
#define ATHUSB_IOCTL_SETMLME         (SIOCIWFIRSTPRIV+2)
#define ATHUSB_IOCTL_GET_DEVICE_INFO (SIOCIWFIRSTPRIV+3)
#define ATHUSB_IOCTL_SETKEY          (SIOCIWFIRSTPRIV+4)
#define ATHUSB_IOCTL_GET_ATH_LIST    (SIOCIWFIRSTPRIV+5)
#define ATHUSB_IOCTL_GET_NETSUPPORT  (SIOCIWFIRSTPRIV+7)
#define ATHUSB_IOCTL_SET_COUNTRY     (SIOCIWFIRSTPRIV+8)
#define ATHUSB_IOCTL_GET_COUNTRY     (SIOCIWFIRSTPRIV+9)

#define ATHUSB_IOCTL_LEAP_USER       (SIOCIWFIRSTPRIV+12)
#define ATHUSB_IOCTL_LEAP_PASS       (SIOCIWFIRSTPRIV+13)
#define ATHUSB_IOCTL_SET_OID         (SIOCIWFIRSTPRIV+14)
#define ATHUSB_IOCTL_GET_OID         (SIOCIWFIRSTPRIV+15)

enum {
    ATHUSB_SUBIOCTL_NETBAND         = 1,
    ATHUSB_SUBIOCTL_ADHOCBAND,
    ATHUSB_SUBIOCTL_SHORTPREAMBLE,
    ATHUSB_SUBIOCTL_ABOLT,
    ATHUSB_SUBIOCTL_CALIBRATION_TIME,
    ATHUSB_SUBIOCTL_TRIGGER_THRESHOLD,
    ATHUSB_SUBIOCTL_AUTHTYPE,
    ATHUSB_SUBIOCTL_PRIVACY,
    ATHUSB_SUBIOCTL_ENCRYPTION,
    ATHUSB_SUBIOCTL_WPA,
    ATHUSB_SUBIOCTL_CHANNEL,
    ATHUSB_SUBIOCTL_XMIT_DATARATE,
    ATHUSB_SUBIOCTL_RECV_DATARATE,
    ATHUSB_SUBIOCTL_POWERSAVE_STATE,
    ATHUSB_SUBIOCTL_SIGNAL_QUALITY,
    ATHUSB_SUBIOCTL_NOISE_FLOOR,
    ATHUSB_SUBIOCTL_DRIVER_VERSION,
    ATHUSB_SUBIOCTL_LIST_SCAN,
    ATHUSB_SUBIOCTL_TRANSMIT_POWER,
    ATHUSB_SUBIOCTL_VENDOR_VERSION,
    ATHUSB_SUBIOCTL_RADIO_ENABLE,
    ATHUSB_SUBIOCTL_NETTYPE_INUSE,
    ATHUSB_SUBIOCTL_NETWORK_TYPE,
    ATHUSB_SUBIOCTL_ANTENNA_SWITCH,
    ATHUSB_SUBIOCTL_REGULATORY,
    ATHUSB_SUBIOCTL_REGULATORY_DOMAIN,
    ATHUSB_SUBIOCTL_BKSCAN,
    ATHUSB_SUBIOCTL_LEAPENABLED,
    ATHUSB_SUBIOCTL_LEAPDRIVER,

    ATHUSB_SUBIOCTL_POWERDEBUG,
    ATHUSB_SUBIOCTL_RECEIVEDEBUG,
    ATHUSB_SUBIOCTL_TRANSMITDEBUG,
    ATHUSB_SUBIOCTL_MLMEDEBUG,
    ATHUSB_SUBIOCTL_LOCKDEBUG,
    ATHUSB_SUBIOCTL_CSERVDEBUG,
    ATHUSB_SUBIOCTL_REG_UPDATE,
    ATHUSB_SUBIOCTL_REGCAPBITS
};

typedef enum _IEEE80211_AUTHENTICATION_MODE
{
    AuthModeOpen,
    AuthModeShared,
    AuthModeAutoSwitch,
    AuthModeWPA,
    AuthModeWPAPSK,
    AuthModeWPANone,
    AuthModeMax
} IEEE80211_AUTHENTICATION_MODE;

typedef enum _PRIVACY_FILTER
{
    PrivFilterAcceptAll,
    PrivFilter8021xWEP
} PRIVACY_FILTER, *PPRIVACY_FILTER;


typedef enum _ENCRYPTION_ALGORITHM
{
    EncryptionDisabled,
    EncryptionWEP,
    EncryptionAESOCB,
    EncryptionAESCCM,
    EncryptionCKIP,
    EncryptionTKIP,
    EncryptionAuto,
} ENCRYPTION_ALGORITHM;

typedef enum _ATH_802_11_NETWORK_TYPE
{
    Ath802_11FH,
    Ath802_11DS,
    Ath802_11OFDM5,
    Ath802_11OFDM24,
    Ath802_11Automode,
    Ath802_11NetworkTypeMax
} ATH_802_11_NETWORK_TYPE, *PATH_802_11_NETWORK_TYPE;

typedef struct _ATH_802_11_NETWORK_TYPE_LIST
{
    unsigned long              NumberOfItems;  // in list below, at least 1
    ATH_802_11_NETWORK_TYPE    NetworkType [1];
} ATH_802_11_NETWORK_TYPE_LIST, *PATH_802_11_NETWORK_TYPE_LIST;


typedef struct _Atheros5000_DeviceInfo
{
    // 
    unsigned short AthVendorID;
    #define Atheros5000_DeviceInfo_AthVendorID_SIZE sizeof(unsigned short)
    #define Atheros5000_DeviceInfo_AthVendorID_ID 1

    // 
    unsigned short AthDeviceID;
    #define Atheros5000_DeviceInfo_AthDeviceID_SIZE sizeof(unsigned short)
    #define Atheros5000_DeviceInfo_AthDeviceID_ID 2

    // 
    unsigned short AthSubVendorID;
    #define Atheros5000_DeviceInfo_AthSubVendorID_SIZE sizeof(unsigned short)
    #define Atheros5000_DeviceInfo_AthSubVendorID_ID 3

    // 
    unsigned short AthSubVendor_DeviceID;
    #define Atheros5000_DeviceInfo_AthSubVendor_DeviceID_SIZE sizeof(unsigned short)
    #define Atheros5000_DeviceInfo_AthSubVendor_DeviceID_ID 4

    // 
    unsigned short AthMacRev;
    #define Atheros5000_DeviceInfo_AthMacRev_SIZE sizeof(unsigned short)
    #define Atheros5000_DeviceInfo_AthMacRev_ID 5

    // 
    unsigned short AthPhyRev;
    #define Atheros5000_DeviceInfo_AthPhyRev_SIZE sizeof(unsigned short)
    #define Atheros5000_DeviceInfo_AthPhyRev_ID 6

    // 
    unsigned short AthAnalog5GhzRev;
    #define Atheros5000_DeviceInfo_AthAnalog5GhzRev_SIZE sizeof(unsigned short)
    #define Atheros5000_DeviceInfo_AthAnalog5GhzRev_ID 7

    // 
    unsigned short AthAnalog2GhzRev;
    #define Atheros5000_DeviceInfo_AthAnalog2GhzRev_SIZE sizeof(unsigned short)
    #define Atheros5000_DeviceInfo_AthAnalog2GhzRev_ID 8

    // 
    unsigned long AthHwCapWirelessModes;
    #define Atheros5000_DeviceInfo_AthHwCapWirelessModes_SIZE sizeof(unsigned long)
    #define Atheros5000_DeviceInfo_AthHwCapWirelessModes_ID 9

    // 
    unsigned long AthInfraWirelessModes;
    #define Atheros5000_DeviceInfo_AthInfraWirelessModes_SIZE sizeof(unsigned long)
    #define Atheros5000_DeviceInfo_AthInfraWirelessModes_ID 10

    // 
    unsigned long AthAdhocWirelessModes;
    #define Atheros5000_DeviceInfo_AthAdhocWirelessModes_SIZE sizeof(unsigned long)
    #define Atheros5000_DeviceInfo_AthAdhocWirelessModes_ID 11

    // 
    unsigned long AthNicSKU;
    #define Atheros5000_DeviceInfo_AthNicSKU_SIZE sizeof(unsigned long)
    #define Atheros5000_DeviceInfo_AthNicSKU_ID 12

} Atheros5000_DeviceInfo, *PAtheros5000_DeviceInfo;

typedef struct _Atheros5000_BssInfo
{
    // 
    unsigned char Bssid[6];
    #define Atheros5000_BssInfo_Bssid_SIZE sizeof(unsigned char[6])
    #define Atheros5000_BssInfo_Bssid_ID 1

    // 
    unsigned char Reserved[2];
    #define Atheros5000_BssInfo_Reserved_SIZE sizeof(unsigned char[2])
    #define Atheros5000_BssInfo_Reserved_ID 2

    // 
    char Ssid[32];
    #define Atheros5000_BssInfo_Ssid_SIZE sizeof(char[32])
    #define Atheros5000_BssInfo_Ssid_ID 3

    // 
    unsigned long Privacy;
    #define Atheros5000_BssInfo_Privacy_SIZE sizeof(unsigned long)
    #define Atheros5000_BssInfo_Privacy_ID 4

    // 
    long Rssi;
    #define Atheros5000_BssInfo_Rssi_SIZE sizeof(long)
    #define Atheros5000_BssInfo_Rssi_ID 5

    // 
    unsigned long BeaconInterval;
    #define Atheros5000_BssInfo_BeaconInterval_SIZE sizeof(unsigned long)
    #define Atheros5000_BssInfo_BeaconInterval_ID 6

    // 
    unsigned long AtimWindow;
    #define Atheros5000_BssInfo_AtimWindow_SIZE sizeof(unsigned long)
    #define Atheros5000_BssInfo_AtimWindow_ID 7

    // 
    unsigned long Channel;
    #define Atheros5000_BssInfo_Channel_SIZE sizeof(unsigned long)
    #define Atheros5000_BssInfo_Channel_ID 8

    // 
    unsigned long NetworkType;
    #define Atheros5000_BssInfo_NetworkType_SIZE sizeof(unsigned long)
    #define Atheros5000_BssInfo_NetworkType_ID 9

    // 
    unsigned char SupportedRates[8];
    #define Atheros5000_BssInfo_SupportedRates_SIZE sizeof(unsigned char[8])
    #define Atheros5000_BssInfo_SupportedRates_ID 10

    // 
    unsigned long version;
    #define Atheros5000_BssInfo_version_SIZE sizeof(unsigned long)
    #define Atheros5000_BssInfo_version_ID 11

    // 
    char xrCapable;
    #define Atheros5000_BssInfo_xrCapable_SIZE sizeof(char)
    #define Atheros5000_BssInfo_xrCapable_ID 12

    // 
    char xrCurrent;
    #define Atheros5000_BssInfo_xrCurrent_SIZE sizeof(char)
    #define Atheros5000_BssInfo_xrCurrent_ID 13

    // 
    unsigned long superCap;
    #define Atheros5000_BssInfo_superCap_SIZE sizeof(unsigned long)
    #define Atheros5000_BssInfo_superCap_ID 14

    // 
    unsigned long trailer;
    #define Atheros5000_BssInfo_trailer_SIZE sizeof(unsigned long)
    #define Atheros5000_BssInfo_trailer_ID 15

} Atheros5000_BssInfo, *PAtheros5000_BssInfo;

/*
 * Version of Atheros5000_BssInfo Structure. Increment it when the structure
 * changes. There was no Version 1 , therefore version 1 is derived from the 
 * size passed
 */
typedef enum athBssInfoVersion {
    ATH_BSS_INFO_VERSION_1 = 1,
    ATH_BSS_INFO_VERSION_2 = 2
} ATH_BSS_INFO_VERSION_TYPE;

#define ATH_BSS_INFO_VERSION_CURRENT   ATH_BSS_INFO_VERSION_2

#ifdef __cplusplus
}
#endif

#endif /* _LINUXIOCTL_H_ */
