/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/include/wlantype.h#5 $
 *
 * Copyright © 2000-2003 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Basic datatypes for each platform
 */

#ifndef _WLANTYPE_H_
#define _WLANTYPE_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifdef NT_HW
#ifndef WIN32
#define WIN32
#endif

/* Bring in our include file for the NT environment */
#include "ntdefs.h"
#endif  /* NT_HW */

#ifdef PCI_NDIS
#ifndef WIN32
#define WIN32
#endif

/* Bring in our include file for the NDIS environment */
#include "ndisdefs.h"
#endif  /* PCI_NDIS */

/* No OS's have this define */
typedef const unsigned char     cu8;
typedef union wlanMACAddr WLAN_MACADDR;

/*
 * Following conditional compiles need to be correct. This is just a sample.
 * It also needs to be corrected for bit ordering for the CPU.
 */
#ifdef WIN32
#undef BIG_ENDIAN

typedef char                    A_CHAR;
typedef unsigned char           A_UCHAR;
typedef A_CHAR                  A_INT8;
typedef A_UCHAR                 A_UINT8;
typedef short                   A_INT16;
typedef unsigned short          A_UINT16;
typedef long int                A_INT32;
typedef unsigned long int       A_UINT32;
typedef unsigned long int       A_UINT;

typedef unsigned char           u8;
typedef unsigned short          u16;
typedef unsigned int            u32;

typedef A_UCHAR                 A_BOOL;
typedef void *                  OS_DEVICE_ID;

typedef __int64                 A_INT64;
typedef unsigned __int64        A_UINT64;
#define A_LL                    "I64"

typedef A_UINT64                A_LONGSTATS;

typedef unsigned __int64        u64;
typedef __int64                 s64;

typedef char *                  A_STRING;

/* With NdisInterlocked functions there is no difference between a normal
 * and atomic variable, but its not true for linux. create a new type and
 * leave it to default for windows */
typedef A_UINT32                A_ATOMIC;
#endif /* WIN32 */

#ifdef VXWORKS
/* Bring in our include file for the VxWorks environment */
#include "vxdefs.h"

typedef signed char             A_CHAR;
typedef A_CHAR                  A_INT8;
typedef INT16                   A_INT16;
typedef INT32                   A_INT32;

typedef UINT8                   A_UINT8;
typedef UINT16                  A_UINT16;
typedef UINT32                  A_UINT32;

typedef UCHAR                   A_UCHAR;
typedef USHORT                  A_USHORT;
typedef UINT                    A_UINT;
typedef ULONG                   A_ULONG;

typedef BOOL                    A_BOOL;
typedef ARGINT                  A_ARGINT;

typedef long long               A_INT64;
typedef unsigned long long      A_UINT64;
#define A_LL                    "ll"

typedef A_UINT32                A_LONGSTATS;    /* compiler/libc issues */

typedef unsigned long long      u64;
typedef long long               s64;
#endif /* VXWORKS */


#ifdef Linux
typedef char                    A_CHAR;
typedef A_CHAR                  A_INT8;
typedef short                   A_INT16;
typedef long                    A_INT32;

typedef unsigned char           A_UCHAR;
typedef A_UCHAR                 A_UINT8;
typedef unsigned short          A_UINT16;
typedef unsigned int            A_UINT32;
typedef unsigned int            A_UINT;
typedef unsigned int            UINT, *PUINT;

typedef A_UINT8                 UINT8;
typedef A_UINT16                UINT16;
typedef A_UINT32                UINT32;

typedef int                     A_BOOL;
typedef int                     BOOLEAN, *PBOOLEAN;

typedef long long               A_INT64;
typedef unsigned long long      A_UINT64;
typedef unsigned long           ULONGLONG;
#define A_LL                    "ll"

typedef A_UINT64                A_LONGSTATS;

typedef signed char             CHAR, *PCHAR;
typedef unsigned char           UCHAR, *PUCHAR;
typedef unsigned short          USHORT, *PUSHORT;
typedef unsigned long           ULONG, *PULONG;

typedef void                    VOID;
#endif /* Linux */

#ifdef ECOS

typedef char                    A_CHAR;
typedef A_CHAR                  A_INT8;
typedef short                   A_INT16;
typedef long                    A_INT32;

typedef unsigned char           A_UCHAR;
typedef A_UCHAR                 A_UINT8;
typedef unsigned short          A_UINT16;
typedef unsigned long           A_UINT32;
typedef unsigned long           A_UINT;
typedef unsigned long           UINT;

typedef int                     A_BOOL;

typedef unsigned long           A_ULONG;
typedef long long               A_INT64;
typedef unsigned long long      A_UINT64;
typedef unsigned long           ULONGLONG;
#define A_LL                    "ll"

typedef A_UINT64                A_LONGSTATS;

typedef char *                  A_STRING;

#endif /* ECOS */

/* Endianness byte swapping functions */

#define A_swab16(x) \
        ((A_UINT16)( \
                (((A_UINT16)(x) & (A_UINT16)0x00ffU) << 8) | \
                (((A_UINT16)(x) & (A_UINT16)0xff00U) >> 8) ))
#define A_swab32(x) \
        ((A_UINT32)( \
                (((A_UINT32)(x) & (A_UINT32)0x000000ffUL) << 24) | \
                (((A_UINT32)(x) & (A_UINT32)0x0000ff00UL) <<  8) | \
                (((A_UINT32)(x) & (A_UINT32)0x00ff0000UL) >>  8) | \
                (((A_UINT32)(x) & (A_UINT32)0xff000000UL) >> 24) ))
#ifdef WIN32
/* Windows chose not to implement the standard ULL constant suffix */
#define A_swab64(x) \
        ((A_UINT64)( \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x00000000000000ff) << 56) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x000000000000ff00) << 40) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x0000000000ff0000) << 24) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x00000000ff000000) <<  8) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x000000ff00000000) >>  8) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x0000ff0000000000) >> 24) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x00ff000000000000) >> 40) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0xff00000000000000) >> 56) ))
#else /* WIN32 */
#define A_swab64(x) \
        ((A_UINT64)( \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x00000000000000ffULL) << 56) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x000000000000ff00ULL) << 40) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x0000000000ff0000ULL) << 24) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x00000000ff000000ULL) <<  8) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x000000ff00000000ULL) >>  8) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x0000ff0000000000ULL) >> 24) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0x00ff000000000000ULL) >> 40) | \
                (A_UINT64)(((A_UINT64)(x) & (A_UINT64)0xff00000000000000ULL) >> 56) ))
#endif /* WIN32 */

#ifdef BIG_ENDIAN

#define cpu2le64(x) A_swab64((x))
#define le2cpu64(x) A_swab64((x))
#define cpu2le32(x) A_swab32((x))
#define le2cpu32(x) A_swab32((x))
#define cpu2le16(x) A_swab16((x))
#define le2cpu16(x) A_swab16((x))
#define cpu2be64(x) ((A_UINT64)(x))
#define be2cpu64(x) ((A_UINT64)(x))
#define cpu2be32(x) ((A_UINT32)(x))
#define be2cpu32(x) ((A_UINT32)(x))
#define cpu2be16(x) ((A_UINT16)(x))
#define be2cpu16(x) ((A_UINT16)(x))

#else /* Little_Endian */

#define cpu2le64(x) ((A_UINT64)(x))
#define le2cpu64(x) ((A_UINT64)(x))
#define cpu2le32(x) ((A_UINT32)(x))
#define le2cpu32(x) ((A_UINT32)(x))
#define cpu2le16(x) ((A_UINT16)(x))
#define le2cpu16(x) ((A_UINT16)(x))
#define cpu2be64(x) A_swab64((x))
#define be2cpu64(x) A_swab64((x))
#define cpu2be32(x) A_swab32((x))
#define be2cpu32(x) A_swab32((x))
#define cpu2be16(x) A_swab16((x))
#define be2cpu16(x) A_swab16((x))

#endif /* Endianness */

#ifdef __GNUC__
#define __ATTRIB_PACK           __attribute__ ((packed))
#define __ATTRIB_PRINTF         __attribute__ ((format (printf, 1, 2)))
#define __ATTRIB_NORETURN       __attribute__ ((noreturn))
#define __ATTRIB_ALIGN(x)       __attribute__ ((aligned(x)))
#define INLINE                  __inline__
#else /* Not GCC */
#define __ATTRIB_PACK
#define __ATTRIB_PRINTF
#define __ATTRIB_NORETURN
#define __ATTRIB_ALIGN(x)
#define INLINE                  __inline
#endif /* End __GNUC__ */

/*
 * Driver and protocol related things that will be required by
 * all apps and drivers.
 */

/* Generic error codes that can be used by hw, sta, ap, sim, dk
 * and any other environments. Since these are enums, feel free to
 * add any more codes that you need.
 */

typedef enum {
    A_ERROR = -1,               /* Generic error return */
    A_OK = 0,                   /* success */
                                /* Following values start at 1 */
    A_DEVICE_NOT_FOUND,         /* not able to find PCI device */
    A_NO_MEMORY,                /* not able to allocate memory, not available */
    A_MEMORY_NOT_AVAIL,         /* memory region is not free for mapping */
    A_NO_FREE_DESC,             /* no free descriptors available */
    A_BAD_ADDRESS,              /* address does not match descriptor */
    A_WIN_DRIVER_ERROR,         /* used in NT_HW version, if problem at init */
    A_REGS_NOT_MAPPED,          /* registers not correctly mapped */
    A_EPERM,                    /* Not superuser */
    A_EACCES,                   /* Access denied */
    A_ENOENT,                   /* No such entry, search failed, etc. */
    A_EEXIST,                   /* The object already exists (can't create) */
    A_EFAULT,                   /* Bad address fault */
    A_EBUSY,                    /* Object is busy */
    A_EINVAL,                   /* Invalid parameter */
    A_EMSGSIZE,                 /* Inappropriate message buffer length */
    A_ECANCELED,                /* Operation canceled */
    A_ENOTSUP,                  /* Operation not supported */
    A_ECOMM,                    /* Communication error on send */
    A_EPROTO,                   /* Protocol error */
    A_ENODEV,                   /* No such device */
    A_NO_RESOURCE,              /* No resources for requested operation */
    A_HARDWARE,                 /* Hardware failure */
    A_PENDING,                  /* Asynchronous routine; will send up results later (typically in callback) */
    A_EBADCHANNEL,              /* The channel cannot be used */
    A_DECRYPT_ERROR,            /* Decryption error */
    A_DECOMP_ERROR,             /* Decompression error */
    A_PHY_ERROR,                /* RX PHY error */
    A_CRC_ERROR,                /* RX CRC error */
    A_CONSUMED,                 /* Object was consumed */
    A_TIMEOUT                   /* Request is timeout */
} A_STATUS;

#define A_SUCCESS(x)        (x == A_OK)
#define A_FAILED(x)         (!A_SUCCESS(x))

/*
 * Define some useful macros
 */

#if !defined(TRUE)
#define FALSE 0
#define TRUE  1
#endif

#define A_MAX(x, y)         (((x) > (y)) ? (x) : (y))
#define A_MIN(x, y)         (((x) < (y)) ? (x) : (y))
#define A_ABS(x)            (((x) >= 0) ? (x) : (-(x)))
#define A_LPF(x, y, len)    ((x) ? (((x) * ((len) - 1) + (y)) / (len)) : (y))
#define A_ROUNDUP(x, y)     ((((x) + ((y) - 1)) / (y)) * (y))
#define A_ROUNDUP_PAD(x, y) (A_ROUNDUP(x, y) - (x))
#define MAKE_BOOL(x)        ((x) ? TRUE : FALSE)
#define A_TOLOWER(c)        (((c) >= 'A' && (c) <= 'Z') ? ((c)-'A'+'a') : (c))
#define A_TOUPPER(c)        (((c) >= 'a' && (c) <= 'z') ? ((c)-'a'+'A') : (c))
#define TU_TO_MS(x)         ((x) * 1024 / 1000)
#define TU_TO_US(x)         ((x) << 10)
#define MS_TO_TU(x)         ((x) * 1000 / 1024)
#define KHZ_TO_MHZ(x)       ((x) / 1000)
#define MHZ_TO_KHZ(x)       ((x) * 1000)

/* Create a typedef for an opaque "handle" or "cookie" with strong typing. */
#define HANDLE_TYPEDEF(name) \
struct name##_s; \
typedef struct name##_s *name;

/*
 * The following macros are used for manipulating extended-precision values.
 * A_EP_RND returns the value rounded to normal precision, and A_EP_MUL
 * is used to multiply up from normal to extended precision.
 */
#define A_EP_RND(x, mul)   ((((x)%(mul)) >= ((mul)/2)) ? ((x) + ((mul) - 1)) / (mul) : (x)/(mul))
#define A_EP_MUL(x, mul)   ((x) * (mul))

/*
 * The following macros define the number of bits and masks
 */
#define NUM_BITS_NBL 4
#define NUM_BITS_BYTE 8
#define NBL_MASK   0x0f
/*
 * Enumerated types
 */
typedef enum {
    DISCONNECT_NOW,
    DISCONNECT_DELAYED
} DISCONNECT_ENUM;

typedef enum {
    REMOVE_BSS,
    DONT_REMOVE_BSS
} REMOVE_BSS_ENUM;

typedef enum {
    SEND_DEAUTH,
    DONT_SEND_DEAUTH
} SEND_DEAUTH_ENUM;

typedef enum {
    RESET_INC_CTR,
    RESET_DONT_INC_CTR
} RESET_CTR_ENUM;

typedef enum {
    DO_WAIT,
    DONT_WAIT
} DRAIN_ENUM;

typedef enum {
    DO_COMPLETE,
    DONT_COMPLETE
} COMPLETION_ENUM;

typedef enum {
    DO_CLEAR_TX_Q,
    DONT_CLEAR_TX_Q
} CLEAR_TX_Q_ENUM;

typedef enum {
    ANTENNA_CONTROLLABLE,
    ANTENNA_FIXED_A,
    ANTENNA_FIXED_B,
    ANTENNA_DUMMY_MAX
} ANTENNA_CONTROL;

typedef enum {
    ATH_DEV_TYPE_UNDEFINED,
    ATH_DEV_TYPE_CARDBUS,
    ATH_DEV_TYPE_PCI,
    ATH_DEV_TYPE_MINIPCI,
    ATH_DEV_TYPE_AP,
    ATH_DEV_TYPE_MAX
} ATH_DEV_TYPE;

#if defined(ECOS)
#include "ecosdrv.h"
#include "stdlib.h"
#include "string.h"
#elif defined (Linux)
#include <linux/config.h>
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#define MODVERSIONS
#endif
#include <linux/version.h>
#ifdef MODVERSIONS
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0))
#include <linux/modversions.h>
#endif
#endif
#include <linux/kernel.h>
#include <linux/module.h>
#ifndef __ATHUSB_KERNEL_MODULE__
#define __NO_VERSION__
#endif
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/slab.h>
#include <linux/mm.h>
#include <linux/usb.h>
#include <linux/list.h>
#include <asm/atomic.h>
#include <linux/random.h>
#include <linux/skbuff.h>
#include <linux/if_ether.h>
#include <linux/if_arp.h>
#include <linux/netdevice.h>
#include <linux/wireless.h>
#include <linux/etherdevice.h>
#include "linuxdrv.h"
#include "linuxdefs.h"
#endif /* ECOS */

#ifdef __cplusplus
}
#endif

#endif /* _WLANTYPE_H_ */

