/*
 * Copyright (c) 2004 Atheros Communications, Inc., All Rights Reserved
 *
 * athusrxtx.h -- Atheros USB Driver header file
 * 
 */
#ifndef ATHUSB_RXTX_H
#define ATHUSB_RXTX_H

#ifdef Linux

#define ATHUSB_MAX_IRP_NUM                  50

#define athInitializeSpinLock(AthLock,rwlabel)          do {        \
	spin_lock_init(&((AthLock).spinLock));                          \
    atomic_set(&((AthLock).num),0);                                 \
	(AthLock).label = rwlabel;                                      \
}while(0)

#define athAcquireSpinLock(pAthLock, pOldIrql)          do {        \
    InterlockedIncrement(&((pAthLock)->num));                       \
    athUsbDbgPrint(ATHUSB_LOCK,                                     \
         ("==>%s() line%d: Acquire lock%d, num = %d\n", __FUNCTION__,\
                     __LINE__,(pAthLock)->label,atomic_read(&((pAthLock)->num))));  \
    spin_lock(&((pAthLock)->spinLock));                            \
} while(0)

#define athReleaseSpinLock(pAthLock, newIrql)         do {          \
    InterlockedDecrement(&((pAthLock)->num));                       \
    athUsbDbgPrint(ATHUSB_LOCK,                                     \
         ("==>%s() line%d: Release lock%d, num = %d\n", __FUNCTION__,\
                   __LINE__,(pAthLock)->label,atomic_read(&((pAthLock)->num))));    \
    spin_unlock(&((pAthLock)->spinLock));                           \
} while(0)

#endif  /* !Linux */

NTSTATUS
athUsbAllocTransferObj(IN PATHUSB_USB_ADAPTER   pUsbAdapter,
                       IN BOOLEAN               bRead);

VOID 
athUsbQueueIdleIrp(IN PATHUSB_USB_ADAPTER     pUsbAdapter,
                   IN PATHUSB_RXTX_OBJECT     pTransferObject,
                   IN BOOLEAN                 bRead);

VOID
athUsbInsertPendingIrp(IN PATHUSB_USB_ADAPTER     pUsbAdapter,
                      IN PATHUSB_RXTX_OBJECT     pTransferObject,
                      IN BOOLEAN                 bRead);

NTSTATUS
athUsbRemoveIdleIrp(IN PATHUSB_USB_ADAPTER      pUsbAdapter,
                    IN OUT PATHUSB_RXTX_OBJECT  *ppTransferObject,
                    IN BOOLEAN                  bRead);

NTSTATUS
athUsbAllocIrpUrbPool(IN PATHUSB_USB_ADAPTER   pUsbAdapter);

VOID
athUsbFreeIrpUrbPool(IN PATHUSB_USB_ADAPTER     pUsbAdapter);

VOID
athUsbCancelAllIrp(IN PATHUSB_USB_ADAPTER     pUsbAdapter,
                   IN A_BOOL                  bAbort);

VOID
athUsbCancelIrp(IN PATHUSB_USB_ADAPTER     pUsbAdapter,
                IN A_UINT8                 epNum,
                IN A_BOOL                  bRead);

NTSTATUS
athUsbInitTransferUrb(IN PATHUSB_USB_ADAPTER     pUsbAdapter,
                      IN PATHUSB_RXTX_OBJECT     pTransferObject);

NTSTATUS
athUsbInitTransferIrp(IN PATHUSB_USB_ADAPTER     pUsbAdapter,
                      IN PATHUSB_RXTX_OBJECT     pTransferObject);

NTSTATUS
athUsbProcessTransfer(IN PATHUSB_RXTX_OBJECT     pTransferObject,
                      IN OUT USBD_STATUS         *pUsbdStatus);

VOID
athUsbDrainWaitQueue(IN PATHUSB_USB_ADAPTER     pUsbAdapter);

NTSTATUS
athUsbQueueWorkItem(IN PATHUSB_USB_ADAPTER     pUsbAdapter);

VOID
athUsbWorkerItemCallback(IN  PDEVICE_OBJECT  DeviceObject,
                         IN  PVOID           Context);


#endif


