
INSTALL_DIR=$$(INSTALL_DIR) # override on make command line

include $(INSTALL_DIR)/include/pkgconf/ecos.mak

XCC           = $(ECOS_COMMAND_PREFIX)gcc
XCXX          = $(ECOS_COMMAND_PREFIX)gcc
XLD           = $(ECOS_COMMAND_PREFIX)gcc
XOBJCOPY      = $(ECOS_COMMAND_PREFIX)objcopy
CONVERT       = C:/ESTII/convert.exe
PERL 	      = perl
DRIVER_ROOT   = ./
TARGET_ROOT   = ../../../.

CFLAGS       +=-D__USB_DEVICE__ 
CFLAGS       +=-D__VUSBHS__ 
CFLAGS       +=-DECOS 
CFLAGS       +=-DAR5523 
CFLAGS       +=-DBOOTROM
CFLAGS       +=-DUSB_DRV_BOOTROM_CONFIG
CFLAGS       += -I$(INSTALL_DIR)/include
CXXFLAGS      = $(CFLAGS) $(CPPFLAGS)
LDFLAGS       = -nostartfiles -L$(INSTALL_DIR)/lib -Ttarget.ld -Wall -DBOOTROM 

OEXT          = o
PS            = /
OUTPUT_DIR    = bootromPlus
# RULES

CFLAGS += -I$(DRIVER_ROOT)$(PS)arcusb
CFLAGS += -I$(DRIVER_ROOT)$(PS)arcusb$(PS)include
CFLAGS += -I$(DRIVER_ROOT)$(PS)arcusb$(PS)device$(PS)vusbhs_dev
CFLAGS += -I$(DRIVER_ROOT)$(PS)arcusb$(PS)device$(PS)vusbhs_dev
CFLAGS += -I$(DRIVER_ROOT)$(PS)drv
CFLAGS += -I$(TARGET_ROOT)/include

.PHONY: all clean

all: $(OUTPUT_DIR)$(PS)devicePlus

dupdirs  = arcusb
dups     = platform.h

dupdirs  += arcusb(PS)include
dups     += types.h usb.h usbprv.h vusbhs.h devapi.h usbprv_dev.h

dupdirs  += device$(PS)vusbhs_dev
dups     += usbprv_dev.h

dupdirs  += drv
dups     += athusbdrv.h athusb.h athusbCtxt.h FlashDisk.h flash.h

srcdirs += arcusb
common_srcs    += \
	platform 

srcdirs += arcusb$(PS)device
device_srcs    += \
	dev_cncl dev_ep_deinit dev_main dev_recv dev_send dev_shut dev_utl

srcdirs += arcusb$(PS)device$(PS)vusbhs_dev
device_srcs    += \
	vusbhs_dev_cncl vusbhs_dev_deinit vusbhs_dev_main vusbhs_dev_shut vusbhs_dev_utl

drvdirs += drv
drvdirs += arcusb
drv_srcs    += \
	athusbdrv arcusb flash

appdirs += app$(PS)bootrom
app_srcs    += \
	  FlashDisk bootrom

srcs = $(common_srcs) $(device_srcs) $(drv_srcs) $(app_srcs)

srcdirs := $(addprefix $(DRIVER_ROOT),$(sort $(srcdirs)))
appdirs := $(addprefix $(DRIVER_ROOT),$(sort $(appdirs)))
drvdirs := $(addprefix $(DRIVER_ROOT),$(sort $(drvdirs)))
dupdirs := $(addprefix $(DRIVER_ROOT),$(sort $(dupdirs)))
deviceobjs := $(addprefix $(OUTPUT_DIR)$(PS),$(common_srcs) $(device_srcs) $(drv_srcs) $(app_srcs))
deviceobjs := $(addsuffix .$(OEXT),$(deviceobjs))
deps    := $(addsuffix .d,$(srcs))
dups    := $(wildcard $(foreach d,$(dups),$(addsuffix $(PS)$(d),$(dupdirs))))

vpath %.c   $(srcdirs) $(drvdirs) $(appdirs) 
vpath %.cxx $(srcdirs) $(drvdirs) $(appdirs) 
vpath %.pl  $(srcdirs) $(drvdirs) $(appdirs) 

$(OUTPUT_DIR)$(PS)devicePlus:  $(dups)  $(deviceobjs)
	$(XLD) $(LDFLAGS) $(ECOS_GLOBAL_LDFLAGS) -o $@ $(deviceobjs)
	$(CONVERT) -w $@ -b $@.bdx -c $@.ab -t mips
	$(XOBJCOPY) -O binary $@ $@.bin
	$(PERL) $(appdirs)$(PS)bootrom.pl $@.bin $(OUTPUT_DIR)$(PS)bootromPlus.bin 2 0

$(OUTPUT_DIR)$(PS)%.$(OEXT): %.c
	$(XCC) -c -o $(OUTPUT_DIR)$(PS)$*.o $(CFLAGS) $(ECOS_GLOBAL_CFLAGS) $(FDISK_CFLAGS) $<

$(OUTPUT_DIR)$(PS)%.$(OEXT): %.cxx
	$(XCXX) -c -o $(OUTPUT_DIR)$(PS)$*.o $(CXXFLAGS) $(ECOS_GLOBAL_CFLAGS) $(FDISK_CFLAGS) $<

$(OUTPUT_DIR)$(PS)%.%.$(OEXT): %.C
	$(XCXX) -c -o $(OUTPUT_DIR)$(PS)$*.o $(CXXFLAGS) $(ECOS_GLOBAL_CFLAGS) $(FDISK_CFLAGS) $<

$(OUTPUT_DIR)$(PS)%.%.$(OEXT): %.cc
	$(XCXX) -c -o $(OUTPUT_DIR)$(PS)$*.o $(CXXFLAGS) $(ECOS_GLOBAL_CFLAGS) $(FDISK_CFLAGS) $<


clean:
	-rm -f $(deviceobjs) $(OUTPUT_DIR)$(PS)device*


# DO NOT DELETE
