/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/transport/usb/target/app/bootrom/bootrom.h#1 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 * Header file for Boot over USB 
 */
                   
#ifndef __BOOTROM_H__
#define __BOOTORM_H__

enum {
    BOOTROM_INIT_COMMAND_STATE,
    BOOTROM_COMMAND_STATE,
    BOOTROM_DATA_STATE
};

enum {
    BOOTROM_RECV, 
    BOOTROM_SEND,
};


extern A_UINT32  sendPipePktSize[];
extern A_UINT32  recvPipePktSize[];

typedef struct image_info {
    A_UINT8         *imageAlignAddr;
    A_UINT8         *imagePtr;
    A_UINT8         *imageAddress;
    A_UINT32        imageLen;
}IMAGE_INFO;

typedef struct bootrom_context {
    IMAGE_INFO      imageInfo;
    A_UINT8         *pMessageBuffer;
    A_UINT8         *pDataBuffer;
    DRV_HANDLE      drvHandle;
    A_UINT8         numSendPipes;
    A_UINT8         numRecvPipes;
    A_UINT8         bootRomState;
} BOOTROM_CONTEXT, * PBOOTROM_CONTEXT;

typedef struct bootrom_message {
    A_UINT32        msgLen;         /* Message Length */
    A_UINT32        pktLen;         /* Following Data Pkt length */
    A_UINT32        imageLen;       /* Total Image Length */
    A_UINT32        bytesLeft;      /* Bytes left for the Image */
    A_UINT32        opStatus;       /* Operation status */
} BOOTROM_MESSAGE, * PBOOTROM_MESSAGE;

#endif /* __BOOTROM_H__ */

