/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/transport/usb/target/app/loopback.c#1 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 * Loopback test application for the Test Driver
 */
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "ecosdrv.h"
#include "athusbdrv.h"

int asserts = 1; 

#define LOOPBACK_INIT_DEBUG         (0x00000001)
#define LOOPBACK_RECV_DEBUG         (0x00000002)
#define LOOPBACK_SEND_DEBUG         (0x00000004)
#define LOOPBACK_MEM_DEBUG          (0x00000008)

A_UINT32 loopbackDebug = LOOPBACK_MEM_DEBUG;

#define LOOPBACK_DEBUG_PRINTF(FLAG, ARG)     \
    if (loopbackDebug & (FLAG)) {         \
        diag_printf ARG;                \
    }                                   


A_UINT32    gAppHandle;
DRV_HANDLE  drvHandle;
A_UINT8     numSendPipes;
A_UINT8     numRecvPipes;

A_UINT32    *pdataBuffers;
extern A_UINT32  sendPipePktSize[];
extern A_UINT32  recvPipePktSize[];

#ifndef MIN
#define MIN(a, b)       ((a) < (b)? (a): (b))
#endif
#ifndef MAX
#define MAX(a, b)       ((a) > (b)? (a): (b))
#endif

#define NUM_OF_RX_BUFFERS       10
#define NUM_OF_SUPP_RX_PIPES    2


/******************************************************************************
* usbStubRecvIndHandler
*
* Receives the Receive Indication in DSR context
*
*/
void usbStubRecvIndHandler( 
    IN APP_HANDLE   appHandle,
    IN A_UINT8      pipeNum,
    IN A_UINT8      *pBuffer,
    IN A_UINT32     bytesReceived
    )
{
    A_STATUS  status;
    ASSERT (((A_UINT32)appHandle) == gAppHandle);
    LOOPBACK_DEBUG_PRINTF(LOOPBACK_RECV_DEBUG, ("Rx : pipe - %d buf - 0x%x size - %d\n", 
                pipeNum, pBuffer, bytesReceived));
    if (bytesReceived) {
        status = athUsbDrvSend(drvHandle, pipeNum, pBuffer);
        ASSERT (status == A_OK);
    } else {
        do {
            status = athUsbDrvRecv(drvHandle, pipeNum, pBuffer);
        } while (status != A_OK);
    }
}

/******************************************************************************
* usbStubSendCfmHandler
*
* Receives the Send Confirm handler in DSR context
*
*/

void usbStubSendCfmHandler(
    IN APP_HANDLE   appHandle,
    IN A_UINT8      pipeNum,
    IN A_UINT8      *pBuffer,
    IN A_UINT32     bytesSent
    )
{
    A_STATUS  status;
    ASSERT (((A_UINT32)appHandle) == gAppHandle);
    LOOPBACK_DEBUG_PRINTF(LOOPBACK_SEND_DEBUG, ("Tx : pipe - %d buf - 0x%x size - %d\n", 
                          pipeNum, pBuffer, bytesSent));
    status = athUsbDrvRecv(drvHandle, pipeNum, pBuffer);
    ASSERT (status == A_OK);
}

/******************************************************************************
* printMemInfo
*
* Prints Mem information
*
*/

void printMemInfo( void )
{
    struct mallinfo mem_info;
    mem_info = mallinfo();
    LOOPBACK_DEBUG_PRINTF(LOOPBACK_MEM_DEBUG ,
                          ("Memory Used : %d Free : %d\n", mem_info.uordblks,  mem_info.fordblks));
}

/******************************************************************************
* usb_loopback_test
*
* Launches the loopback test
*
*/

void usb_loopback_test( void )
{
    A_STATUS    status;
    A_UINT8     i = 0;
    A_UINT8     j = 0;


    gAppHandle = 0x0;
    status = athUsbDrvInit( 0,
                         (void *)gAppHandle,
                         usbStubRecvIndHandler,
                         usbStubSendCfmHandler,
                         &drvHandle,
                         &numSendPipes,
                         &numRecvPipes
                        );
    if (status != A_OK) {
        LOOPBACK_DEBUG_PRINTF(LOOPBACK_INIT_DEBUG ,("Failed to Init USB Driver\n"));
    }
    pdataBuffers = (A_UINT32 *) A_DRIVER_MALLOC(sizeof(A_UINT32) * numRecvPipes);
    
    for (i = 0; i < MIN(NUM_OF_SUPP_RX_PIPES, numRecvPipes); i++) {
    
        pdataBuffers[i] = (A_UINT32) A_DRIVER_MALLOC(
                            sizeof(A_UINT8) * NUM_OF_RX_BUFFERS * recvPipePktSize[i]);
    
        for (j = 0; j < NUM_OF_RX_BUFFERS; j++) {
            LOOPBACK_DEBUG_PRINTF(LOOPBACK_INIT_DEBUG ,("QRx : pipe %d buf @ 0x%x size - %d\n", 
                        i, pdataBuffers[i] + j * recvPipePktSize[i],recvPipePktSize[i]));
            status = athUsbDrvRecv( drvHandle, i, 
                                  (A_UINT8 *)(pdataBuffers[i] + j * recvPipePktSize[i]));
            ASSERT (status == A_OK);
        }
    }
}

void cyg_user_start(void)
{
    usb_loopback_test();
}



