/*HEADER******************************************************************
**************************************************************************
*** 
*** Copyright (c) 2000-2002 ARC International.
*** All rights reserved                                          
***                                                              
*** This software embodies materials and concepts which are      
*** confidential to ARC International and is made
*** available solely pursuant to the terms of a written license   
*** agreement with ARC International             
***
*** $Workfile:dev_shut.c$
*** $Revision: #1 $
*** $Date: 2005/08/24 $
***
*** Description:      
***  This file contains USB device API specific function to shutdown 
***  the device.
***                                                               
**************************************************************************
*END*********************************************************************/
#include "devapi.h"
#include "usb.h"
#include "usbprv.h"
#include "usbprv_dev.h"

#ifdef __USB_OS_MQX__
   #include "mqx_arc.h"
#endif

/*FUNCTION*-------------------------------------------------------------
*
*  Function Name  : _usb_device_shutdown
*  Returned Value : USB_OK or error code
*  Comments       :
*        Shutdown an initialized USB device
*
*END*-----------------------------------------------------------------*/
void _usb_device_shutdown
   (
      /* [IN] the USB_USB_dev_initialize state structure */
      _usb_device_handle         handle
   )
{ /* Body */
   USB_DEV_STATE_STRUCT_PTR         usb_dev_ptr;
   
   usb_dev_ptr = (USB_DEV_STATE_STRUCT_PTR)handle;

#ifdef __USB_OS_MQX__   
    ((USB_CALLBACK_FUNCTIONS_STRUCT_PTR)\
      usb_dev_ptr->CALLBACK_STRUCT_PTR)->DEV_SHUTDOWN(usb_dev_ptr);
#else
   _usb_dci_vusb20_shutdown(usb_dev_ptr);
#endif
   
   /* Free all internal transfer descriptors */
   USB_memfree((pointer)usb_dev_ptr->XD_BASE);
   
   /* Free all XD scratch memory */
   USB_memfree((pointer)usb_dev_ptr->XD_SCRATCH_STRUCT_BASE);

   /* Free the temp ep init XD */
   USB_memfree((pointer)usb_dev_ptr->TEMP_XD_PTR);

   /* Free the USB state structure */
   USB_memfree((pointer)usb_dev_ptr);
   
} /* EndBody */
