#ifndef __usbprv_dev_h__
#define __usbprv_dev_h__ 1
/*HEADER******************************************************************
**************************************************************************
*** 
*** Copyright (c) 2000-2002 ARC International.
*** All rights reserved                                          
***                                                              
*** This software embodies materials and concepts which are      
*** confidential to ARC International and is made
*** available solely pursuant to the terms of a written license   
*** agreement with ARC International             
***
*** $Workfile:usbprv_dev.h$
*** $Revision: #1 $
*** $Date: 2005/08/24 $
***
*** Description:      
***  This file contains the private defines, externs and
***  data structure definitions required by the VUSB_HS Device
***  driver.
***                                                               
**************************************************************************
*END*********************************************************************/

#include <vusbhs.h>

#ifdef USB_DRV_BOOTROM_CONFIG

#define  MAX_EP_TR_DESCRS                    (32)
#define  MAX_XDS_FOR_TR_CALLS                (32)
#define  MAX_USB_DEVICES                     (1)
#define  USB_MAX_CTRL_PAYLOAD                (64)
#define  USB_MAX_ENDPOINTS                   (3)
 
#else

#define  MAX_EP_TR_DESCRS                    (64)
#define  MAX_XDS_FOR_TR_CALLS                (64)
#define  MAX_USB_DEVICES                     (1)
#define  USB_MAX_ENDPOINTS                   (16)
#define  USB_MAX_CTRL_PAYLOAD                (64)

#endif /* USB_DRV_BOOTROM_CONFIG */

/* Macro for aligning the EP queue head to 32 byte boundary */
#define USB_MEM32_ALIGN(n)                   ((n) + (-(n) & 31))

/* Macro for aligning the EP queue head to 1024 byte boundary */
#define USB_MEM1024_ALIGN(n)                 ((n) + (-(n) & 1023))

/* Macro for aligning the EP queue head to 1024 byte boundary */
#define USB_MEM2048_ALIGN(n)                 ((n) + (-(n) & 2047))

#define USB_XD_QADD(head,tail,XD)      \
   if ((head) == NULL) {         \
      (head) = (XD);            \
   } else {                      \
      (tail)->SCRATCH_PTR->PRIVATE = (XD);   \
   } /* Endif */                 \
   (tail) = (XD);               \
   (XD)->SCRATCH_PTR->PRIVATE = NULL
   
#define USB_XD_QGET(head,tail,XD)      \
   (XD) = (head);               \
   if (head) {                   \
      (head) = (XD_STRUCT_PTR)((head)->SCRATCH_PTR->PRIVATE);  \
      if ((head) == NULL) {      \
         (tail) = NULL;          \
      } /* Endif */              \
   } /* Endif */

#define EHCI_DTD_QADD(head,tail,dTD)      \
   if ((head) == NULL) {         \
      (head) = (dTD);            \
   } else {                      \
      (tail)->SCRATCH_PTR->PRIVATE = (dTD);   \
   } /* Endif */                 \
   (tail) = (dTD);               \
   (dTD)->SCRATCH_PTR->PRIVATE = NULL
   
#define EHCI_DTD_QGET(head,tail,dTD)      \
   (dTD) = (head);               \
   if (head) {                   \
      (head) = (VUSB20_EP_TR_STRUCT_PTR)((head)->SCRATCH_PTR->PRIVATE);  \
      if ((head) == NULL) {      \
         (tail) = NULL;          \
      } /* Endif */              \
   } /* Endif */

/***************************************
**
** Data structures
**
*/

typedef struct xd_struct {
   uchar          EP_NUM;           /* Endpoint number */
   uchar          BDIRECTION;       /* Direction : Send/Receive */
   uint_8         EP_TYPE;          /* Type of the endpoint: Ctrl, Isoch, Bulk, 
                                    ** Int 
                                    */
   uchar          BSTATUS;          /* Current transfer status */
   uchar_ptr      WSTARTADDRESS;    /* Address of first byte */
   uint_32        WTOTALLENGTH;     /* Number of bytes to send/recv */
   uint_32        WSOFAR;           /* Number of bytes recv'd so far */
   uint_16        WMAXPACKETSIZE;   /* Max Packet size */
   boolean        DONT_ZERO_TERMINATE;
   SCRATCH_STRUCT_PTR SCRATCH_PTR;
} XD_STRUCT, _PTR_ XD_STRUCT_PTR;

/* The USB Device State Structure */
typedef struct {
   boolean                          BUS_RESETTING;       /* Device is 
                                                         ** being reset 
                                                         */
   boolean                          TRANSFER_PENDING;    /* Transfer pending ? */
   pointer                          DEV_PTR;             /* Device Controller 
                                                         ** Register base 
                                                         ** address 
                                                         */
   pointer                          CALLBACK_STRUCT_PTR;
   
   XD_STRUCT_PTR                    TEMP_XD_PTR;         /* Temp xd for ep init */
   XD_STRUCT_PTR                    XD_BASE;
   XD_STRUCT_PTR                    XD_HEAD;             /* Head Transaction 
                                                         ** descriptors 
                                                         */
   XD_STRUCT_PTR                    XD_TAIL;             /* Tail Transaction 
                                                         ** descriptors 
                                                         */
   XD_STRUCT_PTR                    PENDING_XD_PTR;      /* pending transfer */
   uint_32                          XD_ENTRIES;
   VUSB20_EP_QUEUE_HEAD_STRUCT_PTR  EP_QUEUE_HEAD_PTR;   /* Endpoint Queue 
                                                         ** head 
                                                         */
   VUSB20_EP_QUEUE_HEAD_STRUCT_PTR  EP_QUEUE_HEAD_BASE;
   VUSB20_EP_TR_STRUCT_PTR          DTD_BASE_PTR;        /* Device transfer 
                                                         ** descriptor pool 
                                                         ** address 
                                                         */
   VUSB20_EP_TR_STRUCT_PTR          DTD_ALIGNED_BASE_PTR;/* Aligned transfer 
                                                         ** descriptor pool 
                                                         ** address 
                                                         */
   VUSB20_EP_TR_STRUCT_PTR          DTD_HEAD;
   VUSB20_EP_TR_STRUCT_PTR          DTD_TAIL;
   VUSB20_EP_TR_STRUCT_PTR          EP_DTD_HEADS[USB_MAX_ENDPOINTS * 2];
   VUSB20_EP_TR_STRUCT_PTR          EP_DTD_TAILS[USB_MAX_ENDPOINTS * 2];
   SCRATCH_STRUCT_PTR               XD_SCRATCH_STRUCT_BASE;
   SCRATCH_STRUCT_PTR               SCRATCH_STRUCT_BASE;
   
   /* These fields are kept only for USB_shutdown() */
   void(_CODE_PTR_                  OLDISR_PTR)(pointer);
   pointer                          OLDISR_DATA;
   uint_16                          USB_STATE;
   uint_16                          USB_DEVICE_STATE;
   uint_16                          USB_SOF_COUNT;
   uint_16                          DTD_ENTRIES;
   uint_16                          ERRORS;
   uint_16                          USB_DEV_STATE_B4_SUSPEND;
   uint_8                           DEV_NUM;             /* USB device number 
                                                         ** on the board 
                                                         */
   uint_8                           DEV_VEC;             /* Interrupt vector 
                                                         ** number for USB 
                                                         */
   uint_8                           SPEED;               /* Low Speed, 
                                                         ** High Speed, 
                                                         ** Full Speed 
                                                         */
   uint_8                           MAX_ENDPOINTS;       /* Max endpoints
                                                         ** supported by this
                                                         ** device
                                                         */
                                                         
   uint_8                           USB_CURR_CONFIG;                                                         
   uint_8                           DEVICE_ADDRESS;
   pointer                          DRV_HANDLE;
   pointer                          INTR_HANDLE;
} USB_DEV_STATE_STRUCT, _PTR_ USB_DEV_STATE_STRUCT_PTR;


/***************************************
**
** Prototypes
**
*/
#ifdef __cplusplus
extern "C" {
#endif

extern void _usb_dci_vusb20_isr(pointer);
extern uint_8 _usb_dci_vusb20_init(uint_8, _usb_device_handle);
extern void _usb_device_free_XD(pointer);
extern void _usb_dci_vusb20_free_dTD(pointer);
extern uint_8 _usb_dci_vusb20_add_dTD(_usb_device_handle, XD_STRUCT_PTR);
extern uint_8 _usb_dci_vusb20_send_data(_usb_device_handle, XD_STRUCT_PTR);
extern uint_8 _usb_dci_vusb20_recv_data(_usb_device_handle, XD_STRUCT_PTR);
extern uint_8 _usb_dci_vusb20_cancel_transfer(_usb_device_handle, uint_8, uint_8);
extern uint_8 _usb_dci_vusb20_get_transfer_status(_usb_device_handle, uint_8, uint_8);
extern uint_8 _bsp_get_usb_vector(uint_8);
extern pointer _bsp_get_usb_base(uint_8);
extern pointer _bsp_get_usb_capability_register_base(uint_8);
extern void _usb_dci_vusb20_process_tr_complete(_usb_device_handle);
extern void _usb_dci_vusb20_process_reset(_usb_device_handle);
extern void _usb_dci_vusb20_process_tr_complete(_usb_device_handle);
extern void _usb_dci_vusb20_process_suspend(_usb_device_handle);
extern void _usb_dci_vusb20_process_SOF(_usb_device_handle);
extern void _usb_dci_vusb20_process_port_change(_usb_device_handle);
extern void _usb_dci_vusb20_process_error(_usb_device_handle);
extern void _usb_dci_vusb20_shutdown(_usb_device_handle);
extern void _usb_dci_vusb20_set_address(_usb_device_handle, uint_8);
extern void _usb_dci_vusb20_get_setup_data(_usb_device_handle, 
   uint_8, uchar_ptr);
extern void _usb_dci_vusb20_assert_resume(_usb_device_handle);
extern uint_8 _usb_dci_vusb20_init_endpoint(_usb_device_handle, XD_STRUCT_PTR);
extern void _usb_dci_vusb20_stall_endpoint(_usb_device_handle, uint_8, uint_8);
extern void _usb_dci_vusb20_unstall_endpoint(_usb_device_handle, uint_8, uint_8);
extern uint_8 _usb_dci_vusb20_deinit_endpoint(_usb_device_handle, uint_8, uint_8);
extern void _usb_dci_vusb20_set_endpoint_status(_usb_device_handle, uint_8, 
   uint_8);
extern void _usb_dci_vusb20_set_test_mode(_usb_device_handle, uint_16);   
extern uint_8  _usb_dci_vusb20_get_endpoint_status(_usb_device_handle, uint_8);
extern void _usb_dci_vusb20_chip_initialize(_usb_device_handle);
extern uint_8 _usb_dci_vusb20_cancel_pend_xfers(_usb_device_handle, uint_8, uint_8);

extern uint_8 _usb_dci_vusb20_add_dTD_emptyhwq(USB_DEV_STATE_STRUCT_PTR,
               VUSB20_EP_TR_STRUCT_PTR, VUSB20_EP_TR_STRUCT_PTR, XD_STRUCT_PTR);
extern uint_8 _usb_dci_vusb20_add_dTD_livehwq(USB_DEV_STATE_STRUCT_PTR,
               VUSB20_EP_TR_STRUCT_PTR, VUSB20_EP_TR_STRUCT_PTR, XD_STRUCT_PTR);

extern boolean _usb_dci_vusb20_is_endpoint_primed(USB_DEV_STATE_STRUCT_PTR,       
               uint_32);
extern boolean _usb_dci_vusb20_attach_to_qhead(USB_DEV_STATE_STRUCT_PTR,
               VUSB20_EP_QUEUE_HEAD_STRUCT_PTR, VUSB20_EP_TR_STRUCT_PTR, uint_32);
extern uint_8 _usb_dci_vusb20_flush_endpoint(USB_DEV_STATE_STRUCT_PTR, uint_32);


#ifdef __cplusplus
}
#endif

#endif
