/*HEADER******************************************************************
**************************************************************************
*** 
*** Copyright (c) 2000-2002 ARC International.
*** All rights reserved                                          
***                                                              
*** This software embodies materials and concepts which are      
*** confidential to ARC International and is made
*** available solely pursuant to the terms of a written license   
*** agreement with ARC International             
***
*** $Workfile:vusbhs_dev_cncl.c$
*** $Revision: #1 $
*** $Date: 2005/08/24 $
***
*** Description:      
***  This file contains the VUSB_HS Device Controller interface 
***  function to cancel a transfer.
***                                                               
**************************************************************************
*END*********************************************************************/
#include "devapi.h"
#include "usb.h"
#include "usbprv.h"
#include "usbprv_dev.h"

#ifdef __USB_OS_MQX__
   #include "mqx_arc.h"
#endif

/*FUNCTION*-------------------------------------------------------------
*
*  Function Name  : _usb_dci_vusb20_cancel_transfer
*  Returned Value : USB_OK or error code
*  Comments       :
*        Cancels a transfer
*
*END*-----------------------------------------------------------------*/
uint_8 _usb_dci_vusb20_cancel_transfer
   (
      /* [IN] the USB_dev_initialize state structure */
      _usb_device_handle         handle,
     
      /* [IN] the Endpoint number */
      uint_8                     ep_num,
            
      /* [IN] direction */
      uint_8                     direction
   )
{ /* Body */
   USB_DEV_STATE_STRUCT_PTR                     usb_dev_ptr;
   volatile VUSB20_REG_STRUCT _PTR_             dev_ptr;
   VUSB20_EP_TR_STRUCT_PTR                      dTD_ptr, check_dTD_ptr;
   VUSB20_EP_QUEUE_HEAD_STRUCT_PTR              ep_queue_head_ptr;
   XD_STRUCT_PTR                                xd_ptr;
   uint_32                                      temp, bit_pos;
   boolean                                      prime_status;
   
   usb_dev_ptr = (USB_DEV_STATE_STRUCT_PTR)handle;
   dev_ptr = (volatile VUSB20_REG_STRUCT _PTR_)usb_dev_ptr->DEV_PTR;
   
   bit_pos = (1 << (16 * direction + ep_num));
   temp = (2*ep_num + direction);
   
   ep_queue_head_ptr = (VUSB20_EP_QUEUE_HEAD_STRUCT_PTR)
      dev_ptr->REGISTERS.OPERATIONAL_DEVICE_REGISTERS.EP_LIST_ADDR + 
      temp;
   
   /* Invalidate the cache for the the Queue Head Pointer */
   if (ep_queue_head_ptr) {
       DATA_CACHE_INVAL(ep_queue_head_ptr, sizeof(VUSB20_EP_QUEUE_HEAD_STRUCT)); 
   }
   
   /* Unlink the dTD */
   dTD_ptr = usb_dev_ptr->EP_DTD_HEADS[temp];
   
   if (dTD_ptr) {
      DATA_CACHE_INVAL(dTD_ptr, sizeof(VUSB20_EP_TR_STRUCT)); 
      
      check_dTD_ptr = (VUSB20_EP_TR_STRUCT_PTR)((uint_32)dTD_ptr->NEXT_TR_ELEM_PTR & 
         VUSBHS_TD_ADDR_MASK);
      if (check_dTD_ptr) {
          DATA_CACHE_INVAL(check_dTD_ptr, sizeof(VUSB20_EP_TR_STRUCT)); 
      }

      if ((dTD_ptr->SIZE_IOC_STS & VUSBHS_TD_STATUS_ACTIVE) & 
          (ep_queue_head_ptr->STATUS == VUSB_EP_INIT))
      {
         /* Flushing will halt the pipe */
         /* Write 1 to the Flush register */
         dev_ptr->REGISTERS.OPERATIONAL_DEVICE_REGISTERS.ENDPTFLUSH = bit_pos;

         /* Check if the endpoint is primed */
         prime_status = _usb_dci_vusb20_is_endpoint_primed(usb_dev_ptr, bit_pos);
         
         if (prime_status) {
             /* Write 1 to the Flush register */
             dev_ptr->REGISTERS.OPERATIONAL_DEVICE_REGISTERS.ENDPTFLUSH = bit_pos;

             /* Wait until flushing completed */
             while (dev_ptr->REGISTERS.OPERATIONAL_DEVICE_REGISTERS.ENDPTFLUSH & bit_pos) {
                /* ENDPTFLUSH bit should be cleared to indicate this 
                ** operation is complete 
                */
             } /* EndWhile */
         }
      } /* Endif */
      
      /* Retire the current dTD */
      dTD_ptr->SIZE_IOC_STS = 0;
      dTD_ptr->NEXT_TR_ELEM_PTR = VUSBHS_TD_NEXT_TERMINATE;
      
      /* The transfer descriptor for this dTD */
      xd_ptr = (XD_STRUCT_PTR)dTD_ptr->SCRATCH_PTR->XD_FOR_THIS_DTD;
      dTD_ptr->SCRATCH_PTR->PRIVATE = (pointer)usb_dev_ptr;
      /* Free the dTD */
      _usb_dci_vusb20_free_dTD((pointer)dTD_ptr);
      
      /* Update the dTD head and tail for specific endpoint/direction */
      if (!check_dTD_ptr) {
         usb_dev_ptr->EP_DTD_HEADS[temp] = NULL;
         usb_dev_ptr->EP_DTD_TAILS[temp] = NULL;
         if (xd_ptr) {
            xd_ptr->SCRATCH_PTR->PRIVATE = (pointer)usb_dev_ptr;
            /* Free the transfer descriptor */
            _usb_device_free_XD((pointer)xd_ptr);
         } /* Endif */
      } else {
         usb_dev_ptr->EP_DTD_HEADS[temp] = check_dTD_ptr;
            
         if (xd_ptr) {
            if ((uint_32)check_dTD_ptr->SCRATCH_PTR->\
               XD_FOR_THIS_DTD != (uint_32)xd_ptr) 
            {
               xd_ptr->SCRATCH_PTR->PRIVATE = (pointer)usb_dev_ptr;
               /* Free the transfer descriptor */
               _usb_device_free_XD((pointer)xd_ptr);
            } /* Endif */
         } /* Endif */
         
         if ((check_dTD_ptr->SIZE_IOC_STS & VUSBHS_TD_STATUS_ACTIVE)  & 
             (ep_queue_head_ptr->STATUS == VUSB_EP_INIT))
         {
             /* Check if the endpoint is primed */
             prime_status = _usb_dci_vusb20_is_endpoint_primed(usb_dev_ptr, bit_pos);
             if (!prime_status) {
                 _usb_dci_vusb20_attach_to_qhead(usb_dev_ptr, ep_queue_head_ptr, 
                                                 check_dTD_ptr, bit_pos);
             }
         } /* Endif */
      } /* Endif */
   } /* Endif */
   
   return USB_OK;

} /* EndBody */

/* EOF */
