/*HEADER******************************************************************
**************************************************************************
*** 
*** Copyright (c) 2000-2002 ARC International.
*** All rights reserved                                          
***                                                              
*** This software embodies materials and concepts which are      
*** confidential to ARC International and is made
*** available solely pursuant to the terms of a written license   
*** agreement with ARC International             
***
*** $Workfile:vusbhs_dev_deinit.c$
*** $Revision: #1 $
*** $Date: 2005/08/24 $
***
*** Description:      
***  This file contains the VUSB_HS Device Controller interface 
***  to de-initialize the endpoints.
***                                                               
**************************************************************************
*END*********************************************************************/
#include "devapi.h"
#include "usb.h"
#include "usbprv.h"
#include "usbprv_dev.h"

#ifdef __USB_OS_MQX__
   #include "mqx_arc.h"
#endif

/*FUNCTION*-------------------------------------------------------------
*
*  Function Name  : _usb_dci_vusb20_deinit_endpoint
*  Returned Value : None
*  Comments       :
*        Disables the specified endpoint and the endpoint queue head
*
*END*-----------------------------------------------------------------*/
uint_8 _usb_dci_vusb20_deinit_endpoint
   (
      /* [IN] the USB_dev_initialize state structure */
      _usb_device_handle         handle,
            
      /* [IN] the Endpoint number */
      uint_8                     ep_num,
            
      /* [IN] direction */
      uint_8                     direction
   )
{ /* Body */
   USB_DEV_STATE_STRUCT_PTR                     usb_dev_ptr;
   volatile VUSB20_REG_STRUCT _PTR_             dev_ptr;
   VUSB20_EP_QUEUE_HEAD_STRUCT _PTR_            ep_queue_head_ptr;
   uint_32                                      bit_pos;
   
   usb_dev_ptr = (USB_DEV_STATE_STRUCT_PTR)handle;
   dev_ptr = (volatile VUSB20_REG_STRUCT _PTR_)usb_dev_ptr->DEV_PTR;
   
   /* Ger the endpoint queue head address */
   ep_queue_head_ptr = (VUSB20_EP_QUEUE_HEAD_STRUCT_PTR)
      dev_ptr->REGISTERS.OPERATIONAL_DEVICE_REGISTERS.EP_LIST_ADDR + 
      (2*ep_num + direction);
      
   if (ep_queue_head_ptr) {
       DATA_CACHE_INVAL(ep_queue_head_ptr, sizeof(VUSB20_EP_QUEUE_HEAD_STRUCT)); 
   }
   if (ep_queue_head_ptr->STATUS != VUSB_EP_INIT) {
       /* Endpoint Already deintialialzed */
       return USB_OK;
   }
   bit_pos = (1 << (16 * direction + ep_num));

   /* Check if the Endpoint is Primed */
   if (_usb_dci_vusb20_is_endpoint_primed(usb_dev_ptr, bit_pos)) {
       if (_usb_dci_vusb20_flush_endpoint(usb_dev_ptr, bit_pos) != USB_OK) {
           return USBERR_EP_DEINIT_FAILED;
       }
   }       
   /* Reset the max packet length and the interrupt on Setup */
   ep_queue_head_ptr->MAX_PKT_LENGTH = 0;

   /* Disable the endpoint for Rx or Tx and reset the endpoint type */
   dev_ptr->REGISTERS.OPERATIONAL_DEVICE_REGISTERS.ENDPTCTRLX[ep_num] &= 
       ((direction ? ~EHCI_EPCTRL_TX_ENABLE : ~EHCI_EPCTRL_RX_ENABLE) | 
        (direction ? ~EHCI_EPCTRL_TX_TYPE : ~EHCI_EPCTRL_RX_TYPE));

   /* Set the Endpoint Status to Initialized */
   ep_queue_head_ptr->STATUS = VUSB_EP_DEINIT;
   return USB_OK;
   
} /* EndBody */



