/*HEADER******************************************************************
**************************************************************************
*** 
*** Copyright (c) 2000-2002 ARC International.
*** All rights reserved                                          
***                                                              
*** This software embodies materials and concepts which are      
*** confidential to ARC International and is made
*** available solely pursuant to the terms of a written license   
*** agreement with ARC International             
***
*** $Workfile:vusbhs_dev_shut.c$
*** $Revision: #1 $
*** $Date: 2005/08/24 $
***
*** Description:      
***  This file contains the VUSB_HS Device Controller interface function
***  to shutdown the device.
***                                                               
**************************************************************************
*END*********************************************************************/
#include "devapi.h"
#include "usb.h"
#include "usbprv.h"
#include "usbprv_dev.h"

#ifdef __USB_OS_MQX__
   #include "mqx_arc.h"
#endif

/*FUNCTION*-------------------------------------------------------------
*
*  Function Name  : _usb_dci_vusb20_shutdown
*  Returned Value : None
*  Comments       :
*        Shuts down the VUSB_HS Device
*
*END*-----------------------------------------------------------------*/
void _usb_dci_vusb20_shutdown
   (
      /* [IN] the USB_dev_initialize state structure */
      _usb_device_handle         handle
   )
{ /* Body */
   USB_DEV_STATE_STRUCT_PTR                     usb_dev_ptr;
   volatile VUSB20_REG_STRUCT _PTR_             dev_ptr;
   
   usb_dev_ptr = (USB_DEV_STATE_STRUCT_PTR)handle;
   dev_ptr = (volatile VUSB20_REG_STRUCT _PTR_)usb_dev_ptr->DEV_PTR;
   
   /* Disable interrupts */
   dev_ptr->REGISTERS.OPERATIONAL_DEVICE_REGISTERS.USB_INTR &= 
      ~(EHCI_INTR_INT_EN | EHCI_INTR_ERR_INT_EN |
      EHCI_INTR_PORT_CHANGE_DETECT_EN | EHCI_INTR_RESET_EN);
      
   /* Reset the Run the bit in the command register to stop VUSB */
   dev_ptr->REGISTERS.OPERATIONAL_DEVICE_REGISTERS.USB_CMD &= ~EHCI_CMD_RUN_STOP;
   
   /* Reset the controller to get default values */
   dev_ptr->REGISTERS.OPERATIONAL_DEVICE_REGISTERS.USB_CMD = EHCI_CMD_CTRL_RESET;
   
   /* Free all the Endpoint Queue Heads */
   USB_memfree((pointer)usb_dev_ptr->EP_QUEUE_HEAD_BASE);
   
   /* Free all dTDs */
   USB_memfree((pointer)usb_dev_ptr->DTD_BASE_PTR);
   
   /* Free scratch structures */
   USB_memfree((pointer)usb_dev_ptr->SCRATCH_STRUCT_BASE);

#ifndef __USB_OTG__
   /* Install the interrupt service routine */
#ifndef __USB_OS_MQX__   
   USB_uninstall_isr(usb_dev_ptr->DEV_NUM, 
                     (pointer)usb_dev_ptr->INTR_HANDLE);
#else
   if (!(USB_uninstall_isr(_bsp_get_usb_vector(usb_dev_ptr->DEV_NUM), 
                           (pointer)usb_dev_ptr->INTR_HANDLE)))
   {
      return USBERR_INSTALL_ISR;
   } /* Endbody */
#endif
#endif   /* __USB_OTG__*/

   
} /* EndBody */
