#ifndef __devapi_h__
#define __devapi_h__ 1
/*HEADER******************************************************************
**************************************************************************
*** 
*** Copyright (c) 2000-2002 ARC International.
*** All rights reserved                                          
***                                                              
*** This software embodies materials and concepts which are      
*** confidential to ARC International and is made
*** available solely pursuant to the terms of a written license   
*** agreement with ARC International             
***
*** $Workfile:devapi.h$
*** $Revision: #1 $
*** $Date: 2005/08/24 $
***
*** Description:      
***  This file contains the declarations specific to the USB Device API
***                                                               
**************************************************************************
*END*********************************************************************/
#include "types.h"

#define  USB_SEND                         (1)
#define  USB_RECV                         (0)

/* Endpoint types */
#define  USB_CONTROL_ENDPOINT             (0)
#define  USB_ISOCHRONOUS_ENDPOINT         (1)
#define  USB_BULK_ENDPOINT                (2)
#define  USB_INTERRUPT_ENDPOINT           (3)

/* Informational Request/Set Types */
#define  USB_STATUS_DEVICE_STATE          (0x01)
#define  USB_STATUS_INTERFACE             (0x02)
#define  USB_STATUS_ADDRESS               (0x03)
#define  USB_STATUS_CURRENT_CONFIG        (0x04)
#define  USB_STATUS_SOF_COUNT             (0x05)
#define  USB_STATUS_DEVICE                (0x06)
#define  USB_STATUS_TEST_MODE             (0x07)
#define  USB_STATUS_ENDPOINT              (0x10)
#define  USB_STATUS_ENDPOINT_NUMBER_MASK  (0x0F)

#define  USB_TEST_MODE_TEST_PACKET        (0x0400)

typedef pointer _usb_device_handle;
typedef pointer _usb_drv_handle;

#ifdef __cplusplus
extern "C" {
#endif

extern uint_8 _usb_device_init(uint_8, _usb_drv_handle, _usb_device_handle _PTR_, uint_8);
extern uint_8 _usb_device_recv_data(_usb_device_handle, uint_8, uchar_ptr, 
   uint_32);
extern uint_8 _usb_device_send_data(_usb_device_handle, uint_8, uchar_ptr, 
   uint_32);
extern uint_8 _usb_device_get_transfer_status(_usb_device_handle, uint_8, 
   uint_8);
extern uint_8 _usb_device_cancel_transfer(_usb_device_handle, uint_8, uint_8);
extern uint_8 _usb_device_get_status(_usb_device_handle, uint_8, uint_16_ptr);
extern uint_8 _usb_device_set_status(_usb_device_handle, uint_8, uint_16);
extern void _usb_device_shutdown(_usb_device_handle);
extern void _usb_device_set_address(_usb_device_handle, uint_8);
extern void _usb_device_read_setup_data(_usb_device_handle, uint_8, uchar_ptr);
extern void _usb_device_assert_resume(_usb_device_handle);
extern uint_8 _usb_device_init_endpoint(_usb_device_handle, uint_8, uint_16, 
   uint_8, uint_8, uint_8);
extern void _usb_device_stall_endpoint(_usb_device_handle, 
   uint_8, uint_8);
extern void _usb_device_unstall_endpoint(_usb_device_handle, 
   uint_8, uint_8);
extern uint_8 _usb_device_deinit_endpoint(_usb_device_handle, uint_8, uint_8);   
extern uint_8 _usb_device_cancel_pend_xfers(_usb_device_handle, uint_8 ,uint_8);
extern void service_reset(_usb_drv_handle, boolean, uint_8, uint_8_ptr, uint_32);
extern void service_speed(_usb_drv_handle, boolean, uint_8, uint_8_ptr, uint_32);
extern void service_suspend(_usb_drv_handle, boolean, uint_8, uint_8_ptr, uint_32);
extern void service_port_suspend(_usb_drv_handle, boolean, uint_8, uint_8_ptr, uint_32);
extern void service_port_resume(_usb_drv_handle, boolean, uint_8, uint_8_ptr, uint_32);
extern void service_ep(_usb_drv_handle, uint_8, boolean, uint_8, uint_8_ptr, uint_32);

#ifdef __cplusplus
}
#endif   

#endif
/* EOF */

