#ifndef __usb_h__
#define __usb_h__ 1
/*HEADER******************************************************************
**************************************************************************
*** 
*** Copyright (c) 2000-2002 ARC International.
*** All rights reserved                                          
***                                                              
*** This software embodies materials and concepts which are      
*** confidential to ARC International and is made
*** available solely pursuant to the terms of a written license   
*** agreement with ARC International             
***
*** $Workfile:usb.h$
*** $Revision: #1 $
*** $Date: 2005/08/24 $
***
*** Comments:      
***   This file contains USB Device API defines for state and function
***  returns.
***
**************************************************************************
*END*********************************************************************/
/* Host specific */
#define  USB_DEBOUNCE_DELAY                  (50)
#define  USB_RESET_RECOVERY_DELAY            (10)
#define  USB_RESET_DELAY                     (10)

/* Error codes */
#define  USB_OK                              (0x00)
#define  USBERR_ALLOC                        (0x01)
#define  USBERR_BAD_STATUS                   (0x02)
#define  USBERR_CLOSED_SERVICE               (0x03)
#define  USBERR_OPEN_SERVICE                 (0x04)
#define  USBERR_INVALID_NUM_OF_ENDPOINTS     (0x05)
#define  USBERR_ENDPOINT_DISABLED            (0x06)
#define  USBERR_TRANSFER_IN_PROGRESS         (0x07)
#define  USBERR_ENDPOINT_STALLED             (0x08)
#define  USBERR_UNKNOWN_TRANSFER_STATUS      (0x09)
#define  USBERR_ALLOC_STATE                  (0x0A)
#define  USBERR_ALLOC_TRANSFER_DESCRIPTORS   (0x0B)
#define  USBERR_DRIVER_INSTALL_FAILED        (0x0C)
#define  USBERR_DRIVER_NOT_INSTALLED         (0x0D)
#define  USBERR_INSTALL_ISR                  (0x0E)
#define  USBERR_INVALID_DEVICE_NUM           (0x0F)
#define  USBERR_ALLOC_SERVICE                (0x1F)
#define  USBERR_INIT_FAILED                  (0x2F)
#define  USBERR_SHUTDOWN                     (0x3F)
#define  USBERR_INVALID_PIPE_HANDLE          (0x4F)
#define  USBERR_ALLOC_PIPE_DESCR             (0x5F)
#define  USBERR_OPEN_PIPE_FAILED             (0x6F)
#define  USBERR_INIT_DATA                    (0x7F)
#define  USBERR_SRP_REQ_INVALID_STATE        (0x8F)
#define  USBERR_MAX_EPS_NOT_SUPPORTED        (0x9F)
#define  USBERR_ALLOC_BUFF                   (0xA0)
#define  USBERR_TX_FAILED                    (0xA1)
#define  USBERR_RX_FAILED                    (0xA2)
#define  USBERR_TR_CANCEL_FAILED             (0xA3)
#define  USBERR_EP_INIT_FAILED               (0xA4)
#define  USBERR_EP_DEINIT_FAILED             (0xA5)
#define  USBERR_TR_FAILED                    (0xA6)
#define  USBERR_BANDWIDTH_ALLOC_FAILED       (0xA7)

/* Error Codes for lower-layer */
#define  USBERR_ALLOC_EP_QUEUE_HEAD          (0xA8)
#define  USBERR_ALLOC_TR                     (0xA9)
#define  USBERR_ALLOC_DTD_BASE               (0xAA)
#define  USBERR_CLASS_DRIVER_INSTALL         (0xAB)

/* Service installation check return codes */
#define  USB_SERVICE_NOT_INSTALLED           (0x7F)
#define  USB_SERVICE_INSTALLED               (0x8F)

/* Pipe Types */
#define  USB_ISOCHRONOUS_PIPE                (0x01)
#define  USB_INTERRUPT_PIPE                  (0x02)
#define  USB_CONTROL_PIPE                    (0x03)
#define  USB_BULK_PIPE                       (0x04)

#define  USB_STATE_UNKNOWN                   (0xff)
#define  USB_STATE_POWERED                   (0x03)
#define  USB_STATE_DEFAULT                   (0x02)
#define  USB_STATE_ADDRESS                   (0x01)
#define  USB_STATE_CONFIG                    (0x00)
#define  USB_STATE_SUSPEND                   (0x80)

#define  USB_SELF_POWERED                    (0x01)
#define  USB_REMOTE_WAKEUP                   (0x02)

/* Bus Control values */
#define  USB_NO_OPERATION                    (0x00)
#define  USB_ASSERT_BUS_RESET                (0x01)
#define  USB_DEASSERT_BUS_RESET              (0x02)
#define  USB_ASSERT_RESUME                   (0x03)
#define  USB_DEASSERT_RESUME                 (0x04)
#define  USB_SUSPEND_SOF                     (0x05)
#define  USB_RESUME_SOF                      (0x06)

/* possible values of XD->bStatus */
#define  USB_STATUS_IDLE                     (0)
#define  USB_STATUS_TRANSFER_ACCEPTED        (1)
#define  USB_STATUS_TRANSFER_PENDING         (2)
#define  USB_STATUS_TRANSFER_IN_PROGRESS     (3)
#define  USB_STATUS_ERROR                    (4)
#define  USB_STATUS_DISABLED                 (5)
#define  USB_STATUS_STALLED                  (6)
#define  USB_STATUS_TRANSFER_QUEUED          (7)

#define  USB_RECV                            (0)
#define  USB_SEND                            (1)

#define  USB_HOST_DONT_ZERO_TERMINATE        (0x1)
#define  USB_DEVICE_DONT_ZERO_TERMINATE      (0x1)

#define  USB_SETUP_DATA_XFER_DIRECTION       (0x80)

#define  USB_SPEED_FULL                      (0)
#define  USB_SPEED_LOW                       (1)
#define  USB_SPEED_HIGH                      (2)

#endif

/* EOF */
