#ifndef __usbprv_h__
#define __usbprv_h__ 1
/*HEADER******************************************************************
**************************************************************************
*** 
*** Copyright (c) 2000-2002 ARC International.
*** All rights reserved                                          
***                                                              
*** This software embodies materials and concepts which are      
*** confidential to ARC International and is made
*** available solely pursuant to the terms of a written license   
*** agreement with ARC International             
***
*** $Workfile:usbprv.h$
*** $Revision: #1 $
*** $Date: 2005/08/24 $
***
*** Comments:      
***   This file contains the internal USB specific type definitions
***                                                               
**************************************************************************
*END*********************************************************************/
#ifndef __USB_OS_MQX__
#include "stdlib.h"
#include "string.h"

#define USB_lock(n)                         _platform_lock(n)
#define USB_unlock(n)                       _platform_unlock(n)
#define USB_memalloc(n)                     malloc(n)
#define USB_memfree(ptr)                    free(ptr)
#define USB_memzero(ptr,n)                  memset(ptr,0,n)
#define USB_memcopy(src,dst,n)              memcpy(dst,src,n)
#define USB_install_isr(n, isr, devhandle, intrhandle)\
                                            USB_int_install_isr(n, isr, devhandle, intrhandle)
#define USB_uninstall_isr(n, intrhandle)\
                                            USB_int_uninstall_isr(n, intrhandle)
extern uint_8 _bsp_get_usb_vector(uint_8);
extern pointer _bsp_get_usb_base(uint_8);

#else

#define USB_lock()                           _int_disable()
#define USB_unlock()                         _int_enable()
#define USB_memalloc(n)                      _mem_alloc_system_zero(n)
//#define USB_memfree(ptr)                     _mem_free(ptr)
#define USB_memfree(ptr)                     
#define USB_memzero(ptr,n)                   _mem_zero(ptr,n)
#define USB_memcopy(src,dst,n)               _mem_copy(src,dst,n)
#define USB_install_isr(vector, isr, data)   _int_install_isr(vector, isr, data)


#endif

#endif

/* EOF */

