#ifndef __usbprv_otg_h__
#define __usbprv_otg_h__
/*HEADER****************************************************************
************************************************************************
***
*** Copyright (c) 2000-2002 ARC International
*** All rights reserved
***
*** This software embodies materials and concepts which are
*** confidential to ARC International and is made available solely
*** pursuant to the terms of a written license agreement with
*** ARC International.
***
*** $Workfile:usbprv_otg.h$
*** $Revision: #1 $
*** $Date: 2005/08/24 $
***
*** Comments:  This file contains the defnitions which is private to
***            the OTG implementation.
***
************************************************************************
*END*******************************************************************/
#include "vusbhs.h"
#ifndef __USB_OS_MQX__
#include <string.h>
#include <stdlib.h>
#endif

#define TA_WAIT_BCON_TMR_FOR_EVER

/* Enable this for debug */
#define OTG_LOG_STATE            

/*
**  A-DEVICE timing  constants
*/
/* Wait for VBUS Rise  */
#define TA_WAIT_VRISE 		(102) 	/* a_wait_vrise 100 ms, section: 6.6.5.1 */

/* Wait for B-Connect */
#define TA_WAIT_BCON  		(202) 	/* a_wait_bcon 200 ms, section: 6.6.5.2 */

/* A-Idle to B-Disconnect */
#define TA_AIDL_BDIS  		(302) 	/* a_suspend 150 ms, section: 6.6.5.3 */

/*
**  B-DEVICE timing constants.
*/

/* SE0 Time Before SRP */
#define TB_SE0_SRP 			(5) 		/* b_idle 2 ms 5.3.2 */

/* Data-Line Pulse Time*/
#define TB_DATA_PLS  		(9)      /* b_srp_init 5 to 10 ms, section: 5.3.3 */

#define TB_DATA_PLS_MIN		(2) 		/* b_srp_init 5 to 10 ms, section: 5.3.3 */

/* SRP Initiate Time  */
#define TB_SRP_INIT  		(102) 	/* b_srp_init 100 ms, section: 5.3.8 */

/* SRP Fail Time  */
#define TB_SRP_FAIL  		(20002) 	/* b_srp_init 5 to 30 sec,section: 6.8.2.2*/

/* A-SE0 to B-Reset  */
#define TB_ASE0_BRST  		(6) 		/* b_wait_acon 3.125, section: 6.8.2.4 */

#define TB_BUS_RESUME		(12)

/* Timer Macros */
#define TB_SRP_FAIL_TMR_ON(s,t)    		((s)->TB_SRP_FAIL_TMR = t)
#define TB_SRP_FAIL_TMR_OFF(s)     		((s)->TB_SRP_FAIL_TMR = -1)
#define TB_SRP_FAIL_TMR_EXPIRED(s)  	((s)->TB_SRP_FAIL_TMR ==  0)

#define TB_SRP_INIT_TMR_ON(s,t)   		((s)->TB_SRP_INIT_TMR = t)
#define TB_SRP_INIT_TMR_OFF(s)    		((s)->TB_SRP_INIT_TMR = -1)
#define TB_SRP_INIT_TMR_EXPIRED(s)    	((s)->TB_SRP_INIT_TMR == 0)

#define TB_DATA_PLS_TMR_ON(s,t) 			((s)->TB_DATA_PLS_TMR = t)
#define TB_DATA_PLS_TMR_OFF(s) 			((s)->TB_DATA_PLS_TMR = -1)
#define TB_DATA_PLS_TMR_EXPIRED(s) 		((s)->TB_DATA_PLS_TMR == 0)

#define TB_ASE0_BRST_TMR_ON(s,t)  		((s)->TB_ASE0_BRST_TMR = t)
#define TB_ASE0_BRST_TMR_OFF(s)    		((s)->TB_ASE0_BRST_TMR = -1)
#define TB_ASE0_BRST_TMR_EXPIRED(s) 	((s)->TB_ASE0_BRST_TMR == 0)

#define TA_WAIT_VRISE_TMR_ON(s,t)  		((s)->TA_WAIT_VRISE_TMR = t)
#define TA_WAIT_VRISE_TMR_OFF(s)    	((s)->TA_WAIT_VRISE_TMR = -1)
#define TA_WAIT_VRISE_TMR_EXPIRED(s) 	((s)->TA_WAIT_VRISE_TMR == 0)

#define TA_WAIT_BCON_TMR_ON(s,t)  		((s)->TA_WAIT_BCON_TMR = t)
#define TA_WAIT_BCON_TMR_OFF(s)    		((s)->TA_WAIT_BCON_TMR = -1)
#define TA_WAIT_BCON_TMR_EXPIRED(s) 	((s)->TA_WAIT_BCON_TMR == 0)

#define TA_AIDL_BDIS_TMR_ON(s,t)  		((s)->TA_AIDL_BDIS_TMR = t)
#define TA_AIDL_BDIS_TMR_OFF(s)    		((s)->TA_AIDL_BDIS_TMR = -1)
#define TA_AIDL_BDIS_TMR_EXPIRED(s) 	((s)->TA_AIDL_BDIS_TMR == 0)

#define TB_SE0_SRP_TMR_ON(s,t)  			((s)->TB_SE0_SRP_TMR = t)
#define TB_SE0_SRP_TMR_OFF(s)    		((s)->TB_SE0_SRP_TMR = -1)
#define CHECK_TB_SE0_SRP_TMR_OFF(s) 	((s)->TB_SE0_SRP_TMR == -1)
#define TB_SE0_SRP_TMR_EXPIRED(s) 		((s)->TB_SE0_SRP_TMR == 0)

#define A_SRP_TMR_ON(s,t)  				((s)->A_SRP_TMR = t)
#define A_SRP_TMR_OFF(s)    				((s)->A_SRP_TMR = -1)
#define A_SRP_TMR_EXPIRED(s) 				((s)->A_SRP_TMR == 0)

typedef struct otg_state_machine_struct {
   boolean           	A_BUS_DROP;
   boolean           	A_BUS_REQ;
   boolean           	B_BUS_REQ;
   boolean              HOST_UP;
	boolean              DEVICE_UP;
   boolean           	A_SRP_DET;
   int_32               A_SRP_TMR;
	boolean 					A_DATA_PULSE_DET;
   int_32				   TB_SE0_SRP_TMR;
   boolean           	B_SE0_SRP;
	uint_32              OTG_INT_STATUS;
	boolean           	A_BUS_RESUME;
	boolean           	A_BUS_SUSPEND;
	boolean           	A_BUS_SUSPEND_REQ;
	boolean           	A_CONN;
	boolean           	B_BUS_RESUME;
	boolean           	B_BUS_SUSPEND;
	boolean           	B_CONN;
	boolean           	A_SET_B_HNP_EN;
	boolean           	B_SESS_REQ;
	boolean           	B_SRP_DONE;
	boolean           	B_HNP_ENABLE;
   boolean              JSTATE;
   uint_32              JSTATE_COUNT;
	/* A device specific timers */
	int_32				   TA_WAIT_VRISE_TMR;
	int_32				   TA_WAIT_BCON_TMR;
	int_32				   TA_AIDL_BDIS_TMR;
	/* B device specific timers */
	int_32				   TB_DATA_PLS_TMR;
	int_32				   TB_SRP_INIT_TMR;
	int_32				   TB_SRP_FAIL_TMR;
	int_32               TB_ASE0_BRST_TMR;
   uint_8               STATE;
} OTG_STATE_MACHINE_STRUCT, _PTR_ OTG_STATE_MACHINE_STRUCT_PTR;

/* define the hardware specific registers */
#ifdef __VUSB32__
/* OTG Interrupt Status Register Bit Masks */
#define  OTG_INT_STATUS_A_VBUS                	(0x01)
#define  OTG_INT_STATUS_B_SESS                	(0x04)
#define  OTG_INT_STATUS_SESS_VLD              	(0x08)
#define  OTG_INT_STATUS_LINE_STATE_CHANGE       (0x20)
#define  OTG_INT_STATUS_1_MSEC                  (0x40)
#define  OTG_INT_STATUS_ID                   	(0x80)

/* OTG Interrupt Enable Register Bit Masks */
#define  OTG_INT_ENABLE_A_VBUS                	(0x01)
#define  OTG_INT_ENABLE_B_SESS                 	(0x04)
#define  OTG_INT_ENABLE_SESS_VLD              	(0x08)
#define  OTG_INT_ENABLE_1_MSEC                 	(0x40)
#define  OTG_INT_ENABLE_ID                     	(0x80)

/* OTG   Status Register Bit Masks */
#define  OTG_STAT_A_VBUS_VLD               		(0x01)
#define  OTG_STAT_B_SESS_END               		(0x04)
#define  OTG_STAT_SESS_VLD                 		(0x08)
#define  OTG_STAT_LINE_STATE_CHANGE             (0x20)
#define  OTG_STAT_1_MSEC_VLD               		(0x40)
#define  OTG_STAT_ID_VLD                   		(0x80)


/* OTG  Control Register Bit Masks */
#define  OTG_CTL_VBUS_DSCHG             	   	(0x01)
#define  OTG_CTL_VBUS_CHG             	      	(0x02)
#define  OTG_CTL_OTG_ENABLE           	      	(0x04)
#define  OTG_CTL_VBUS_ON              	      	(0x08)
#define  OTG_CTL_DM_LOW             	         (0x10)
#define  OTG_CTL_DP_LOW             	         (0x20)
#define  OTG_CTL_DM_HIGH                    		(0x40)
#define  OTG_CTL_DP_HIGH                    		(0x80)


#define START_TIMER(x)   ((x)->OTG_INT_ENABLE |= OTG_INT_ENABLE_1_MSEC)
#define STOP_TIMER(x)  ((x)->OTG_INT_ENABLE &= ~OTG_INT_ENABLE_1_MSEC)

/*
** Interrupt status register signals
*/

#define ID_CHG(mask)          ((mask & OTG_INT_STATUS_ID))
#define SESS_VLD_CHG(mask)    ((mask & OTG_INT_STATUS_SESS_VLD))
#define A_VBUS_CHG(mask)      ((mask & OTG_INT_STATUS_A_VBUS))

/*
** status register signals
*/
#define SESS_VLD_FALSE(x)     (!((x)->OTG_STAT & OTG_STAT_SESS_VLD))
#define SESS_VLD(x)           (((x)->OTG_STAT & OTG_STAT_SESS_VLD))
#define B_SESS_END(x)         (((x)->OTG_STAT & OTG_STAT_B_SESS_END))

#define ID(x)                 (((x)->OTG_STAT & OTG_STAT_ID_VLD))
#define ID_FALSE(x)           (!((x)->OTG_STAT & OTG_STAT_ID_VLD))
#define A_VBUS_VLD(x)         (((x)->OTG_STAT & OTG_STAT_A_VBUS_VLD))
#define A_VBUS_VLD_FALSE(x)   (!((x)->OTG_STAT & OTG_STAT_A_VBUS_VLD))
#define STABLE_J_SE0_LINE_STATE(x) (((x)->OTG_STAT) & OTG_STAT_LINE_STATE_CHANGE)

/*
** OTG controll register signals
*/
/* discharge the VBUS */
#define VBUS_DSCHG_ON(x)      ((x)->OTG_CTL |= OTG_CTL_VBUS_DSCHG)
#define VBUS_DSCHG_OFF(x)     ((x)->OTG_CTL &= ~OTG_CTL_VBUS_DSCHG)

/* TURN OFF VBUS chraging. */
#define VBUS_CHG_ON(x)        ((x)->OTG_CTL |= OTG_CTL_VBUS_CHG)
#define VBUS_CHG_OFF(x)       ((x)->OTG_CTL &= ~OTG_CTL_VBUS_CHG)

#define VBUS_ON(x)            ((x)->OTG_CTL |= OTG_CTL_VBUS_ON)
#define VBUS_OFF(x)           ((x)->OTG_CTL &= ~OTG_CTL_VBUS_ON)

#define VBUS_DM_LOW_ON(x)     ((x)->OTG_CTL |= OTG_CTL_DM_LOW)
#define VBUS_DM_LOW_OFF(x)    ((x)->OTG_CTL &= ~OTG_CTL_DM_LOW)

#define VBUS_DP_LOW_ON(x)     ((x)->OTG_CTL |= OTG_CTL_DP_LOW)
#define VBUS_DP_LOW_OFF(x)    ((x)->OTG_CTL &= ~OTG_CTL_DP_LOW)

#define DM_HIGH_ON(x)         ((x)->OTG_CTL |= OTG_CTL_DM_HIGH )
#define DM_HIGH_OFF(x)        ((x)->OTG_CTL &= ~OTG_CTL_DM_HIGH )
#define DP_HIGH_ON(x)         ((x)->OTG_CTL |= OTG_CTL_DP_HIGH )
#define DP_HIGH_OFF(x)        ((x)->OTG_CTL &= ~OTG_CTL_DP_HIGH )

#define PULL_UP_PULL_DOWN_HOST_CTRL(x)	   (x)->OTG_CTL |= (OTG_CTL_DP_LOW | OTG_CTL_DM_LOW); \
                                          (x)->OTG_CTL &= ~(OTG_CTL_DP_HIGH | OTG_CTL_DM_HIGH); 

#define PULL_UP_PULL_DOWN_DEVICE_CTRL(x)  (x)->OTG_CTL |= (OTG_CTL_DP_HIGH | OTG_CTL_DM_LOW); \
                                          (x)->OTG_CTL &= ~(OTG_CTL_DM_HIGH | OTG_CTL_DP_LOW )

#define PULL_UP_PULL_DOWN_IDLE(x)         (x)->OTG_CTL |= (OTG_CTL_DM_LOW); \
                                          (x)->OTG_CTL &= ~(OTG_CTL_DM_HIGH | OTG_CTL_DP_LOW | OTG_CTL_DP_HIGH)

/* clear D + */
#define PULL_UP_PULL_DOWN_LOW_SPEED(x)    (x)->OTG_CTL &= ~OTG_CTL_DM_LOW; 

/* clear D - */
#define PULL_UP_PULL_DOWN_FULL_SPEED(x)   (x)->OTG_CTL &= ~OTG_CTL_DP_LOW;

#define OTG_HOST_INIT(x, y) \
   PULL_UP_PULL_DOWN_HOST_CTRL(y); \
   (x)->SERVICE((pointer)(x), USB_OTG_HOST_UP);
         
#define OTG_DEVICE_INIT(x, y) \
   (x)->SERVICE((pointer)(x), USB_OTG_DEVICE_UP); \
   PULL_UP_PULL_DOWN_DEVICE_CTRL(y);

/*
** USB core signals
*/

#define SE0(x)  ((x)->CONTROL & VUSB_CTRL_SINGLE_ENDED_0 )
#define JSTATE(x)  ((x)->CONTROL & VUSB_CTRL_JSTATE)
#define SPEED(x)  ((x)->ADDRESS & VUSB_ADDR_LS_EN)

typedef struct otg_struct
{
   USB_REGISTER  OTG_INT_STAT;         /* OTG Interrupt Status Register */
   USB_REGISTER  OTG_INT_ENABLE;       /* OTG Interrupt Enable Register */
   USB_REGISTER  OTG_STAT;             /* OTG status Register */
   USB_REGISTER  OTG_CTL;              /* OTG Control Register */
} OTG_STRUCT, _PTR_ OTG_STRUCT_PTR;

#else

#define START_TIMER(x) \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & ~VUSBHS_OTGSC_INTERRUPT_STATUS_BITS_MASK); \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC = (temp | VUSBHS_OTGSC_1MSIE)); \
      (usb_otg_ptr->ENABLED_INTERRUPTS |= VUSBHS_OTGSC_1MSIE); \
   }


#define STOP_TIMER(x) \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & ~VUSBHS_OTGSC_INTERRUPT_STATUS_BITS_MASK); \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC = (temp & ~VUSBHS_OTGSC_1MSIE)); \
      (usb_otg_ptr->ENABLED_INTERRUPTS &= ~VUSBHS_OTGSC_1MSIE); \
   }

/*
** Interrupt status register signals
*/

#define ID_CHG(mask)          (mask & VUSBHS_OTGSC_IDIS)
#define SESS_VLD_CHG(mask)    (mask & (VUSBHS_OTGSC_ASVIS | VUSBHS_OTGSC_BSVIS))
#define A_VBUS_CHG(mask)      (mask & VUSBHS_OTGSC_AVVIS)

/*
** status register signals
*/
#define SESS_VLD_FALSE(x)     \
   ((!(x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & \
   (VUSBHS_OTGSC_BSV | VUSBHS_OTGSC_ASV)))
   
#define SESS_VLD(x)           \
   (((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & \
   (VUSBHS_OTGSC_BSV | VUSBHS_OTGSC_ASV)))
   
#define B_SESS_END(x)         \
   (((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & \
   VUSBHS_OTGSC_BSE))

#define ID(x)                 \
   (((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & VUSBHS_OTGSC_ID))
   
#define ID_FALSE(x)           \
   (!((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & VUSBHS_OTGSC_ID))
   
#define A_VBUS_VLD(x)         \
   (((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & VUSBHS_OTGSC_AVV))

#define A_VBUS_VLD_FALSE(x)   \
   (!((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & \
   VUSBHS_OTGSC_AVV))
   
#define STABLE_J_SE0_LINE_STATE(x) (TRUE)

/*
** OTG control register signals
*/
/* discharge the VBUS */
#define VBUS_DSCHG_ON(x)      \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & ~VUSBHS_OTGSC_INTERRUPT_STATUS_BITS_MASK); \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC = (temp | VUSBHS_OTGSC_VD)); \
   }
   
#define VBUS_DSCHG_OFF(x)     \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & ~VUSBHS_OTGSC_INTERRUPT_STATUS_BITS_MASK); \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC = (temp & ~VUSBHS_OTGSC_VD)); \
   }

/* TURN ON/OFF VBUS charging */
#define VBUS_CHG_ON(x)        \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & ~VUSBHS_OTGSC_INTERRUPT_STATUS_BITS_MASK); \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC = (temp | VUSBHS_OTGSC_VC)); \
   }
   
#define VBUS_CHG_OFF(x)       \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & ~VUSBHS_OTGSC_INTERRUPT_STATUS_BITS_MASK); \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC = (temp & ~VUSBHS_OTGSC_VC)); \
   }

#define VBUS_ON(x)            \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.PORTSCX[0]); \
      temp &= ~EHCI_PORTSCX_W1C_BITS; \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.PORTSCX[0] = (temp | EHCI_PORTSCX_PORT_POWER)); \
   }
   
#define VBUS_OFF(x)           \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.PORTSCX[0]); \
      temp &= ~EHCI_PORTSCX_W1C_BITS; \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.PORTSCX[0] = (temp & ~EHCI_PORTSCX_PORT_POWER)); \
   }

#define DM_HIGH_ON(x)

#define DM_HIGH_OFF(x)

#define DP_HIGH_ON(x)         \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & ~VUSBHS_OTGSC_INTERRUPT_STATUS_BITS_MASK); \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC = (temp | VUSBHS_OTGSC_DP)); \
   }
   
#define DP_HIGH_OFF(x)        \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & ~VUSBHS_OTGSC_INTERRUPT_STATUS_BITS_MASK); \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC = (temp & ~VUSBHS_OTGSC_DP)); \
   }

#define SE0(x)                \
   (((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.PORTSCX[0] & \
      EHCI_PORTSCX_LINE_STATUS_BITS) == EHCI_PORTSCX_LINE_STATUS_SE0)
      
#define JSTATE(x)    (TRUE)

#define KSTATE(x)             \
   (((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.PORTSCX[0] & \
      EHCI_PORTSCX_LINE_STATUS_BITS) == EHCI_PORTSCX_LINE_STATUS_KSTATE)
      
#define PULL_UP_PULL_DOWN_HOST_CTRL(x) \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & ~VUSBHS_OTGSC_INTERRUPT_STATUS_BITS_MASK); \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC = (temp | VUSBHS_OTGSC_B_HOST_EN)); \
   }

#define PULL_UP_PULL_DOWN_DEVICE_CTRL(x)  \
   { \
      uint_32  temp; \
      temp = ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC & ~VUSBHS_OTGSC_INTERRUPT_STATUS_BITS_MASK); \
      ((x)->REGISTERS.OPERATIONAL_HOST_REGISTERS.OTGSC = (temp | VUSBHS_OTGSC_OT)); \
   }

#define PULL_UP_PULL_DOWN_IDLE(x)

#define OTG_HOST_INIT(x, y) \
   (x)->SERVICE((pointer)(x), USB_OTG_HOST_UP); \
   PULL_UP_PULL_DOWN_HOST_CTRL(y);
         
#define OTG_DEVICE_INIT(x, y) \
   (x)->SERVICE((pointer)(x), USB_OTG_DEVICE_UP); \
   PULL_UP_PULL_DOWN_DEVICE_CTRL(y);

typedef  VUSB20_REG_STRUCT       USB_STRUCT;
typedef  VUSB20_REG_STRUCT       OTG_STRUCT;

typedef  VUSB20_REG_STRUCT_PTR   USB_STRUCT_PTR;
typedef  VUSB20_REG_STRUCT_PTR   OTG_STRUCT_PTR;
#endif

typedef struct usb_otg_state_structure {
   pointer                             OTG_REG_PTR;
   pointer                             USB_REG_PTR;
   boolean                             DO_SRP;
	OTG_STATE_MACHINE_STRUCT_PTR   		STATE_STRUCT_PTR;
   void (_CODE_PTR_                    SERVICE)(pointer, uint_32);
   pointer             						CALLBACK_STRUCT_PTR;
   uint_32                             ENABLED_INTERRUPTS;
	uint_8       		  						DEV_NUM;
#ifdef OTG_LOG_STATE
	uchar                               LOG_STATE[100];
	uchar                               LOG_STATE_COUNT;
#endif
} USB_OTG_STATE_STRUCT, _PTR_ USB_OTG_STATE_STRUCT_PTR;

extern USB_OTG_STATE_STRUCT_PTR usb_otg_state_struct_ptr;

/* Prototypes */

#ifdef __cplusplus
extern "C" {
#endif
extern void _usb_otg_state_machine(_usb_otg_handle);
extern void _usb_otg_process_b_idle(_usb_otg_handle);
extern void _usb_otg_process_a_idle(_usb_otg_handle);
extern void _usb_otg_process_a_wait_vrise(_usb_otg_handle);
extern void _usb_otg_process_a_wait_vfall(_usb_otg_handle);
extern void _usb_otg_process_b_device_session_valid(_usb_otg_handle);
extern void _usb_otg_process_b_srp_init(_usb_otg_handle);
extern boolean _usb_otg_process_timers(_usb_otg_handle);
extern boolean _usb_otg_process_exceptions(_usb_otg_handle);
extern void  _usb_otg_reset_state_machine(_usb_otg_handle);
extern void _usb_host_bus_control(pointer, uint_8); 

#ifdef __VUSB32__
   #ifdef __USB_OS_MQX__
   extern void _usb_otg_vusb11_isr(_usb_otg_handle);
   extern void _usb_hci_vusb11_isr(pointer);
   extern void _usb_dci_vusb11_isr(pointer);
   #else
   extern void OTG_INTERRUPT_ROUTINE_KEYWORD _usb_otg_vusb11_isr(void);
   extern void HOST_INTERRUPT_ROUTINE_KEYWORD _usb_hci_vusb11_isr(void);
   extern void DEVICE_INTERRUPT_ROUTINE_KEYWORD _usb_dci_vusb11_isr(void);
   #endif
   uint_8 _usb_otg_vusb11_init(_usb_otg_handle);
   extern void _usb_otg_vusb11_shutdown(_usb_otg_handle);
#else
   #ifdef __USB_OS_MQX__
   extern void _usb_otg_vusbhs_isr(_usb_otg_handle);
   extern void _usb_hci_vusb20_isr(pointer);
   extern void _usb_dci_vusb20_isr(pointer);
   #else
   extern void OTG_INTERRUPT_ROUTINE_KEYWORD _usb_otg_vusbhs_isr(void);
   extern void HOST_INTERRUPT_ROUTINE_KEYWORD _usb_hci_vusb20_isr(void);
   extern void DEVICE_INTERRUPT_ROUTINE_KEYWORD _usb_dci_vusb20_isr(void);
   #endif
   uint_8 _usb_otg_vusbhs_init(_usb_otg_handle);
   extern void _usb_otg_vusbhs_shutdown(_usb_otg_handle);
#endif

#ifdef __cplusplus
}
#endif
#endif

/* EOF */
   





