/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/transport/usb/target/arcusb/platform.h#1 $
 *
 * Copyright (c) 2000-2004 Atheros Communications, Inc., All Rights Reserved
 *
 * platform.h - Platform abstraction for the ARCUSB SW 
 *
 */
#ifndef __PLATFORM_H__
#define __PLATFORM_H__

#include "ecosdrv.h"

/*
 *  STANDARD TYPES
 */

#define _PTR_      *
#define _CODE_PTR_ *

typedef A_CHAR            _PTR_     char_ptr;  /* signed character       */
typedef A_UCHAR    uchar, _PTR_    uchar_ptr;  /* unsigned character     */        
typedef A_CHAR     int_8, _PTR_    int_8_ptr;  /* 8-bit signed integer   */
typedef A_UCHAR   uint_8, _PTR_   uint_8_ptr;  /* 8-bit signed integer   */
typedef A_INT16   int_16, _PTR_   int_16_ptr;  /* 16-bit signed integer  */
typedef A_UINT16 uint_16, _PTR_  uint_16_ptr;  /* 16-bit unsigned integer*/
typedef A_INT32   int_32, _PTR_   int_32_ptr;  /* 32-bit signed integer  */
typedef A_UINT32 uint_32, _PTR_  uint_32_ptr;  /* 32-bit unsigned integer*/
typedef A_BOOL                       boolean;  /* boolean */
typedef void _PTR_                   pointer;  /* pointer */


/*
 *  STANDARD CONSTANTS
 */

#ifdef  FALSE
   #undef  FALSE
#endif
#define FALSE ((boolean)0)

#ifdef  TRUE
   #undef  TRUE
#endif
#define TRUE ((boolean)1) 

#ifdef  NULL
   #undef  NULL
#endif

#ifdef __cplusplus
   #define NULL (0)
#else
   #define NULL ((pointer)0)
#endif

/*
 *  MACROS 
 */
#ifndef MIN
#define MIN(a, b)       ((a) < (b)? (a): (b))
#endif
#ifndef MAX
#define MAX(a, b)       ((a) > (b)? (a): (b))
#endif

#define USB_uint_16_low(x)              ((x) & 0xFF) 
#define USB_uint_16_high(x)             (((x) >> 8) & 0xFF)
                                                           
#define BIG_ENDIAN                      1
#define HW_OP_POLL_TIMEOUT              (1024)
#define USB_MAX_DEV                     (1)
#define DATA_CACHE_INVAL(addr, len)     A_DATA_CACHE_INVAL(addr, len)
#define USB_CAPABILITY_REG_OFFSET       (0x100)
#define LOCK_TASKS()                    cyg_scheduler_lock()  
#define UNLOCK_TASKS()                  cyg_scheduler_unlock()


extern A_UINT32 athUsbDebug;

#define USB_DEBUG                   (0xFFFFFFFF)
#define USB_CONTROL_DEBUG           (0x00000001)
#define USB_SEND_DEBUG              (0x00000002)
#define USB_RECV_DEBUG              (0x00000004)
#define USB_SPEED_DEBUG             (0x00000008)
#define USB_RESET_DEBUG             (0x00000010)
#define USB_SUSPEND_DEBUG           (0x00000020)
#define USB_INIT_DEBUG              (0x00000040)

#ifdef DEBUG
#define USB_DEBUG_PRINTF(FLAG, ARG)     \
    if (athUsbDebug & (FLAG)) {         \
        diag_printf ARG;                \
    }       
#else
#define USB_DEBUG_PRINTF(FLAG, ARG)     
#endif
    
#ifdef __cplusplus
extern "C" {
#endif

extern A_STATUS USB_int_init (A_UINT8, void (*isr)(void *), void (*dsr)(void *), void *, void **);
extern A_STATUS USB_int_deinit (A_UINT8, void  *);
extern void USB_int_install_isr(uint_8, void (*Isr)(void *), void *, void **);
extern void USB_int_uninstall_isr(uint_8, void *);
extern void USB_int_defer_status (void *,A_UINT8 status);

extern void _disable_interrupts(uint_8);
extern void _enable_interrupts(uint_8);
extern void _platform_lock(uint_8);
extern void _platform_unlock(uint_8);

#ifdef __cplusplus
}
#endif
   
#endif  /*__PLATFORM_H__ */

