#ifndef FLASHDISK_H
#define FLASHDISK_H
/*****************************************************************************
**                                                                          **
**                          ATHEROS Communications                          **
**                                                                          **
** **************************************************************************/

/**************************** COPYRIGHT INFORMATION ***************************
**                                                                           **
**   This program contains proprietary information which is a trade          **
**   secret of ATHEROS Communications and also is protected as an            **
**   unpublished work under applicable Copyright laws. Recipient is to       **
**   retain this program in confidence and is not permitted to use or make   **
**   copies thereof other than as permitted in a written agreement with      **
**   ATHEROS Communications.                                                 **
**                                                                           **
** ***************************************************************************/

/******************************************************************************
**                                                                           ** 
** Project       : ATC_FDISK                                                 ** 
**                                                                           ** 
** Module        : FLASH DISK                                                ** 
**                                                                           ** 
** File name     : FlashDisk.h                                               ** 
**                                                                           ** 
** Authors       : Bharathi Thillai-Bharathi.Thillai@wipro.com               ** 
**                 Sajith Kumar M.A-sajith.kumar@wipro.com                   ** 
**                                                                           ** 
** Created On    : Thu June 03 2004                                          ** 
**                                                                           ** 
** Description   : This file Contains the USB Mass storage disk Handlers     **
**                 specific defines                                          ** 
**                                                                           ** 
** Reference(s)  :                                                           ** 
**                                                                           ** 
**                                                                           ** 
** ***************************************************************************/

/******************************************************************************
**                                                                           **
** History                                                                   **
** Date          Revision     Comment                                        **
** 03-June-2004      0         Created                                       **
**                                                                           **
**                                                                           **
*******************************************************************************/


/******************************************************************************
**                                                                           **
**   HEADER (INCLUDE) SECTION   (check protection before include)            **
**                                                                           **
** ****************************************************************************/



/******************************************************************************
**                                                                           **
**                            MACROS                                         **
**                                                                           **
** ****************************************************************************/


#include "usb.h"
#include "platform.h"
#include "devapi.h"
#include "athusb.h"
#include "stdlib.h"
#include "string.h"


#define  USB_DCBWSIGNATURE       (0x43425355)
#define  USB_DCSWSIGNATURE       (0x53425355)
#define  USB_CBW_DIRECTION_BIT   (0x80)
#define  BUFFERSIZE            (2048)

#define  C_PREVENT_ALLOW_MEDIUM_REMOVAL 0x1E
#define  C_READ_CDROM_CAPACITY 0x25
#define  A_FLASH_DISK_NUMBER 0
#define  FD_ERROR        (0x00000001)
#define  FD_WARNING      (0x00000002)
#define  FD_INFO         (0x00000004)
#define  FD_MAIN_INFO    (0x00000008)
#define  FD_DEBUG        (0x00008000)
#define  FLASH_DEBUG     (0x00010000)
#define  DEFAULT_USB_MASS_VENDORID     0x0CF3
#ifdef ATC_CDROM_DISK
#define  DEFAULT_USB_MASS_PRODUCTID    0x0003
#else
#define  DEFAULT_USB_MASS_PRODUCTID    0x0004
#endif

#ifdef USB_DRV_BOOTROM_CONFIG

/* 
 * Only two hardware endpoints are 
 * exposed to the software 
 */
    #define MAX_HW_RECV_ENDPOINTS           (2)
    #define MAX_HW_SEND_ENDPOINTS           (2)

#else

/* 
 * All the available endpoints are 
 * exposed to the software 
 */
    #define MAX_HW_RECV_ENDPOINTS           (10)
    #define MAX_HW_SEND_ENDPOINTS           (2)

#endif /* USB_DRV_BOOTROM_CONFIG */

#define EP_FS_MAX_PACKET_SIZE           (64)
#define EP_HS_MAX_PACKET_SIZE           (512)
#define APP_CONTROL_MAX_PKT_SIZE        (64)
#define MAX_HW_ENDPOINTS                (MAX_HW_SEND_ENDPOINTS + MAX_HW_RECV_ENDPOINTS)

enum
{
    ATC_APPLICATION_NOTIFICATION     =0,
    ATC_SWITCH_TO_BOOTLOADER         =1,
    ATC_ENABLE_FLASH_WRITE           =2,
    ATC_ACIVATE_SP_CMD               =3,
    ATC_SET_PASSWORD                 =4,
    ATC_GET_VERSION                  =5,
    ATC_SET_VERSION                  =6,
    ATC_SET_TEST_MODE                =7,
    ATC_FORMAT_DISK                  =8
};

enum
{
    ATC_UPDATE_PENDING_FDISK_WRITE =  100,
    ATC_UPDATE_BOOTLOADER          =  101,
    ATC_WRITE_FDISK                =  102,
    ATC_MASS_STORAGE_SUPPORT_TEST  =  103,
    ATC_START_BOOTLOADER           =  104,
    ATC_FORMAT_FDISK               =  105,
    ATC_AUTORUN_TIMER              =  106,
    ATC_EXECUTE_BOOTLOADER         =  107

};

#define ATC_PASSWORD_LENGTH                     12
#define MS_DATA_OUT_PIPE                       1
#define MS_DATA_IN_PIPE                        2
#define FLASHDISK_CONTEXT                      BOOTROM_CONTEXT
#define ATC_TIME_OUT                           50

#define  FDISK_CMD_SUCCESS                     0xFF
#define  FDISK_CMD_FAILED_INVALID_PASSWORD     0xFE
#define  FDISK_CMD_FAILED_INVALID_VERSION      0xFD
#define  FDISK_CMD_FAILED_INSUFFICIENT_MEMORY  1
#define  FDISK_CMD_FAILED_WRONG_SEQUENCE       2
#define  FDISK_CMD_FAILED_SECTOR_ERASE_FAILED  3
#define  FDISK_CMD_FAILED_SECTOR_WRITE_FAILED  4
#define  FDISK_CMD_FAILED_CHECKSUM_WRONG       5
#define  FDISK_CMD_FAILED_CMD_ALREADY_ACTIVE   6 


#define  ATC_TEST_MODE_ACTIVE                  1
#define  ATC_TEST_MODE_INACTIVE                2
#define  ATC_TEST_MODE_ALREADY_ACTIVE          3
#define  ATC_TEST_MODE_ALREADY_INACTIVE        4
#define  ATC_TEST_MODE_UNSUPPORTED             5
#define  ATC_TEST_MODE_UNABALE_TO_ALLOCATE     7


#define  MAX_DRIVER_VERSION_SIZE               2
#define  MAX_PASSWORD_SIZE                     12

#define  APP_CONTROL_MAX_PKT_SIZE         (64)
#define  DEV_DESC_MAX_PACKET_SIZE         (7)
#define  EP1_FS_MAX_PACKET_SIZE           (64)
#define  EP1_HS_MAX_PACKET_SIZE           (512)
#define  CFG_DESC_EP1TX_MAX_PACKET_SIZE   (22)
#define  CFG_DESC_EP1RX_MAX_PACKET_SIZE   (29)
#define  ATC_DISK_CAPACITY                (1536*1024)    /*1.5 Mbytes */
#define  TOTAL_FDISK_SECTORS              (ATC_DISK_CAPACITY/LENGTH_OF_EACH_LAB)

#ifdef ATC_CDROM_DISK
    #define  LENGTH_OF_EACH_LAB               (2048)
#else
    #define  LENGTH_OF_EACH_LAB               (512)
#endif

#define  FD_CONFIG_DESC_NUM_INTERFACES     (4)
#define  FD_CONFIG_DESC_SIZE               (46)
#define  MS_USB_STR_NUM                    (4)
#define  MAX_RX_BUFFER_SIZE                (0x10000)
#define  MAX_TX_BUFFER_SIZE                (0x10000)


#define  ATC_CDROM                         5
#define  ATC_FIXED_DISK                    0
#define  ATC_DEVICE_TYPE                   ATC_FIXED_DISK
#define  ATAPI_CDROM                       2
#define  SCSI_FIXED_DISK                   6
#define STM_MANUFACTURER                   0x20
#define NEX_MANUFACTURER                   0xEF

#ifdef ATC_CDROM_DISK
    #define  ATC_PROTOCOL                      ATAPI_CDROM
#else
    #define  ATC_PROTOCOL                      SCSI_FIXED_DISK
#endif
#define  sendUsbData _usb_device_send_data
#define  USB_HANDLE _usb_device_handle
#define  getUsbTransferStatus _usb_device_get_transfer_status
#define  cancelUsbTransfer    _usb_device_cancel_transfer
#define  receiveUsbData       _usb_device_recv_data
#define  UINT16_LOW(x)              ((x) & 0xFF) 
#define  UINT16_HIGH(x)             (((x) >> 8) & 0xFF)





/******************************************************************************
**                                                                           **
**                        Structures                                         **
**                                                                           **
** ***************************************************************************/


/* USB Command Block Wrapper */
typedef struct cbw_struct
{
    uint_32  DCBWSIGNATURE;
    uint_32  DCBWTAG;
    uint_32  DCBWDATALENGTH;
    uchar    BMCBWFLAGS;
    uchar    BCBWCBLUN; /* 4 MSBs bits reserved */
    uchar    BCBWCBLENGTH; /* 3 MSB reserved */
    uchar    CBWCB[16];
} CBW_STRUCT, _PTR_ CBW_STRUCT_PTR;

typedef struct cmd_struct
{
    CBW_STRUCT_PTR   cmdPtr;
    USB_HANDLE       handle; 
} CMD_STRUCT, _PTR_ CMD_STRUCT_PTR;

/* USB Command Status Wrapper */
typedef struct csw_struct
{
    uint_32  DCSWSIGNATURE;
    uint_32  DCSWTAG;
    uint_32  DCSWDATARESIDUE;
    uchar    BCSWSTATUS;
} CSW_STRUCT, _PTR_ CSW_STRUCT_PTR;

/* USB Mass storage Inquiry Command */
typedef struct mass_storage_inquiry
{
    uchar    OPCODE;
    uchar    LUN;
    uchar    PAGE_CODE;
    uchar    RESERVED1;
    uchar    ALLOCATION_LENGTH;
    uchar    RESERVED2[7];
} MASS_STORAGE_INQUIRY_STRUCT, _PTR_ MASS_STORAGE_INQUIRY_PTR;

typedef struct mass_storage_format_capacity
{
    uchar    RESERVED1[3];
    uchar    CP_LIST_LENGHT;
    uchar    NUMBER_OF_BLOCKS[4];
    uchar    FORMAT_TYPE;
    uchar    BLOCK_LENGTH_IN_BYTES[3];

}MASS_STORAGE_FORMAT_CAPACITY_STRUCT,_PTR_ MASS_STORAGE_FORMAT_CAPACITY_STRUCT_PTR;

/* USB Mass storage READ CAPACITY Data */
typedef struct mass_storage_read_capacity
{
    uchar    LAST_LOGICAL_BLOCK_ADDRESS[4];
    uchar    BLOCK_LENGTH_IN_BYTES[4];
} MASS_STORAGE_READ_CAPACITY_STRUCT, _PTR_ MASS_STORAGE_READ_CAPACITY_STRUCT_PTR;


typedef struct flashDisk
{
    uchar    maxLUN;
    uchar    writeEnable;

} FLASH_DISK_INFO, _PTR_ FLASH_DISK_INFO_PTR;


/* USB Mass storage Device information */
typedef struct mass_storage_device_info
{
    uchar    PERIPHERAL_DEVICE_TYPE;    /* Bits 0-4. All other bits reserved */
    uchar    RMB;                       /* Bit 7. All other bits reserved */
    uchar    ANSI_ECMA_ISO_VERSION;     /* ANSI: bits 0-2, ECMA: bits 3-5, 
                                        ** ISO: bits 6-7 
                                        */
    uchar    RESPONSE_DATA_FORMAT;      /* bits 0-3. All other bits reserved */
    uchar    ADDITIONAL_LENGTH;         /* For UFI device: always set to 0x1F */
    uchar    RESERVED1[3];
    uchar    VENDOR_INFORMATION[8];
    uchar    PRODUCT_ID[16];
    uchar    PRODUCT_REVISION_LEVEL[4];
} MASS_STORAGE_DEVICE_INFO_STRUCT, _PTR_ MASS_STORAGE_DEVICE_INFO_PTR;


typedef struct FDISK_CmdInfo
{
    A_UINT32        startAddress;
    A_UINT8         *dataPtr;
    A_UINT32        dataLength;
    A_UINT8         cmdState; 
    A_UINT8         cmdId; 
    A_UINT8         *txBuffer;
    A_UINT32        txLength;
    A_UINT8         *rxBuffer;
    A_UINT32        rxLength;
}FDISK_CMD_INFO_STRUCT;


typedef struct FLASH_Program
{
    A_UINT8         *dataPtr;
    A_UINT16        currentPacketNo;
    A_UINT32        totalLength;
    A_UINT32        currentLength;
    A_UINT32        checkSum;
    A_UINT8         state;
    A_UINT16        startSector;
    A_UINT8         noSectors;
}FLASH_PROG_STRUCT;

typedef struct TEST_Struct
{
    A_UINT8         *buffer;
    A_UINT32        bufferSize;
}TEST_SETUP_STRUCT;

typedef struct deviceContext
{
    A_HANDLE            rtcCounterHandle;
    A_TIMER             timer;
    A_UINT16            option;
}DEV_CONTEXT;


typedef struct DUMMY_DISK
{
    A_UINT8  *buffPtr;
    A_UINT16   flashSector;
    A_UINT8   state;
}DUMMY_DISK_STRUCT;


enum
{
    DEFAULT_STATE=-1,
    WRITE_FLASH_DISK_STATE,
    BOOT_LOADER_UPDATE_STATE,
    SET_PASSWORD_STATE
};
enum
{

    FLASH_PROG_INIT=1,
    FLASH_PROG_DATA,
    FLASH_PROG_VERIFY_CHECKSUM,
    FLASH_PROG_BOOTLOADER,
    FLASH_UPDATE_STATUS,
    EXECUTE_BOOTLOADER

};

extern void MassStorageClass(_usb_device_handle handle,boolean setup,SETUP_STRUCT_PTR setup_ptr);
extern void getDescription(_usb_device_handle handle,boolean setup,SETUP_STRUCT_PTR setup_ptr);

extern void flashDiskRecvIndHandler(
                                   IN APP_HANDLE   appHandle,
                                   IN A_UINT8      pipeNum,
                                   IN A_UINT8      *pBuffer,
                                   IN A_UINT32     bytesReceived
                                   );

extern void flashDiskSendCfmHandler(
                                   IN APP_HANDLE   appHandle,
                                   IN A_UINT8      pipeNum,
                                   IN A_UINT8      *pBuffer,
                                   IN A_UINT32     bytesSent
                                   );

extern void handleScsiUnsupportedCommand(CMD_STRUCT_PTR cmdInfo);

extern void startTimer(A_UINT16 option,
                       A_UINT16 timeout);
extern void startSpTimer(A_UINT16 option,
                         A_UINT16 timeout);
extern void updateBootLoader(void);

extern uint_32 flashDiskDebug;
#ifdef DEBUG_BOOTROM_PLUS
    #define FD_DBG_PRINTF(FLAG, ARG)  \
    if (flashDiskDebug & (FLAG)) {          \
        diag_printf ARG;                    \
    }

    #define FLASHDISK_INFO(ARG)    \
        diag_printf ARG;           

#else                                        
    #define FD_DBG_PRINTF(FLAG, ARG)  

    #define FLASHDISK_INFO(ARG)    \
       diag_printf ARG;          
#endif

#endif
