/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/transport/usb/target/drv/athusb.h#1 $
 *
 * Copyright (c) 2000-2004 Atheros Communications, Inc., All Rights Reserved
 *
 * athusb.h -- Atheros USB header file
 *
 */

#ifndef __ATHUSB_H__
#define __ATHUSB_H__

                    
#include <athusbdrv.h>
#include <queue.h>
#include <cyg/hal/plf_bcfg.h>
#include <cyg/hal/plf_misc.h>

/*
 * MAX_NUM_DSR_EVENTS should be sized to handle the total number of
 * messages in flight.
 *
 * 11 TX, 11 RX, 2 CTRL_INCOMING, 16 CTRL_OUTGOING
 *
 */

#define MAX_NUM_DSR_EVENTS  64
#define DRV_EVENT_RECV      0
#define DRV_EVENT_SEND      1

typedef  void * DEV_HANDLE;
typedef  void * INTR_HANDLE;

/* definitions transfer events contents */
typedef enum {
    XFER_EVENT,
    CTRL_EVENT
} USBDRV_EVENT_TYPE;


typedef struct _XferEvent {
    A_UINT8      pipeNum;
    A_UINT8      xferDir;
    A_UINT8      *pBuffer;
    A_UINT32     xferLen;      
} XferEvent;

typedef struct _CtrlEvent {
    USBDRV_EVENT drvEvent;
} CtrlEvent;

/* Node definition for storing events */
typedef struct drvEventNode {
	STAILQ_ENTRY(drvEventNode)    nextEvent;	
    A_UINT8                       eventType;
    union {
        XferEvent                 xferEvent;
        CtrlEvent                 ctrlEvent;
    } event;
}drvEventNode;

typedef STAILQ_HEAD(drvEventList, drvEventNode) DrvEventList;

/* OS related parameters for the driver */
typedef  struct _USB_DRV_OS_CTXT {
    DrvEventList    dsrEventList;
    DrvEventList    freeEventList;
    drvEventNode    eventNodeList[MAX_NUM_DSR_EVENTS];
} USB_DRV_OS_CTXT, * PUSB_DRV_OS_CTXT;

/* Atheros USB driver Context */
typedef struct _ATHUSBDRV_HANDLE {
    A_UINT8                     deviceNum;
    APP_HANDLE                  appHandle;
    RECV_INDICATION_HANDLER     recvIndHandler;
    SEND_CONFIRM_HANDLER        sendCfmHandler;
    DEV_HANDLE                  deviceHandle;
    PUSB_DRV_OS_CTXT            pOsContext;
    INTR_HANDLE                 pIntHandle;
    DRV_EVENT_HANDLER           usbEventHandler[DRV_MAX_EVENTS];
} USBDRV_HANDLE, * PUSBDRV_HANDLE;


/* USB 2.0 Setup Packet */
typedef struct setup_struct {
   A_UINT16     VALUE;
   A_UINT8      REQUEST;
   A_UINT8      REQUESTTYPE;
   A_UINT16     LENGTH;
   A_UINT16     INDEX;
} SETUP_STRUCT, _PTR_ SETUP_STRUCT_PTR;

/* 
 * Functions Shared between the ARC layer of the driver and atheros layer 
 * of the driver
 */
#ifdef __cplusplus
extern "C" {
#endif

void athUsbProcessXferEvents(
    IN DRV_HANDLE  drvHandle
    );

extern void 
athUsbDrvSendRecv(    
    IN PUSBDRV_HANDLE   pUsbDrvHandle,
    IN A_UINT8          epNum,
    IN A_UINT8          xferDir,
    IN A_UINT8          *pbuffer,
    IN A_UINT32         length      
   );

extern void 
athUsbDrvCtrlEvent(    
    IN PUSBDRV_HANDLE       pUsbDrvHandle,
    IN USBDRV_EVENT         usbEvent
   );

extern A_STATUS 
arcInit(
    PUSBDRV_HANDLE      drv_handle,
    A_UINT8             usb_dev_num
    );

extern A_STATUS 
arcShutdown(
    PUSBDRV_HANDLE      drv_handle
    );

extern A_STATUS 
arcResume (
    PUSBDRV_HANDLE  drv_handle
    );

#ifdef __cplusplus
}
#endif

#endif /* __ATHUSBDRV_H__ */

