/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/transport/usb/target/drv/athusbdrv.h#1 $
 *
 * Copyright (c) 2000-2004 Atheros Communications, Inc., All Rights Reserved
 *
 * athusbdrv.h -- Atheros USB Driver header file
 *
 */

#ifndef __ATHUSBDRV_H__
#define __ATHUSBDRV_H__

#define IN
#define OUT

/* Application Handler */
typedef void * APP_HANDLE;
/* Driver Handler */
typedef void * DRV_HANDLE;

typedef enum {
    DRV_SUSPEND_EVENT,
    DRV_RESUME_EVENT,
    DRV_RESET_EVENT,
    DRV_INIT_EVENT,
    DRV_MAX_EVENTS
} USBDRV_EVENT;

typedef void (*RECV_INDICATION_HANDLER)(
                            IN APP_HANDLE   appHandle,
                            IN A_UINT8      pipeNum,
                            IN A_UINT8     *pBuffer,
                            IN A_UINT32     bytesReceived
                        );

typedef void  (*SEND_CONFIRM_HANDLER)(
                            IN APP_HANDLE   appHandle,
                            IN A_UINT8      pipeNum,
                            IN A_UINT8      *pBuffer,
                            IN A_UINT32     bytesSent
                        );

typedef void  (*DRV_EVENT_HANDLER)(
                            IN APP_HANDLE   appHandle
                        );
#ifdef __cplusplus
extern "C" {
#endif

extern 
A_STATUS 
athUsbDrvInit( 
    IN  A_UINT8                  usbDeviceNum,
    IN  APP_HANDLE               appHandle,
    IN  RECV_INDICATION_HANDLER  recvIndHandler,
    IN  SEND_CONFIRM_HANDLER     sendCfmHandler,
    OUT DRV_HANDLE              *pDrvHandle,
    OUT A_UINT8                 *pSendPipes,
    OUT A_UINT8                 *pRecvPipes
    );

extern A_STATUS 
athUsbDrvRecv(              
    IN DRV_HANDLE               drvHandle,
    IN A_UINT8                  pipeNum,
    IN A_UINT8                 *pBuffer
    );

#ifdef DO_ZERO_TERM
extern A_STATUS 
athUsbDrvSend(    
    IN DRV_HANDLE               drvHandle,
    IN A_UINT8                  pipeNum,
    IN A_UINT8                  *pBuffer,
    IN A_UINT32                 bufSize
   );
#else
extern A_STATUS 
athUsbDrvSend(    
    IN DRV_HANDLE               drvHandle,
    IN A_UINT8                  pipeNum,
    IN A_UINT8                  *pBuffer
   );
#endif

extern A_STATUS 
athUsbDrvRegEventHndlr( 
    IN DRV_HANDLE               pDrvHandle,
    IN USBDRV_EVENT             usbEvent,
    IN DRV_EVENT_HANDLER        eventHandler
    );

extern A_STATUS 
athUsbDrvShutdown( 
    IN DRV_HANDLE               pDrvHandle
    );

extern A_STATUS 
athUsbDrvResume (
    IN DRV_HANDLE               pDrvHandle
    );

extern A_STATUS 
athUsbDrvDisable (
    IN DRV_HANDLE               pDrvHandle
    );

extern A_STATUS 
athUsbDrvEnable (
    IN DRV_HANDLE               pDrvHandle
    );

extern A_STATUS
athUsbDrvPoll(
    IN DRV_HANDLE               pDrvHandle
    );

unsigned int
athUsbDrvGetLineState(
    IN DRV_HANDLE               pDrvHandle
    );

#ifdef __cplusplus
}
#endif

#endif /* __ATHUSBDRV_H__ */
