#include "stdlib.h"
#include "string.h"

#define AR5523_FLASH_SIZE  65536
#define SPI_CONTROL_STATUS_REG           0xA0B30000
#define SPI_FLASH_BASE_ADDRESS           0x01000000
#define SPI_FLASH_BASE_ADDRESS_RMAP      0xBFC00000
#define SPI_ADDRESS_OPCODE_REG           0xA0B30004
#define SPI_DATA_REG                     0xA0B30008
#define SPI_FLASH_SELECT                 0xA0B3001C

#define SPI_DISABLE_WRITE                0x00000005
#define SPI_ENABLE_WRITE                 0x00000006
#define SPI_SEND_RECEIVE_ONE_BYTE        0x00000111
#define SPI_SEND_ONE_BYTE                0x00000101
#define SPI_TX_1BYTE_RX_3BYTES           0x00000131
#define SPI_SEND_FOUR_BYTES              0x00000104
#define SPI_SEND_EIGHT_BYTES             0x00000108
#define SPI_SEND_RECEIVE_FOUR_BYTES      0x00000144
#define SPI_BUSY_MASK                    0x10000

#define SPI_SECTOR_ERASE                 0xD8
#define SPI_BULK_ERASE                   0xC7
#define SPI_WRITE_DATA                   0x2
#define SPI_READ_DATA                    0x3
#define SPI_READ_IDENTIFICATION          0x9F

typedef struct FLASH_INFO
{
    A_UINT8 DeviceType;
    A_UINT8 DeviceMID;
    A_UINT8 DeviceSize;

} FLASH_INFO_STRUCT;

extern A_UINT8 wait_on_spi_device_status ( void );
extern void write_enable_spi_device ( void );
extern void write_disable_spi_device ( void );
extern void erase_spi_device ( void );
extern void prog_verify_bootrom_flash( void );
extern A_UINT8 writeFlash(A_UINT32 offset,A_UINT32 *srcPtr,A_UINT32 length);
extern A_UINT8 setFlash(A_UINT32 offset,A_UINT32 data,A_UINT32 length);
extern A_UINT8 eraseSector ( A_UINT16 sectorNo ); //Erase one sector
extern A_UINT32 getFlashSectorSize(void );
extern FLASH_INFO_STRUCT *getDeviceInfo (void);



