#define nonalignedbuffers
#if defined(VXWORKS) || (PCI_NDIS) || defined (Linux)
#include "crypto/swcrypto_common.h"
#else
#include "swcrypto_common.h"
#endif

#ifdef EVA
# include <assert.h>
# ifdef _DEBUG_CCM_
#  define mpx(a,b,c) \
                   {                                                    \
		     int mpx_counter;                                   \
		     io_printf("%s",a);                                 \
		     for (mpx_counter=0;mpx_counter<c;mpx_counter++) {  \
		       io_printf("%02x ",(int)(*(b+mpx_counter)));      \
                       if (mpx_counter && !(mpx_counter%16))            \
                         io_printf("\n");                               \
                     }                                                  \
		     io_printf("\n");                                   \
		   }
# else
#  define mpx(a,b,c)
# endif
#endif


/*
 * private data for ccm encipher/decipher
 * note: the cached key can be removed when
 * an interface is created that will notify
 * ccm when the key is refreshed.
 * Until then we have to check the key on every
 * call to know if the cached key schedule is ok.
 */
/* Changing the types below from A_UINT32 to u32 avoids a lot of compiler
 * warnings */
struct ccm_private {
	u32     rk[44];		// cached aes key schedule
	u8		key[16];	// cached copy of key
};



/*
 * ccm_init
 *	called automagically on the first entry to ccm_encipher/decipher
 *	that  call can be removed if ccm_init is called
 *	before ccm_encipher is invoked.
 *
 *	ccm_init can/should/must also be called on a rekey operation
 */
int
ccm_init(pk)
WLAN_PRIV_RECORD *pk;
{
struct ccm_private *ccm;
int r;


	// clear IV counters
	pk->keyIV = pk->extKeyIV = 0;

	// malloc ccm private data if not already present
	ccm = pk->initValue;
	if (!ccm) {
		ccm = (struct ccm_private *)A_DRIVER_MALLOC(sizeof(struct ccm_private));
		if (!ccm)
			return(A_NO_MEMORY);
		pk->initValue = (void *)ccm;
	}

	// calc aes key schedule
	r = rijndaelKeySetupEnc(ccm->rk, pk->keyVal, 128);
	memcpy(ccm->key, pk->keyVal, 16);
	return(A_OK);
}


#ifdef SELFTEST
/*
 * set_replay function provided for testing
 */
int
ccm_set_replay(pk, lo, hi)
WLAN_PRIV_RECORD *pk;
{
struct ccm_private *ccm;

	ccm = pk->initValue;
	ASSERT(ccm);
	pk->keyIV = lo;
	pk->extKeyIV = hi;
}

/*
 * extract pn from mpdu
 */
void
ccm_get_replay(pk, ivp)
WLAN_PRIV_RECORD *pk;
unsigned char *ivp;
{
unsigned int v;

	v = 0;
	v = ivp[0];
	v |= (ivp[1]<<8);
	pk->keyIV = v;
	v = 0;
	v |= ivp[4];
	v |= ivp[5]<<8;
	v |= ivp[6]<<16;
	v |= ivp[7]<<24;
	pk->extKeyIV = v;
}
#endif

/*
 * ccm_close must be called when the crypto session
 * shuts down to reclaim the ccm_private memory.
 */
void
ccm_close(pk)
WLAN_PRIV_RECORD *pk;
{
    A_DRIVER_FREE(pk->initValue, sizeof(struct ccm_private));
    pk->initValue = 0;
}


/*
 * ccm encipher
 * mpdu is the start address of the frame header.
 * hdrlen is the header length including the 8-byte IV.
 * data,dlen represents the data payload, excluding IV and ICV.
 * data points to the start of the data payload.
 * it is assumed that there is space beginning at &data[dlen]
 * for the 8-byte MIC.
*/
A_STATUS
ccm_encipher(pk, mpdu, hdrlen, data, dlen)
WLAN_PRIV_RECORD *pk;
unsigned char *mpdu, *data;
int hdrlen, dlen;
{
struct ccm_private *ccm;
unsigned char local[16], tmp[16], ctr[16], ct[16], mic[16];
unsigned char cbchdr[48];
unsigned char *cp, *iv;
unsigned char qospri;
int cc, r, n, v, dr, dv, rem, hlen, isqos;

	ASSERT(pk);

	ccm = (struct ccm_private *)pk->initValue;
	if (!ccm) {
		ccm_init(pk);			// setup ccm if not present
		ccm = (struct ccm_private *)pk->initValue;
		if (!ccm) return(A_ERROR);
	}

#ifdef CCM_REKEY
// This not needed as long as ccm_init is called when rekeying
	// calc aes key schedule if key has changed
	if (memcmp(ccm->key, pk->keyVal, 16)) {
		memcpy(pk->keyVal, ccm->key, 16);
		r = rijndaelKeySetupEnc(ccm->rk, pk->keyVal, 128);
	}
#endif

	iv = mpdu + hdrlen - 8;			// calc start of iv


    // prepare cbchdr for mic calculation
    A_MEM_ZERO(cbchdr, 48);
	cbchdr[2] = mpdu[0];			// copy frame control
	cbchdr[3] = mpdu[1];
	memcpy(&cbchdr[4], &mpdu[4], 18);	// copy addr[1,2,3]

   // include frag #, but zero out seq #
	cbchdr[22] = mpdu[22] & 0xf;
	cbchdr[23] = 0;

   // figure out cbc ctr hlen
	if ((mpdu[1]&0x3)==3) {			// check from_ds/to_ds bits
		hlen = 28;
		memcpy(&cbchdr[24], &mpdu[24], 6);	// copy addr4 to cbchdr
	} else
		hlen = 22;

	qospri = isqos = 0;			// adjust for qos
	if (mpdu[0]&0x80) {
		qospri = mpdu[hdrlen-10]&0xf;	// four bits
		isqos = 1;
		hlen += 2;
		cbchdr[hlen] = qospri;
		cbchdr[hlen+1] = 0;
	}

   // pad with null bytes
	cp = &cbchdr[hlen+2];			// last byte of hdr plus 2 additional for CBC-MIC
	r = (hlen+15) & ~15;			// hlen must not be zero, round to nearest 16
	//ASSERT(((hlen+15)&~15)==32);
	//r = 32;					// it's always 32 for 802.11 (not true)
	v = r-hlen;				// number of pad bytes needed to have multiple of 16

	switch(v) {				// pad with zero
	case 15: *cp++ = 0;
	case 14: *cp++ = 0;
	case 13: *cp++ = 0;
	case 12: *cp++ = 0;
	case 11: *cp++ = 0;
	case 10: *cp++ = 0;
	case 9: *cp++ = 0;
	case 8: *cp++ = 0;
	case 7: *cp++ = 0;
	case 6: *cp++ = 0;
	case 5: *cp++ = 0;
	case 4: *cp++ = 0;
	case 3: *cp++ = 0;
	case 2: *cp++ = 0;
	case 1: *cp++ = 0;
	case 0:
		;
	}


   // mute header fields
	cbchdr[0] = 0;				     // flags for cbc
	cbchdr[1] = (unsigned char)hlen; // hlen < 255 (len of muted hdr, not actual hdr)
	cbchdr[2] &= ~(B_4+B_5);		 // mute b4 and b5
	cbchdr[3] &= ~((1<<B_RETRY)|(1<<B_MOREDATA)|(1<<B_PWR));	// clear changeable bits
	cbchdr[3] |= (1<<B_WEP);		 // set WEP bit
	mpdu[1] |= (1<<B_WEP);			 // make sure it's also set in mpdu


	mpx("cbc flags\t", cbchdr, 2);
	mpx("muted hdr\n", &cbchdr[2], 32);

   // prepare a final padded data block if dlen is not a multiple of 16
	dr = (dlen+15) & ~15;			// round up dlen to nearest 16
	dv = dr - dlen;				// number of pad bytes needed
	if (dv) {
		rem = 16-dv;
		memcpy(local, &data[dlen&(~15)], rem);  // copy the useful part
		cp = &local[rem];
		switch(dv) {				// pad with zero
		case 15: *cp++ = 0;
		case 14: *cp++ = 0;
		case 13: *cp++ = 0;
		case 12: *cp++ = 0;
		case 11: *cp++ = 0;
		case 10: *cp++ = 0;
		case 9: *cp++ = 0;
		case 8: *cp++ = 0;
		case 7: *cp++ = 0;
		case 6: *cp++ = 0;
		case 5: *cp++ = 0;
		case 4: *cp++ = 0;
		case 3: *cp++ = 0;
		case 2: *cp++ = 0;
		case 1: *cp++ = 0;
		case 0:
			;
		}
	}

	//ccm_make_ctr(0x59, qos, &mpdu[10], (long long)0x060504030201, dlen, ctr);
	ctr[0] = 0x59;
	ctr[1] = qospri;
	ctr[2] = mpdu[10];
	ctr[3] = mpdu[11];
	ctr[4] = mpdu[12];
	ctr[5] = mpdu[13];
	ctr[6] = mpdu[14];
	ctr[7] = mpdu[15];
	iv[0] = ctr[13] = (unsigned char)(pk->keyIV);
	iv[1] = ctr[12] = (unsigned char)(pk->keyIV>>8);
	iv[2] = 0;					// resvd byte
	iv[3] |= 0x20;					// force ext IV bit
	iv[4] = ctr[11] = (unsigned char)(pk->extKeyIV);
	iv[5] = ctr[10] = (unsigned char)(pk->extKeyIV>>8);
	iv[6] = ctr[9]  = (unsigned char)(pk->extKeyIV>>16);
	iv[7] = ctr[8]  = (unsigned char)(pk->extKeyIV>>24);
	ctr[14] = dlen>>8;
	ctr[15] = (unsigned char)dlen;
	mpx("iv\t", iv, 8);
	mpx("cbc ctr\t", ctr, 16);
	rijndaelEncrypt(ccm->rk, 10, ctr, ct);
	//mpx("E(cbc)\t", ct, 16);


	for(n=0; n<r; n+=16) {			// mic the muted hdr
		mpx("cbc in\t", &cbchdr[n], 16);
		xor_block(&cbchdr[n], ct);
		//mpx("xor\t", &cbchdr[n], 16);
		rijndaelEncrypt(ccm->rk, 10, &cbchdr[n], ct);
		//mpx("cbc out\t ", ct, 16);
	}

	if (dv==0) {				// mic the data
		for(n=0; n<dr; n+=16) {
			mpx("D in\t", &data[n], 16);
			xor3_block(tmp, &data[n], ct);
			rijndaelEncrypt(ccm->rk, 10, tmp, ct);
			//mpx("E out\t", ct, 16);
		}
	} else {
		for(n=0; n<dr-16; n+=16) {
			mpx("D in\t", &data[n], 16);
			xor3_block(tmp, &data[n], ct);
			//mpx("xor\t", tmp, 16);
			rijndaelEncrypt(ccm->rk, 10, tmp, ct);
			//mpx("cbcout\t", ct, 16);
		}
		mpx("DL in\t", local, 16);
		xor_block(local, ct);
		rijndaelEncrypt(ccm->rk, 10, local, ct);
		//mpx("last block\n", ct, 16);
	}
	mpx("mic\t", ct, 16);

//ccm_ctr(rk, ctr, data, dlen)

	ctr[0] = 0x1;
	ctr[14] = 0;
	ctr[15] = 0;
	mpx("ctr preload\n", ctr, 16);
	rijndaelEncrypt(ccm->rk, 10, ctr, tmp);
	xor3_block(mic, ct, tmp);
	mpx("E(mic)\t", mic, 8);
	n = 1; cc = 0;
	if (dlen>=16)
	for ( ; cc<dlen-16; n++,cc+=16) {
		ctr[14] = (n>>8);
		ctr[15] = n&0xff;
		rijndaelEncrypt(ccm->rk, 10, ctr, tmp);
		xor_block(&data[cc], tmp);
		//mpx("ctrblk\t", &data[cc], 16);
	}
	if (cc<dlen) {
		r = dlen-cc;
		ctr[14] = (n>>8);
		ctr[15] = n&0xff;
		rijndaelEncrypt(ccm->rk, 10, ctr, tmp);
		memcpy(local, &data[cc], 16);
		xor_block(local, tmp);
		memcpy(&data[cc], local, r);
		//mpx("ctrblk\t", &data[cc], 16);
	}
	memcpy(&data[dlen], mic, 8);
	mpx("encrypted data\n", data, dlen);
	//mpx("final block\n", &data[cc], 16);

    return (A_OK);
}

/*
 * ccm decipher
 * mpdu is the frame
 * len excludes fcs, includes (hdr, IV, payload, mic)
 */
A_STATUS
ccm_decipher(pk, mpdu, len)
WLAN_PRIV_RECORD *pk;
unsigned char *mpdu;
int len;
{
struct ccm_private *ccm;
unsigned char *data, *iv;
unsigned char mic[16], rmic[16], ctr[16], tmp[16];
unsigned char  local[16], ct[16];
unsigned char cbchdr[48];
unsigned char qos =0;
int isqos = 0;
int chlen, hlen, dlen, cc, r, n;

	ASSERT(pk);

	ccm = (struct ccm_private *)pk->initValue;

	if (!ccm) return(A_ERROR);

#ifdef CCM_REKEY
// This not needed as long as ccm_init is called when rekeying
	// calc aes key schedule if key has changed
	if (memcmp(ccm->key, pk->keyVal, 16)) {
		memcpy(pk->keyVal, ccm->key, 16);
		r = rijndaelKeySetupEnc(ccm->rk, pk->keyVal, 128);
	}
#endif

	mpx("\ndecrypt input\n", mpdu, len);

	if ((mpdu[1]&0x3)==0x3) 		// first check fromDS toDS bits
		hlen = 30; else			// frame contains A4
		hlen = 24;			// is 3 address frame


	if (mpdu[0]&0x80) {
		qos = mpdu[hlen]&0xf;
		hlen += 2;
		isqos = 1;
	}

	iv = &mpdu[hlen];			// calc start of iv field

	hlen += 8;				// add in 8-byte IV field
	data = &mpdu[hlen];			// calc start of data payload

	dlen = len - (hlen+8);			// payload: subtract hdr and MIC


	memcpy(rmic, &mpdu[len-8], 8);		// copy out received mic

	mpx("\nreceived mic\t", rmic, 8);

	// make decrypt preload counter
	ctr[0] = 0x1;
	ctr[1] = qos;
	ctr[2] = mpdu[10];
	ctr[3] = mpdu[11];
	ctr[4] = mpdu[12];
	ctr[5] = mpdu[13];
	ctr[6] = mpdu[14];
	ctr[7] = mpdu[15];
	ctr[13] = iv[0];
	ctr[12] = iv[1];
	ctr[11] = iv[4];
	ctr[10] = iv[5];
	ctr[9] = iv[6];
	ctr[8] = iv[7];
	ctr[14] = 0;
	ctr[15] = 0;

	mpx("ctr preload\n", ctr, 16);

	rijndaelEncrypt(ccm->rk, 10, ctr, tmp);
	xor3_block(mic, rmic, tmp);
	mpx("E(mic)\n", mic, 8);

	// decrypt the frame
	n = 1; cc = 0;
	if (dlen>=16)
	for (  ; cc<dlen-16; n++,cc+=16) {
		ctr[14] = (n>>8);
		ctr[15] = (unsigned char)n;
		rijndaelEncrypt(ccm->rk, 10, ctr, tmp);
		xor_block(&data[cc], tmp);
		//mpx("dec block", &data[cc], 16);
	}
	if (cc<dlen) {
		r = dlen-cc;
		ctr[14] = (n>>8);
		ctr[15] = n&0xff;
		rijndaelEncrypt(ccm->rk, 10, ctr, tmp);
		memcpy(local, &data[cc], 16);
		xor_block(local, tmp);
		memcpy(&data[cc], local, r);
		//mpx("dec block", &data[cc], 16);
	}
	memcpy(&data[dlen], mic, 8);			// save the decrypted mic

	mpx("decrypted payload\n", data, dlen);

	// now calculate the mic
	ctr[0] = 0x59;
	ctr[14] = dlen>>8;
	ctr[15] = (unsigned char)dlen;


	A_MEM_ZERO(cbchdr, 48);

	cbchdr[22] = mpdu[22] & 0xf;		// zero out seq#
	cbchdr[23] = 0;

	if ((mpdu[1]&0x3)==3) {				// copy addr4 if present
		chlen = 28;
		memcpy(&cbchdr[24], &mpdu[24], 6);
	} else {
		chlen = 22;
	}
	if (isqos) {
		chlen += 2;
		cbchdr[chlen] = qos;
		cbchdr[chlen+1] = 0;
	}
	cbchdr[0] = 0;
	cbchdr[1] = (unsigned char)chlen;
	cbchdr[2] = mpdu[0];				// copy frame control byte 0
	cbchdr[2] &= ~(B_4+B_5);			// mute b4 and b5
	cbchdr[3] = mpdu[1];				// copy frame control byte 1
	cbchdr[3] &= ~((1<<B_RETRY)|(1<<B_MOREDATA)|(1<<B_PWR));	// clear mutable bits
	memcpy(&cbchdr[4], &mpdu[4], 18);		// copy addr[1,2,3]

	mpx("cbc ctr\t", ctr, 16);
	rijndaelEncrypt(ccm->rk, 10, ctr, ct);

	for(n=0; n<32; n+=16) {
		mpx("cbc in\t", &cbchdr[n], 16);
		xor_block(&cbchdr[n], ct);
		//mpx("xor", &cbchdr[n], 16);
		rijndaelEncrypt(ccm->rk, 10, &cbchdr[n], ct);
		//mpx("cbc output", ct, 16);
	}

	n = 0;
	if (dlen>=16)		// XXX
	for(n=0; n<dlen-16; n+=16) {
		mpx("D in\t", &data[n], 16);
		xor3_block(tmp, &data[n], ct);
		rijndaelEncrypt(ccm->rk, 10, tmp, ct);
	}
	r = dlen - n;					// remaining data bytes
	if (r) {
		A_MEM_ZERO(local, 16);
		memcpy(local, &data[n], r);
		mpx("DL in\t", local, 16);
		xor3_block(tmp, local, ct);
		rijndaelEncrypt(ccm->rk, 10, tmp, ct);
	}
	mpx("calculated mic\t", ct, 8);
	mpx("decrypted mic\t", mic, 8);
	if (cmp_mic_err(ct, mic)==0) {
		return(A_OK);
	} else {
		return(A_ERROR);
	}
}


#ifdef EVA

eva_ccm_encipher(key, mpdu, len)
unsigned char *key, *mpdu;
int len;
{
struct ccm_private keystate;
WLAN_PRIV_RECORD pk;
int hlen, dlen;
unsigned char *datap;

    bzero(&pk, sizeof(pk));
    memcpy(&pk.keyVal, key, 16);
    pk.initValue = &keystate;
    ccm_init(&pk);

    if ((mpdu[0]&0x3)==0x3)	// check for 4-address format
	hlen = 30; else
	hlen = 24;
    if (mpdu[0]&0x80) {		// check for qos
	hlen += 2;
    }

    ccm_get_replay(&pk, mpdu+hlen);	// make encipher think pn is in pk

    hlen += 8;			// add on icv
    datap = mpdu+hlen;
    dlen = len - hlen;

    ccm_encipher(&pk, mpdu, hlen, datap, dlen);
}

eva_ccm_decipher(key, mpdu, len)
unsigned char *key, *mpdu;
int len;
{
struct ccm_private keystate;
WLAN_PRIV_RECORD pk;

    bzero(&pk, sizeof(pk));
    memcpy(&pk.keyVal, key, 16);
    pk.initValue = &keystate;
    ccm_init(&pk);

    ccm_decipher(&pk, mpdu, len);
}
#endif
