/*
 * Michael
 * 	implemented in C from the spec 
 *	with cribs from the C++ reference code
 * 	tested on big-endian and little-endian
 *
 * Copyright Atheros 2002
 */

__inline unsigned long
rol17(unsigned long w) 			// rotate left 17
{
register unsigned long t, q;
	t = w << 17;
	q = (w >> 15);
	return(t|q);
}

__inline unsigned long
rol3(unsigned long w) 			// rotate left 3
{
register unsigned long t, q;
	t = w << 3;
	q = (w >> 29);
	return(t|q);
}


__inline unsigned long
ror2(unsigned long w) 			// rotate right 2
{
register unsigned long t, q;
	t = (w >> 2);
	q = w << 30;
	return(t|q);
}

#define	MBLOCK(L, R)						\
	R = R ^ rol17(L);					\
	L += R;							\
	R ^= ((L & 0xff00ff00)>>8)|((L & 0x00ff00ff) << 8);	\
	L += R;							\
	R ^= rol3(L);						\
	L += R;							\
	R ^= ror2(L);						\
	L += R;							

__inline static unsigned long
getw(unsigned char *cp)
{
register unsigned long t;

	t = 0;
	t = *cp++;
	t |= (*cp++)<<8;
	t |= (*cp++)<<16;
	t |= (*cp++)<<24;
	return(t);
}

__inline void
putw(unsigned long w, unsigned char *cp)
{

	*cp++ = (unsigned char)w;	// MS compiler forces use of 0xff
	*cp++ = (unsigned char)(w>>8);
	*cp++ = (unsigned char)(w>>16);
	*cp++ = (unsigned char)(w>>24);
	return;
}


// Michael integrity function
// pads the buffer (s) with up to 7 bytes
// if h is non-null, it is prepended to the buffer.
// The function appends an additional 8 bytes of Michael 
// returns buffer len (payload+Michael)
//
int
omichael(unsigned char *key, char *s, int dlen, char *h, int hlen) 
{
register unsigned long M;
unsigned long L, R;
int len = dlen;
register unsigned char *sp, *cp;

	L = getw(key);		// L = *LL; R = *RR;
	R = getw(key+4);

	sp = s;
	sp[len++] = 0x5a;			// message padding
	sp[len++] = 0;				// 4 required
	sp[len++] = 0;
	sp[len++] = 0;
	sp[len++] = 0;
	while (len&0x3) {			// word aligned
		sp[len++] = 0;
	}

	sp = h;
	while (hlen > 0) {			// mic the header if present
		M = getw(sp);
		sp+=4; hlen -= 4;
		L ^= M;
		MBLOCK(L, R);
	}

	sp = s;
	while (len > 0) {
		M = getw(sp); 			// M = *mp++; len -= 4;
		sp+=4; len -= 4;
	
		L ^= M;				// Michael block function
		MBLOCK(L, R);
	}

#ifdef TKIPSELFTEST
	putw(L, key); 		// *LL = L; *RR = R;
	putw(R, key+4);
#endif

	cp = s+dlen;
	putw(L, (unsigned char *)cp); 
	cp = s+dlen+4;
	putw(R, (unsigned char *)cp); 
	return(len+8);
}


int
michael(unsigned char *key, char *s, int dlen, char *h, int hlen, char *qos) 
{
register unsigned long M;
unsigned long L, R;
int len = dlen;
register unsigned char *sp, *cp;

	L = getw(key);		                // L = *LL; R = *RR;
	R = getw(key+4);

	sp = s;
	sp[len++] = 0x5a;			// message padding
	sp[len++] = 0;				// 4 required
	sp[len++] = 0;
	sp[len++] = 0;
	sp[len++] = 0;
	while (len&0x3) {			// word aligned
		sp[len++] = 0;
	}

	sp = h;
	while (hlen > 0) {			// mic the header if present
		M = getw(sp);
		sp+=4; hlen -= 4;
		L ^= M;
		MBLOCK(L, R);
	}

        if (qos) {
            M = getw(qos);                      // mic zbuf or optional qos
            L ^= M;
            MBLOCK(L, R);
        }

	sp = s;                                 // mic data payload
	while (len > 0) {
		M = getw(sp); 			// M = *mp++; len -= 4;
		sp+=4; len -= 4;
	
		L ^= M;				// Michael block function
		MBLOCK(L, R);
	}

#ifdef TKIPSELFTEST
	putw(L, key); 		// *LL = L; *RR = R;
	putw(R, key+4);
#endif

	cp = s+dlen;
	putw(L, (unsigned char *)cp); 
	cp = s+dlen+4;
	putw(R, (unsigned char *)cp); 
	return(len+8);
}

#ifdef TKIPSELFTEST
void
pw(unsigned long *wp)
{
unsigned char *cp;

	cp = (unsigned char *)wp;
	printf("%x ", *cp++);
	printf("%x ", *cp++);
	printf("%x ", *cp++);
	printf("%x ", *cp++);
}

char *messages[] = {"", "M", "Mi", "Mic", "Mich", "Michael", 0};
char buf[2048];


main()
{
int i, len, cc;
unsigned long L, R;
unsigned char key[8];

	L = R = 0;
	bzero(key, sizeof(key));
	for(i=0; messages[i]; i++) {
		len = strlen(messages[i]);
		strncpy(buf, messages[i], sizeof(buf)-16);
		cc = omichael(key, buf, len, 0, 0);
		printf("%2d,%d %s\n", len, cc, messages[i]);
		pw((unsigned long *)key); 
		pw((unsigned long *)&key[4]); 
		printf("\n");
	}
	pw((unsigned long *)key); 
	pw((unsigned long *)&key[4]); 
	printf("\n");


	L = R = 0;
	bzero(key, sizeof(key));
	bzero(buf, 32);
	for(i=0; messages[i]; i++) {
		len = strlen(messages[i]);
		strncpy(buf, messages[i], sizeof(buf)-16);
		cc = omichael(key, buf, len, 0, 0);
		printf("%2d,%d %s\n", len, cc, messages[i]);
		pw((unsigned long *)key); 
		pw((unsigned long *)&key[4]); 
		printf("\n");
	}
	pw((unsigned long *)key); 
	pw((unsigned long *)&key[4]); 
	printf("\n");


}
#endif
