/* Copyright (c) $Date: 2004/11/15 $
 * Intermec Technologies Corporation, Cedar Rapids, Iowa, U.S.A.
 * ALL RIGHTS RESERVED
 *
 * This document contains confidential information and is proprietary to
 * Intermec TechnologiesCorporation.  It is being supplied to you with the
 * express understanding that the information contained therein be held in
 * confidence by you.  This document is not to be copied, distributed, or
 * displayed to third parties without the express written consent of Intermec
 * Technologies Corporation, and shall be returned to Norand upon written
 * request.
 *
 *$Log: wep.c,v $
 *Revision 1.1.1.1  2004/09/28 18:51:18  alagusankar
 *Initial Windows Release 1.0
 *
*
*    Rev 1.9   07 Aug 2000 13:16:06   spiess
* Major workover so this code is endian independent.
*
*    Rev 1.8   19 Mar 1999 15:08:20   spiess
* Convert to bigendian.  Used as a model for wep.asm.
*
*    Rev 1.7   15 Mar 1999 16:40:04   spiess
* remove TOOBIG conditional.
*
*    Rev 1.6   27 Aug 1998 13:20:28   spiess
* Conditional in case executable is too big.
*
*    Rev 1.5   29 May 1998 16:01:20   spiess
* lint.
*
*    Rev 1.4   03 Feb 1998 10:14:28   spiess
* lint.
*
*    Rev 1.3   23 Jan 1998 15:19:28   spiess
* Copyright.
 */

/* #define SELFTEST */

#ifdef SELFTEST
#include <stdio.h>
#endif

//#include "snooploc.h"
// #include "crypto/ocb.h"
#include "wlandrv.h"
#include "wlanext.h"
void bzero();

/* compiler help for endianess */
#ifdef notdef
 #if defined(_AIX)
 #include <sys/machine.h>
 #elif defined(__GNUC__)
 #include <endian.h>
 #endif

 /* define endianess here, if couldn't find help */
 #ifndef BYTE_ORDER
 #define LITTLE_ENDIAN   1234
 #define BIG_ENDIAN      4321
 #define BYTE_ORDER      LITTLE_ENDIAN
 #endif
#endif

/*
 * Set BYTE_ORDER using Atheros Makefile conventions
 * note: this will break for Linux running on Big Endian hardware
 * or SunOS running on Little Endian hardware, or Mips in little-endian
 * mode.
 */
#undef LITTLE_ENDIAN
#undef BIG_ENDIAN
#define LITTLE_ENDIAN   1234
#define	BIG_ENDIAN	4321

#ifndef BYTE_ORDER
 #ifdef Linux
 #define BYTE_ORDER	LITTLE_ENDIAN
 #endif
 #ifdef SunOS
 #define BYTE_ORDER	BIG_ENDIAN
 #endif
 #ifdef MIPS
 #define BYTE_ORDER	BIG_ENDIAN
 #endif
 #ifdef VXWORKS
 #define BYTE_ORDER	BIG_ENDIAN
 #endif
#endif
#if 0
#if defined(_lint)
#define INLINE
#ifdef SELFTEST
#define CDECL
#endif
#elif defined(__GNUC__)
#define INLINE __inline
#define CDECL
#elif defined(_M_I86)
#define INLINE __inline
#define CDECL __cdecl
#elif defined(M_I86)
#define INLINE _inline
#define CDECL _cdecl
#else
#define INLINE
#define CDECL
#endif
#endif


    static unsigned long Crc32Tab1[256];
    static unsigned long Crc32Tab2[256];
    static unsigned long Crc32Tab3[256];


    static unsigned long Crc32Tab4[] = {
        0x00000000UL, 0x77073096UL, 0xee0e612cUL, 0x990951baUL, 0x076dc419UL,
        0x706af48fUL, 0xe963a535UL, 0x9e6495a3UL, 0x0edb8832UL, 0x79dcb8a4UL,
        0xe0d5e91eUL, 0x97d2d988UL, 0x09b64c2bUL, 0x7eb17cbdUL, 0xe7b82d07UL,
        0x90bf1d91UL, 0x1db71064UL, 0x6ab020f2UL, 0xf3b97148UL, 0x84be41deUL,
        0x1adad47dUL, 0x6ddde4ebUL, 0xf4d4b551UL, 0x83d385c7UL, 0x136c9856UL,
        0x646ba8c0UL, 0xfd62f97aUL, 0x8a65c9ecUL, 0x14015c4fUL, 0x63066cd9UL,
        0xfa0f3d63UL, 0x8d080df5UL, 0x3b6e20c8UL, 0x4c69105eUL, 0xd56041e4UL,
        0xa2677172UL, 0x3c03e4d1UL, 0x4b04d447UL, 0xd20d85fdUL, 0xa50ab56bUL,
        0x35b5a8faUL, 0x42b2986cUL, 0xdbbbc9d6UL, 0xacbcf940UL, 0x32d86ce3UL,
        0x45df5c75UL, 0xdcd60dcfUL, 0xabd13d59UL, 0x26d930acUL, 0x51de003aUL,
        0xc8d75180UL, 0xbfd06116UL, 0x21b4f4b5UL, 0x56b3c423UL, 0xcfba9599UL,
        0xb8bda50fUL, 0x2802b89eUL, 0x5f058808UL, 0xc60cd9b2UL, 0xb10be924UL,
        0x2f6f7c87UL, 0x58684c11UL, 0xc1611dabUL, 0xb6662d3dUL, 0x76dc4190UL,
        0x01db7106UL, 0x98d220bcUL, 0xefd5102aUL, 0x71b18589UL, 0x06b6b51fUL,
        0x9fbfe4a5UL, 0xe8b8d433UL, 0x7807c9a2UL, 0x0f00f934UL, 0x9609a88eUL,
        0xe10e9818UL, 0x7f6a0dbbUL, 0x086d3d2dUL, 0x91646c97UL, 0xe6635c01UL,
        0x6b6b51f4UL, 0x1c6c6162UL, 0x856530d8UL, 0xf262004eUL, 0x6c0695edUL,
        0x1b01a57bUL, 0x8208f4c1UL, 0xf50fc457UL, 0x65b0d9c6UL, 0x12b7e950UL,
        0x8bbeb8eaUL, 0xfcb9887cUL, 0x62dd1ddfUL, 0x15da2d49UL, 0x8cd37cf3UL,
        0xfbd44c65UL, 0x4db26158UL, 0x3ab551ceUL, 0xa3bc0074UL, 0xd4bb30e2UL,
        0x4adfa541UL, 0x3dd895d7UL, 0xa4d1c46dUL, 0xd3d6f4fbUL, 0x4369e96aUL,
        0x346ed9fcUL, 0xad678846UL, 0xda60b8d0UL, 0x44042d73UL, 0x33031de5UL,
        0xaa0a4c5fUL, 0xdd0d7cc9UL, 0x5005713cUL, 0x270241aaUL, 0xbe0b1010UL,
        0xc90c2086UL, 0x5768b525UL, 0x206f85b3UL, 0xb966d409UL, 0xce61e49fUL,
        0x5edef90eUL, 0x29d9c998UL, 0xb0d09822UL, 0xc7d7a8b4UL, 0x59b33d17UL,
        0x2eb40d81UL, 0xb7bd5c3bUL, 0xc0ba6cadUL, 0xedb88320UL, 0x9abfb3b6UL,
        0x03b6e20cUL, 0x74b1d29aUL, 0xead54739UL, 0x9dd277afUL, 0x04db2615UL,
        0x73dc1683UL, 0xe3630b12UL, 0x94643b84UL, 0x0d6d6a3eUL, 0x7a6a5aa8UL,
        0xe40ecf0bUL, 0x9309ff9dUL, 0x0a00ae27UL, 0x7d079eb1UL, 0xf00f9344UL,
        0x8708a3d2UL, 0x1e01f268UL, 0x6906c2feUL, 0xf762575dUL, 0x806567cbUL,
        0x196c3671UL, 0x6e6b06e7UL, 0xfed41b76UL, 0x89d32be0UL, 0x10da7a5aUL,
        0x67dd4accUL, 0xf9b9df6fUL, 0x8ebeeff9UL, 0x17b7be43UL, 0x60b08ed5UL,
        0xd6d6a3e8UL, 0xa1d1937eUL, 0x38d8c2c4UL, 0x4fdff252UL, 0xd1bb67f1UL,
        0xa6bc5767UL, 0x3fb506ddUL, 0x48b2364bUL, 0xd80d2bdaUL, 0xaf0a1b4cUL,
        0x36034af6UL, 0x41047a60UL, 0xdf60efc3UL, 0xa867df55UL, 0x316e8eefUL,
        0x4669be79UL, 0xcb61b38cUL, 0xbc66831aUL, 0x256fd2a0UL, 0x5268e236UL,
        0xcc0c7795UL, 0xbb0b4703UL, 0x220216b9UL, 0x5505262fUL, 0xc5ba3bbeUL,
        0xb2bd0b28UL, 0x2bb45a92UL, 0x5cb36a04UL, 0xc2d7ffa7UL, 0xb5d0cf31UL,
        0x2cd99e8bUL, 0x5bdeae1dUL, 0x9b64c2b0UL, 0xec63f226UL, 0x756aa39cUL,
        0x026d930aUL, 0x9c0906a9UL, 0xeb0e363fUL, 0x72076785UL, 0x05005713UL,
        0x95bf4a82UL, 0xe2b87a14UL, 0x7bb12baeUL, 0x0cb61b38UL, 0x92d28e9bUL,
        0xe5d5be0dUL, 0x7cdcefb7UL, 0x0bdbdf21UL, 0x86d3d2d4UL, 0xf1d4e242UL,
        0x68ddb3f8UL, 0x1fda836eUL, 0x81be16cdUL, 0xf6b9265bUL, 0x6fb077e1UL,
        0x18b74777UL, 0x88085ae6UL, 0xff0f6a70UL, 0x66063bcaUL, 0x11010b5cUL,
        0x8f659effUL, 0xf862ae69UL, 0x616bffd3UL, 0x166ccf45UL, 0xa00ae278UL,
        0xd70dd2eeUL, 0x4e048354UL, 0x3903b3c2UL, 0xa7672661UL, 0xd06016f7UL,
        0x4969474dUL, 0x3e6e77dbUL, 0xaed16a4aUL, 0xd9d65adcUL, 0x40df0b66UL,
        0x37d83bf0UL, 0xa9bcae53UL, 0xdebb9ec5UL, 0x47b2cf7fUL, 0x30b5ffe9UL,
        0xbdbdf21cUL, 0xcabac28aUL, 0x53b39330UL, 0x24b4a3a6UL, 0xbad03605UL,
        0xcdd70693UL, 0x54de5729UL, 0x23d967bfUL, 0xb3667a2eUL, 0xc4614ab8UL,
        0x5d681b02UL, 0x2a6f2b94UL, 0xb40bbe37UL, 0xc30c8ea1UL, 0x5a05df1bUL,
        0x2d02ef8dUL
    };

#define CRC32SEED 0xffffffff
unsigned long CRC32OKAY;

#if BYTE_ORDER == BIG_ENDIAN
#define BYTE0GET(v) ((unsigned char)((v) >> 24))
#define BYTE1GET(v) ((unsigned char)((v) >> 16))
#define BYTE2GET(v) ((unsigned char)((v) >> 8))
#define BYTE3GET(v) ((unsigned char)(v))
#define BYTE0SET(v) ((unsigned long)(unsigned char)(v) << 24)
#define BYTE1SET(v) ((unsigned long)(unsigned char)(v) << 16)
#define BYTE2SET(v) ((unsigned long)(unsigned char)(v) << 8)
#define BYTE3SET(v) ((unsigned char)(v))
#define ROLL(v) (((v) << 8) | ((v) >> 24))
#else
#define BYTE3GET(v) ((unsigned char)((v) >> 24))
#define BYTE2GET(v) ((unsigned char)((v) >> 16))
#define BYTE1GET(v) ((unsigned char)((v) >> 8))
#define BYTE0GET(v) ((unsigned char)(v))
#define BYTE3SET(v) ((unsigned long)(unsigned char)(v) << 24)
#define BYTE2SET(v) ((unsigned long)(unsigned char)(v) << 16)
#define BYTE1SET(v) ((unsigned long)(unsigned char)(v) << 8)
#define BYTE0SET(v) ((unsigned char)(v))
#define ROLL(v) (((v) >> 8) | ((v) << 24))
#endif

INLINE static unsigned long
Crc32Byte(unsigned char c, unsigned long Crc) {
    #if BYTE_ORDER == BIG_ENDIAN
    Crc  = ROLL(Crc);
    Crc ^= c;
    return Crc ^ Crc32Tab4[(unsigned char)Crc];
    #else
    Crc ^= c;
    c = (unsigned char)Crc;
    Crc  = ROLL(Crc);
    return Crc ^ Crc32Tab4[c];
    #endif
}

INLINE static unsigned long Crc32Long(unsigned long c, unsigned long Crc) {
    Crc ^= c;
    Crc ^= Crc32Tab1[BYTE0GET(Crc)];
    Crc ^= Crc32Tab2[BYTE1GET(Crc)];
    Crc ^= Crc32Tab3[BYTE2GET(Crc)];
    return Crc ^ Crc32Tab4[BYTE3GET(Crc)];
}

unsigned long
Crc32Buf(unsigned char *buf, unsigned short len) {
    unsigned long Crc = CRC32SEED;

    for (; len && ((unsigned long)buf & 3); len--)
        Crc = Crc32Byte(*buf++, Crc);

    for (; len >= 4; buf += 4, len -= 4)
        Crc = Crc32Long(*(unsigned long*)buf, Crc);

    while (len--)
        Crc = Crc32Byte(*buf++, Crc);

    return Crc;
}



void Crc32Init(void) {
    unsigned short i;
    static int BeenHere = 0;

    if (BeenHere)
        return;
    BeenHere = 1;

    for (i = 256; i--; ) {
        Crc32Tab1[i] =
		BYTE1SET((unsigned char)Crc32Tab4[i]) |
		BYTE2SET((unsigned char)(Crc32Tab4[i] >> 8)) |
		BYTE3SET((unsigned char)(Crc32Tab4[i] >> 16)) |
		BYTE0SET((unsigned char)((Crc32Tab4[i] >> 24) ^ i));
        Crc32Tab2[i] =
		BYTE2SET((unsigned char)Crc32Tab4[i]) |
		BYTE3SET((unsigned char)(Crc32Tab4[i] >> 8)) |
		BYTE0SET((unsigned char)(Crc32Tab4[i] >> 16)) |
		BYTE1SET((unsigned char)((Crc32Tab4[i] >> 24) ^ i));
        Crc32Tab3[i] =
		BYTE3SET((unsigned char)Crc32Tab4[i]) |
		BYTE0SET((unsigned char)(Crc32Tab4[i] >> 8)) |
		BYTE1SET((unsigned char)(Crc32Tab4[i] >> 16)) |
		BYTE2SET((unsigned char)((Crc32Tab4[i] >> 24) ^ i));
        Crc32Tab4[i] =
		BYTE0SET((unsigned char)Crc32Tab4[i]) |
		BYTE1SET((unsigned char)(Crc32Tab4[i] >> 8)) |
		BYTE2SET((unsigned char)(Crc32Tab4[i] >> 16)) |
		BYTE3SET((unsigned char)((Crc32Tab4[i] >> 24) ^ i));
    }
    CRC32OKAY = Crc32Long(~CRC32SEED, CRC32SEED);

#ifdef aardvark
    io_printf("CRC32OKAY is 0x%8.8lxUL\n", CRC32OKAY);
    io_printf("\nTab1\n");
    for (i = 0; i <= 256-4; i += 4)
        io_printf(
            "0x%8.8lxUL, 0x%8.8lxUL, 0x%8.8lxUL, 0x%8.8lxUL,\n",
            Crc32Tab1[i],
            Crc32Tab1[i+1],
            Crc32Tab1[i+2],
            Crc32Tab1[i+3]
        );
    io_printf("\nTab2\n");
    for (i = 0; i <= 256-4; i += 4)
        io_printf(
            "0x%8.8lxUL, 0x%8.8lxUL, 0x%8.8lxUL, 0x%8.8lxUL,\n",
            Crc32Tab2[i],
            Crc32Tab2[i+1],
            Crc32Tab2[i+2],
            Crc32Tab2[i+3]
        );
    io_printf("\nTab3\n");
    for (i = 0; i <= 256-4; i += 4)
        io_printf(
            "0x%8.8lxUL, 0x%8.8lxUL, 0x%8.8lxUL, 0x%8.8lxUL,\n",
            Crc32Tab3[i],
            Crc32Tab3[i+1],
            Crc32Tab3[i+2],
            Crc32Tab3[i+3]
        );
    io_printf("\nTab4\n");
    for (i = 0; i <= 256-4; i += 4)
        io_printf(
            "0x%8.8lxUL, 0x%8.8lxUL, 0x%8.8lxUL, 0x%8.8lxUL,\n",
            Crc32Tab4[i],
            Crc32Tab4[i+1],
            Crc32Tab4[i+2],
            Crc32Tab4[i+3]
        );
#endif
}

static unsigned char xstate[256];

/* defining the adder value here makes the code generator use registers
 * instead of immediate values
 */
    static unsigned long adder = (sizeof(unsigned long)*0x01010101);

/* defining the initial value here makes the code endian independent */
    static unsigned char val1[4] = { 0xfc, 0xfd, 0xfe, 0xff };

/* the storage for the RC4 state information */
    static unsigned char i, j;

INLINE static void
RC4KByte(unsigned char *state, unsigned char c) {
    unsigned char k, x;

    j += c;
    k=state[i];
    j+=k;
    x=state[j];

    state[i]=x;
    state[j]=k;
    ++i;
}

/*
 * This uses a 128bit or 16byte key
 */
static unsigned char *
RC4Prepare(unsigned char *key) {
    unsigned long *p = (void*)xstate, t1 = *(unsigned long*)val1;

    i = 256/sizeof(unsigned long);
    p += i;

    do {
	*--p = t1; t1 -= adder;
    } while (--i);

    /* apply the key to the array */
    j = i;
    do {
        RC4KByte((unsigned char*)p, key[0]);
        RC4KByte((unsigned char*)p, key[1]);
        RC4KByte((unsigned char*)p, key[2]);
        RC4KByte((unsigned char*)p, key[3]);
        RC4KByte((unsigned char*)p, key[4]);
        RC4KByte((unsigned char*)p, key[5]);
        RC4KByte((unsigned char*)p, key[6]);
        RC4KByte((unsigned char*)p, key[7]);
        RC4KByte((unsigned char*)p, key[8]);
        RC4KByte((unsigned char*)p, key[9]);
        RC4KByte((unsigned char*)p, key[10]);
        RC4KByte((unsigned char*)p, key[11]);
        RC4KByte((unsigned char*)p, key[12]);
        RC4KByte((unsigned char*)p, key[13]);
        RC4KByte((unsigned char*)p, key[14]);
        RC4KByte((unsigned char*)p, key[15]);
    } while (i);
    j = i;
    return (unsigned char*)p;
}


/*
 * This uses a 152bit or 19byte key
 */
static unsigned char *
RC4Prepare128(unsigned char *key)
{
unsigned long *p = (void*)xstate, t1 = *(unsigned long*)val1;
int kx;

    i = 256/sizeof(unsigned long);
    p += i;

    do {
	*--p = t1; t1 -= adder;
    } while (--i);

    /* apply the key to the array */
    j = i;
    kx = 0;
    do {
        RC4KByte((unsigned char*)p, key[kx]);
	kx++;
	if (kx==19) kx = 0;
    } while (i);
    j = i;
    return (unsigned char*)p;
}

INLINE static unsigned char RC4Byte(unsigned char *state) {
    unsigned char k, x;

    ++i;
    k = state[i];
    j += k;
    x = state[j];

    state[i] = x;
    state[j] = k;
    x += k;
    return state[x];
}

INLINE static unsigned long RC4Long(unsigned char *state) {
    return
	BYTE0SET(RC4Byte(state)) |
    	BYTE1SET(RC4Byte(state)) |
    	BYTE2SET(RC4Byte(state)) |
    	BYTE3SET(RC4Byte(state));
}

int WepDecipher(unsigned char *key, unsigned char *buf, unsigned short len) {
    unsigned char c;
    unsigned long y;
    unsigned long Crc = CRC32SEED;
    unsigned char *state = RC4Prepare(key);

    for (; len && ((unsigned long)buf & 3); len--) {
        c = (unsigned char)(RC4Byte(state) ^ *buf);
        *buf++ = c;
        Crc = Crc32Byte(c, Crc);
    }
    for (; len > 4; buf += 4, len -= 4) {
        y = RC4Long(state) ^ *(unsigned long*)buf;
        *(unsigned long*)buf = y;
        Crc = Crc32Long(y, Crc);
    }
    while (len--) {
        c = (unsigned char)(RC4Byte(state) ^ *buf);
        *buf++ = c;
        Crc = Crc32Byte(c, Crc);
    }
    return (Crc == CRC32OKAY);
}

void
WepEncipher(unsigned char *key, unsigned char *buf, unsigned short len) {
    unsigned char c;
    unsigned long y;
    unsigned long Crc = CRC32SEED;
    unsigned char *state = RC4Prepare(key);

#ifdef _DEBUG_
    {
      int i;
      io_printf("WepEncipher: key=");
      for (i=0;i<16;i++) {
	io_printf("%02X ",(unsigned int)key[i]);
      }
      io_printf("\n");
    }
#endif

    for (; len && ((unsigned long)buf & 3); len--) {
        c = *buf;
        Crc = Crc32Byte(c, Crc);
        *buf++ = (unsigned char)(c ^ RC4Byte(state));
    }

    for (; len >= 4; buf += 4, len -= 4) {
        y = *(unsigned long*)buf;
        Crc = Crc32Long(y, Crc);
        *(unsigned long*)buf = (unsigned long)(y ^ RC4Long(state));
    }

    while (len--) {
        c = *buf;
        Crc = Crc32Byte(c, Crc);
        *buf++ = (unsigned char)(c ^ RC4Byte(state));
    }

    Crc = RC4Long(state) ^ ~Crc;

    *buf++ = BYTE0GET(Crc);
    *buf++ = BYTE1GET(Crc);
    *buf++ = BYTE2GET(Crc);
    *buf   = BYTE3GET(Crc);
}


int
WepDecipher128(unsigned char *key, unsigned char *buf, unsigned short len) {
    unsigned char c;
    unsigned long y;
    unsigned long Crc = CRC32SEED;
    unsigned char *state = RC4Prepare128(key);

#ifdef _DEBUG_
    {
      int i;
      io_printf("WepEncipher128: key=");
      for (i=0;i<16;i++) {
	io_printf("%02X ",(unsigned int)key[i]);
      }
      io_printf("\n");
    }
#endif

    for (; len && ((unsigned long)buf & 3); len--) {
        c = (unsigned char)(RC4Byte(state) ^ *buf);
        *buf++ = c;
        Crc = Crc32Byte(c, Crc);
    }
    for (; len > 4; buf += 4, len -= 4) {
        y = RC4Long(state) ^ *(unsigned long*)buf;
        *(unsigned long*)buf = y;
        Crc = Crc32Long(y, Crc);
    }
    while (len--) {
        c = (unsigned char)(RC4Byte(state) ^ *buf);
        *buf++ = c;
        Crc = Crc32Byte(c, Crc);
    }
    return (Crc == CRC32OKAY);
}

void
WepEncipher128(unsigned char *key, unsigned char *buf, unsigned short len) {
    unsigned char c;
    unsigned long y;
    unsigned long Crc = CRC32SEED;
    unsigned char *state = RC4Prepare128(key);


    for (; len && ((unsigned long)buf & 3); len--) {
        c = *buf;
        Crc = Crc32Byte(c, Crc);
        *buf++ = (unsigned char)(c ^ RC4Byte(state));
    }

    for (; len >= 4; buf += 4, len -= 4) {
        y = *(unsigned long*)buf;
        Crc = Crc32Long(y, Crc);
        *(unsigned long*)buf = (unsigned long)(y ^ RC4Long(state));
    }

    while (len--) {
        c = *buf;
        Crc = Crc32Byte(c, Crc);
        *buf++ = (unsigned char)(c ^ RC4Byte(state));
    }

    Crc = RC4Long(state) ^ ~Crc;

    *buf++ = BYTE0GET(Crc);
    *buf++ = BYTE1GET(Crc);
    *buf++ = BYTE2GET(Crc);
    *buf   = BYTE3GET(Crc);
}

#if 0
int
Crc32InitCheck(void)
{
	io_printf("CRC32 check\n");
#ifdef BIG_ENDIAN
	io_printf("BIG_ENDIAN %d\n", BIG_ENDIAN);
#endif
#ifdef LITTLE_ENDIAN
	io_printf("LITTLE_ENDIAN %d\n", LITTLE_ENDIAN);
#endif
#ifdef BYTE_ORDER
	io_printf("BYTE_ORDER is %d\n", BYTE_ORDER);
#endif
	io_printf("CRC Remainder %lx\n", CRC32OKAY);
	return(BYTE_ORDER);
}

#endif
#ifdef SELFTEST
#include <stdio.h>

void fpbuf(FILE* F, unsigned char* s, int cc)
{
	int c, x;

	x = 0;
	while (cc--) {
		c = *s++;
		fprintf(F, "%02x ", c);
		x++;
		if ((x&7)==0)
			fprintf(F, "\n");
	}
	fprintf(F, "\n");
}

void fmpbuf(FILE* F, char* m, char* s, int cc)
{
	fprintf(F, "%s", m);
	fpbuf(F, s, cc);
}

unsigned char testbuf[] ={
0x04, 0xef, 0x00, 0x00,				// IV
0xaa, 0xaa, 0x03, 0x00, 0x00, 0xf8, 0x08, 0x00, // data
0x45, 0x00, 0x00, 0x80, 0x27, 0xdd, 0x00, 0x00,
0xff, 0x01, 0x6f, 0xf0, 0xc0, 0xa8, 0x51, 0x2c,
0xc0, 0xa8, 0x51, 0x32, 0x00, 0x00, 0x5c, 0xeb,
0x02, 0x00, 0x94, 0x03, 0x61, 0x62, 0x63, 0x64,
0x65, 0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c,
0x6d, 0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74,
0x75, 0x76, 0x77, 0x61, 0x62, 0x63, 0x64, 0x65,
0x66, 0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d,
0x6e, 0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75,
0x76, 0x77, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66,
0x67, 0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e,
0x6f, 0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76,
0x77, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67, 0x68,
0x00, 0x00, 0x00, 0x00				// ICV
};

int ikeylen = 16;
unsigned char ikey[] ={
	0x00, 0x00, 0x00,			// IV (gets copied over)
	0x31, 0x32, 0x33, 0x34, 0x35, 0x04, 0xef, 0x00,
	0x31, 0x32, 0x33, 0x34, 0x35, 0x17, 0x19, 0x19
};

int CDECL main(void) {
	unsigned long Crc;
	int r;

	Crc32Init();
	Crc32InitCheck();
	io_printf("\n\n");

	Crc = ~Crc32Buf(testbuf+4, sizeof(testbuf)-8);
	io_printf("~CRC of test buf before WEP %x %x\n", Crc);

	r = sizeof(testbuf)-4;
	testbuf[r] =   BYTE0GET(Crc);
	io_printf("%x ", testbuf[r]);
	testbuf[r+1] = BYTE1GET(Crc);
	io_printf("%x ", testbuf[r+1]);
	testbuf[r+2] = BYTE2GET(Crc);
	io_printf("%x ", testbuf[r+2]);
	testbuf[r+3] = BYTE3GET(Crc);
	io_printf("%x\n", testbuf[r+3]);
	fmpbuf(stdout, "\ntest buf before WEP\n", testbuf, sizeof(testbuf));
	io_printf("\n");

	ikey[0] = testbuf[0];
	ikey[1] = testbuf[1];
	ikey[2] = testbuf[2];
	if (ikeylen < 13)
		memcpy(&ikey[ikeylen + 3], &ikey[0], 13-ikeylen);
	fmpbuf(stdout, "key:\n", ikey, ikeylen+3);

	testbuf[r] = 0; testbuf[r+1] = 0; testbuf[r+2] = 0; testbuf[r+3] = 0;
	if (ikeylen == 16) {
		WepEncipher128((unsigned char *)ikey, testbuf+4, sizeof(testbuf)-8);
	} else {
		WepEncipher((unsigned char *)ikey, testbuf+4, sizeof(testbuf)-8);
	}
	fmpbuf(stdout, "test buf after WEP\n", testbuf, sizeof(testbuf));

	Crc = Crc32Buf(testbuf, sizeof(testbuf));
	io_printf("~CRC of test buf after WEP %x %x\n", Crc);

	if (ikeylen == 16) {
		WepDecipher128((unsigned char *)ikey, testbuf+4, sizeof(testbuf)-4);
	} else {
		WepDecipher((unsigned char *)ikey, testbuf+4, sizeof(testbuf)-4);
	}
	fmpbuf(stdout, "\ntest buf after DEWEP\n", testbuf, sizeof(testbuf));
	io_printf("\n");

	return 0;
}
#endif
#if 0
#ifndef SELFTEST
/*
 * simulate Atheros key table
 */
#define NKEY	64
#define KEYSIZE	16

static char keytable[NKEY][KEYSIZE];		/* table of wep keys */
static long long keytaddr[NKEY];		/* table of transmitter mac addresses */
static long long keyraddr[NKEY];		/* table of receiver mac addresses */
static char keytype[NKEY];			/* table of key types (40 bit, 104-bit, 128-bit) */
static int keylength[NKEY];			/* table of key types (40 bit, 104-bit, 128-bit) */
static keystruct *ocbBook[NKEY];		/* precomputed Li's and key schedule of ocb */
static int IVSize[NKEY];			/* used for AES */
static int MICSize[NKEY];			/* used for AES */

#define  WEP_40		0			/* WEP in 40bit  key mode */
#define  WEP_104	1			/* WEP in 104bit key mode */
#define  WEP_128	3			/* WEP in 128bit key mode */
#define  WEP2		4			/* WEP2 is a 128bit key that's xor'ed with IV */
#define  AES_OCB	5			/* AES_OCB uses a 128bit key */

/*
#define  IV_LEN		16
#define  TAG_LEN	4
*/
char wep_keys_set = 0;

#ifndef EVA
int wep_set_key(int index, unsigned char* key, int type, unsigned char* taddr, unsigned char* raddr, int ivSize, int micSize)
{
	int keylen;
	keystruct *newentry;

	IVSize[index] = ivSize;
	MICSize[index] = micSize;
	if (logstream == NULL) logstream = stderr;
	if (index < 0 || index >= NKEY) {
		fprintf(logstream, "snoop_set_key: invalid index == %d\n", index);
		return(1);
	}
	switch(type) {
	case WEP_40:
		keylen = 5;
		break;
	case WEP_104:
		keylen = 13;
		break;
	case AES_OCB:
		/* AES mode can have ivSize = 4 or 8, micSize = 8 or 10 */
		/* 7/13/01 in last meeting mic & iv size passed iv=6, mic=8 */
		if ((ivSize != 0 && ivSize != 1) || (micSize != 0 && micSize != 1)) {
		  fprintf(logstream, "wep_set_key: invalid AES IV and/or MIC size, IV = %d, MIC = %d\n", ivSize, micSize);
		  return(1);
		}
		IVSize[index ] = 6;
		MICSize[index ] = 8;
		/* initialize the Li's and aes keyschedule */
		if ( (newentry = ocb_aes_init(key, MICSize[index], NULL)) == NULL) {
		  fprintf(logstream, "wep_set_key: Could not initialize AES_OCB for index %d\n", index);
		  return(1);
		}
		ocbBook[index] = newentry;
		/* fall through to ensure keylen is set */

	case WEP_128:
	case WEP2:
		keylen = 16;
		break;
	default:
		fprintf(logstream, "snoop_set_key: unknown key type of %d at index %d\n", type, index);
		return(1);
	}
	keytype[index] = type;
	keylength[index] = keylen;
	memcpy(keytable[index], key, keylen);

	bzero(&keytaddr[index], 8);
	bzero(&keyraddr[index], 8);
	keytaddr[index] = get_be48(taddr);
	keyraddr[index] = get_be48(raddr);

	if (debug) {
		fprintf(logstream, "setting key index %d type %d len %d\n", index, type, keylen);
		fprintf(logstream, "taddr(0x%012llx) raddr(0x%012llx)\n", keytaddr[index], keyraddr[index]);
		fmpbuf(logstream, "full key:\n", keytable[index], keylen);
	}

	wep_keys_set = 1;

	return(0);
}

/*
 * pcheck entry point for dewepping a frame
 */
int dewepframe(FILE* F, unsigned char* fp, int plen, struct wlanframe *wfp)
{
	long long ta, ra;
	//unsigned char * fp = *pfp;
	unsigned char localkey[19];
	unsigned char nonce[16];
	unsigned char plaintext[4096];
	unsigned char *tag;
	unsigned char *da, *sa;
	unsigned char assocData[16];
	int index;
	int keylen;
	int ktype;
	int r, k;
	int ivSize, micSize;

	if (debug) {
	  fprintf(F, "Input to dewep stream of %d bytes:\n", plen);
	  fmpbuf(F, "Data:\n", fp, plen);
	}

	if (wfp == NULL) {
	  fprintf(F, "dewepframe: empty frame was specified!\n");
	  return(1);
	}

	ta = wfp->ta;
	ra = wfp->ra;
	da = &(wfp->da);
	sa = &(wfp->sa);

	/*
	 * 5/21/01
	 * We can detect encryption mode from the keytable.  But first, we must
	 * look at the keyID bits (30:31) to find what index into the table to
	 * use.  If none is provided (i.e. keyID == 0) then use the addresses.
	 *
	 * N.B.: this deviates from the current ESN spec in that we are leaving
	 * the keyID bits fixes vs. floating to the 2msbits of the IV.
 	 */
	k = 0;
	index = (int)fp[3];		/* key index from IV */
	r = index&0xf;
	if (r) {
		fprintf(F, "non-zero reserved bits in key index %x\n", r);
	}
	index >>= 6;			/* ID bits are the high-order ones */
	index &= 3;			/* truncate to 2 bits */

	if (index == 0) {
		for (k=0; k<NKEY; k++) {
			if ((keytaddr[k] == ta) && (keyraddr[k] == ra)) {
				goto keysetup;
			}
		}
		fprintf(F, "dewep: can't find key for ta(0x%012llx) ra(0x%012llx)\n", ta, ra);
		return(1);
	}
	k = index;

  keysetup:
	/*
	 * Now get the IV and set the keylen
	 */
	keylen = keylength[k];
	ktype = keytype[k];
	switch (ktype) {
	  case WEP_40:
	  case WEP_104:
	  case WEP_128:
		localkey[0] = fp[0];		/* 24 bit IV from payload */
		localkey[1] = fp[1];
		localkey[2] = fp[2];
		memcpy(&localkey[3], keytable[k], keylen);
		r = keylen+3;
		if (r < 16)
			memcpy(&localkey[r], &localkey[0], 16-r);

		fp += 4;
		plen -= 4;

		if (r==19)  				// 128-bit key, r will be 10
			r = WepDecipher128(localkey, fp, plen);
		else
			r = WepDecipher(localkey, fp, plen);
		break;

	  case WEP2: 	/* WEP2 : the key is xor'd with the IV */
		for (r=0; r<16; r++)
			localkey[r] = fp[r] ^ keytable[k][r];
		r = WepDecipher(localkey, (fp+16), (plen-16));
		break;

	  case AES_OCB:
		/* We must compose the IV and associated data from the addresses */
		/* we'll need to add the QoS stuff at some point too             */
		ivSize = IVSize[k];
		micSize = MICSize[k];

		bzero(nonce, sizeof(nonce));
		bzero(assocData, sizeof(assocData));
#if BYTE_ORDER == LITTLE_ENDIAN
fprintf(F, "dewep: LITTLE_ENDIAN\n");
		memcpy(nonce, sa, 6);		/* Always put the SA in nonce */
		/* Put the QoS selector half word in the nonce too, when ready */
fmpbuf(F, "IV=\n",fp, ivSize);
		memcpy((nonce+8), fp, ivSize);		/* Put the replay in nonce */

		memcpy(assocData, da, 6);	/* Put the DA into block0 */
#else
		for (r=0; r<6; r++) nonce[r] = sa[r+2]; /* Always put the SA in monce */
		/* Put the QoS selector half word in the nonce too, when ready */
		memcpy((nonce+8), fp, ivSize);		/* Put the replay in nonce */

		for (r=0; r<6; r++) assocData[r] = da[r+2];	/* DA into assoc data */
#endif

		memcpy(localkey, keytable[k], keylen);

		/*
		 * For now, don't overwrite the ciphertext, put the plaintext
		 * into it's own buffer so we can do comparisons.  Later, we
		 * can remove this contingency once we get it all working.
		 */
		memset(plaintext, 0, (plen-ivSize-micSize));
		tag = &fp[plen-micSize];
		r = ocb_aes_decrypt( F, ocbBook[k], nonce, (fp+ivSize), (plen-ivSize-micSize), plaintext,tag, assocData);
		break;

	  default:
		fprintf(F, "dewep: unknown keytype %d for ta(0x%012llx) ra(0x%012llx)\n", ktype, ta, ra);
		break;
	}

	if (!r) {
		unsigned int iv;

		fprintf(F, "wep index was %d; match found at index %d; ta was 0x%012llx, ra was 0x%012llx\n",
			index, k, ta, ra);
		switch (ktype) {
		  case WEP2:
			fmpbuf(F, "IV ^ key was:\n", localkey, keylen);
			for (iv=0; iv<16; iv++)  localkey[iv] = localkey[iv]^keytable[k][iv];
			fmpbuf(F, "Raw IV was:\n", localkey, keylen);
			break;
		  case AES_OCB:
			fmpbuf(F, "DA = ", da, sizeof(wfp->da));
			fmpbuf(F, "SA = ", sa, sizeof(wfp->sa));
			fmpbuf(F, "IV was:", nonce, 16);
			fmpbuf(F, "Assoc data was:", assocData, 16);
			break;
		  default:
			iv = localkey[2]; iv <<= 8;
			iv |= localkey[1]; iv <<= 8;
			iv |= localkey[0];
			fprintf(F, "Key IV key was 0x%06x\n", iv);
		        break;
		}
		fmpbuf(F, "key:\n", keytable[k], keylen);
	}

	return((r==1)?0:1);
}
#endif
#endif
#endif
