/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/common/wlanDev.c#3 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 * This file contains the routines to control the wlan device
 */

#include "wlandrv.h"
#include "wlanext.h"
#include "wlanDev.h"
#include "wlanSend.h"
#include "wlanchannel.h"
#include "usbstub.h"
#include "athusbapi.h"

A_STATUS
wlanDevInit(WLAN_DEV_INFO *pDev, WLAN_SERVICE service)
{
    A_STATUS            status;
    A_UINT32            cfgVal;
    A_UINT16            channelBand;
    CHANNEL_FREQ        channelFrequency;
    PHY_MODS            phyModulations;
    A_UINT32            cfgCtl,maxRDPower;
    A_INT8              twiceAntennaGain;
    A_UINT32            twiceAntennaReduction = 0;
    CHAN_VALUES         *pChan;

    status = wlanTransmitInit(pDev);
    if (status != A_OK) {
        return status;
    }
    
    /* for now */
    status = wlanDevStart(pDev, service);
    if (status != A_OK) {
        return status;
    }

    cfgVal = (A_UINT32)service;
    wdcTargetSetConfiguration(pDev->targetHandle, CFG_SERVICE_TYPE,
                              0, (TARGET_CONFIG_VAL)(&cfgVal), NULL);

    /* Set transmit power */
    cfgVal = (A_UINT32)pDev->staConfig.tpScale;
    wdcTargetSetConfiguration(pDev->targetHandle, CFG_TP_SCALE,
                              0, (TARGET_CONFIG_VAL)(&cfgVal), NULL);

    cfgVal = (A_UINT32)pDev->staConfig.tpcHalfDbm5;
    wdcTargetSetConfiguration(pDev->targetHandle, CFG_TPC_HALF_DBM5,
                              0, (TARGET_CONFIG_VAL)(&cfgVal), NULL);

    cfgVal = (A_UINT32)pDev->staConfig.tpcHalfDbm2;
    wdcTargetSetConfiguration(pDev->targetHandle, CFG_TPC_HALF_DBM2,
                              0, (TARGET_CONFIG_VAL)(&cfgVal), NULL);

    cfgVal = (A_UINT32)pDev->staConfig.overRideTxPower;
    wdcTargetSetConfiguration(pDev->targetHandle, CFG_OVERRD_TX_POWER,
                              0, (TARGET_CONFIG_VAL)(&cfgVal), NULL);

    /* 11g */
    cfgVal = (A_UINT32)pDev->protectOn;
    wdcTargetSetConfiguration(pDev->targetHandle, CFG_GMODE_PROTECTION,
                              0, (TARGET_CONFIG_VAL)(&cfgVal), NULL);
    
    cfgVal = (A_UINT32)pDev->protectRateIdx;
    wdcTargetSetConfiguration(pDev->targetHandle, CFG_GMODE_PROTECT_RATE_INDEX,
                              0, (TARGET_CONFIG_VAL)(&cfgVal), NULL);

    cfgVal = (A_UINT32)pDev->staConfig.protectionType;
    wdcTargetSetConfiguration(pDev->targetHandle, CFG_PROTECTION_TYPE,
                              0, (TARGET_CONFIG_VAL)(&cfgVal), NULL);

    cfgVal = (A_UINT32)pDev->staConfig.modeCTS;
    wdcTargetSetConfiguration(pDev->targetHandle, CFG_MODE_CTS,
                              0, (TARGET_CONFIG_VAL)(&cfgVal), NULL);

    /* RTS Threshold */
    cfgVal = (A_UINT32)pDev->staConfig.userRTSThreshold;
    wdcTargetSetConfiguration(pDev->targetHandle, CFG_USER_RTS_THRESHOLD,
                              0, (TARGET_CONFIG_VAL)(&cfgVal), NULL);

    /* Set Channel */
    pChan = pDev->staConfig.pChannel;
    athConvertChanValue(pChan,
                       &channelBand,
                       &channelFrequency,
                       &phyModulations);

    maxRDPower = wlanGetChannelPower(pDev, pChan);
    cfgCtl = wlanGetCtl(pDev, pChan);

    if (IS_CHAN_5GHZ(pChan->channelFlags)) {
        twiceAntennaGain = (A_INT8)pDev->devCap.twiceAntennaGain5G;
    } else {
        twiceAntennaGain = (A_INT8)pDev->devCap.twiceAntennaGain2G;
    }

    twiceAntennaReduction = (A_UINT32)wlanGetAntennaReduction(pDev,pChan,twiceAntennaGain);

    wdcTargetSetChannel(pDev->targetHandle,
                        channelBand,
                        channelFrequency,
                        phyModulations,
                        maxRDPower,
                        cfgCtl,
                        twiceAntennaReduction,
                        FALSE,
                        &status);

    pDev->staConfig.phwChannel = pDev->staConfig.pChannel;

    wlanUpdateWirelessMode(pDev, pDev->staConfig.pChannel, FALSE);

    return A_OK;
}


A_STATUS
wlanDevStart(WLAN_DEV_INFO *pDev, WLAN_SERVICE service)
{
    A_STATUS status;

    status = wlanTransmitStart(pDev);
    if (status != A_OK) {
        return status;
    }

    return A_OK;
}


void
wlanDevStop(WLAN_DEV_INFO *pDev)
{
    wlanTransmitStop(pDev);
}


void
wlanDevRelease(WLAN_DEV_INFO *pDev)
{
    wlanTransmitRelease(pDev);
}


#define ON_ASSOC_CHANNEL(_pDev)                                     \
    ((_pDev)->localSta &&                                           \
    ((_pDev)->localSta->staState & STATE_ASSOC) &&                  \
    ((_pDev)->staConfig.phwChannel == (_pDev)->staConfig.pChannel))

A_STATUS
wlanDevReset(WLAN_DEV_INFO *pDev, WLAN_SERVICE service, CHAN_VALUES *pChan, A_BOOL bChannelChange, A_BOOL keepRCContent)
{
    A_STATUS            status;
    A_UINT16            channelBand;
    CHANNEL_FREQ        channelFrequency;
    PHY_MODS            phyMods = PHY_MOD_NONE;    
    A_UINT32            cfgVal;
    A_UINT32            cfgCtl,maxRDPower;
    A_INT8              twiceAntennaGain;
    A_UINT32            twiceAntennaReduction = 0;

    athConvertChanValue(pChan,
                       &channelBand,
                       &channelFrequency,
                       &phyMods);    

    cfgVal = (A_UINT32)service;
    wdcTargetSetConfiguration(pDev->targetHandle, CFG_SERVICE_TYPE,
                              0, (TARGET_CONFIG_VAL)(&cfgVal), NULL);

    maxRDPower = wlanGetChannelPower(pDev, pChan);
    cfgCtl = wlanGetCtl(pDev, pChan);

    if (IS_CHAN_5GHZ(pChan->channelFlags)) {
        twiceAntennaGain = (A_INT8)pDev->devCap.twiceAntennaGain5G;
    } else {
        twiceAntennaGain = (A_INT8)pDev->devCap.twiceAntennaGain2G;
    }

    twiceAntennaReduction = (A_UINT32)wlanGetAntennaReduction(pDev,pChan,twiceAntennaGain);

    wlanUpdateWirelessMode(pDev, pChan, keepRCContent);

    if ((service == WLAN_STA_SERVICE) && ON_ASSOC_CHANNEL(pDev)) {
        athWmeIeGetInfo(pDev, &pDev->baseBss, &pDev->bssDescr->athWmeIe);
#ifdef WME
        wmeV1IeGetInfo(pDev, &pDev->baseBss, &pDev->bssDescr->wmeV1Ie);
#endif
    }

    /*
     * Update queue parameter
     */

    wlanTransmitStart(pDev);
    
    /* 
     * Queue parameter change only take effect during we do channel 
     * change on the target side
     */
    wdcTargetSetChannel(pDev->targetHandle,
                        channelBand,
                        channelFrequency,
                        phyMods,
                        maxRDPower,
                        cfgCtl,
                        twiceAntennaReduction,
                        keepRCContent,
                        NULL);
    pDev->staConfig.phwChannel = pChan;

    return A_OK;
}

A_BOOL
wlanDevPresent(WLAN_DEV_INFO *pDev)
{
    if ((pDev->targetHandle == NULL) || 
        (pDev->powerMgmt.hibernate == ENABLE) ||
        (pDev->busStatus != ATHUSB_BUS_STATE_NORMAL))
    {
        uiPrintf("Device Not Present\n");
        return FALSE;
    }

    return TRUE;
}
