/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/common/wlanReceive.c#1 $
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 * This file contains the routines to complete the mac layer tx functions.
 */

#include "wlandrv.h"
#include "wlanReceive.h"
#include "wdcApi.h"
#include "usbstub.h"

/**************************************************************************
 * wlanRxFilter
 *
 * Turn off/on bits in the receive packet filter.  Save it for resets, etc.
 *
 * Bits can be MAC_RX_UCAST, MAC_RX_MCAST, MAC_RX_BCAST, MAC_RX_BEACON,
 * MAC_RX_PROM, MAC_RX_CONTROL
 *
 * oper can be HAL_RX_FILTER_INIT, HAL_RX_FILTER_SET, HAL_RX_FILTER_CLEAR,
 * HAL_RX_FILTER_TEMP, HAL_RX_FILTER_RESTORE.
 *
 * NOTE: the bits parameter is not used for operation type HAL_RX_FILTER_RESTORE.
 *
 */
void
wlanRxFilter(WLAN_DEV_INFO *pDev, RX_FILTER_FLAGS bits, RX_FILTER_OPER oper)
{
    switch (oper) {

    case RX_FILTER_INIT:
        /* Init hardware register and software copy */
        pDev->rxFilter = bits;
        wdcSetRxFilter(pDev->targetHandle, pDev->rxFilter);
        break;

    case RX_FILTER_SET:
        /* Set frame type bits */
        pDev->rxFilter |= bits;
        wdcSetRxFilter(pDev->targetHandle, pDev->rxFilter);
        break;

    case RX_FILTER_CLEAR:
        /* Clear frame type bits */
        pDev->rxFilter &= ~bits;
        wdcSetRxFilter(pDev->targetHandle, pDev->rxFilter);
        break;

    case RX_FILTER_TEMP:
        /* Temporarily set hardware register ONLY. */
        wdcSetRxFilter(pDev->targetHandle, bits);
        break;

    case RX_FILTER_RESTORE:
        /* Restore hardware register with software copy */
        wdcSetRxFilter(pDev->targetHandle, pDev->rxFilter);
        break;

    default:
        // Unsupported operation
        ASSERT(0);
    }
}
