/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/ccx.h#1 $
 *
 * Copyright  2000-2003 Atheros Communications, Inc.,  All Rights Reserved.
 *
 */

#ifndef _CCX_H_
#define _CCX_H_

#include "wlantype.h"
#include "wlandrv.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WIN32
#pragma pack (push, 1)
#endif

#if defined(WLAN_CONFIG_CCX)

/* Forward declaration. Definitions in ccxdefs.h */
struct suplAuthStatus;


/* External Declarations */

A_STATUS
ccxInit(WLAN_DEV_INFO *pDev);

void
ccxFree(WLAN_DEV_INFO *pDev);

void
ccxDisassocCallback(WLAN_DEV_INFO *pDev);

void
ccxAssocCallback(WLAN_DEV_INFO *pDev);

void
ccxKeyPlumbedCallback(WLAN_DEV_INFO *pDev);

void
ccxInitPreferredAps(WLAN_DEV_INFO *pDev, A_UINT32 numBssids,
                    WLAN_MACADDR pBssids[]);

void
ccxProcessPreferredAps(WLAN_DEV_INFO *pDev, BSSDESCR_SET *pSet);

A_STATUS
ccxProcessRxFrame(WLAN_DEV_INFO *pDev, ATHEROS_DESC *pDesc, A_UINT16 etherType);

A_STATUS
ccxSendRogueApFrame(WLAN_DEV_INFO *pDev, WLAN_MACADDR *pAddr,
                    A_UINT16 failCode);

A_STATUS
ccxRogueListAdd(WLAN_DEV_INFO *pDev, WLAN_MACADDR *pBssid,
                A_UINT16 failureCode);

void
ccxRogueListFlush(WLAN_DEV_INFO *pDev, WLAN_MACADDR *pMac);

void
ccxLeapAuthCallback(WLAN_DEV_INFO *pDev, WLAN_MACADDR *peerAddr,
                    MLME_RESULT resultCode);

void
ccxCckmMicCalc(WLAN_DEV_INFO *pdevInfo, WLAN_MACADDR  *pDestAddr);

int
ccxCckmAddIe(SIB_ENTRY *lSib, A_UINT8 *buf);

void
ccxCckmKrkInvalidate(WLAN_DEV_INFO *pDevInfo);

A_STATUS
ccxCckmKrkAdd(WLAN_DEV_INFO *pDevInfo, PNDIS_802_11_KEY pKeyInfo);

void
ccxMixedPrivacyOptionConfigure(WLAN_DEV_INFO *pDevInfo,
                               A_BOOL mixedPrivacyOption);

A_STATUS
ccxMixedPrivacyPolicyCheck(WLAN_DEV_INFO *pDevInfo);

void
ccxAironetIeProcess(WLAN_DEV_INFO *pDevInfo, BSSDESCR *pBss, AIRONET_IE *pAie);

INFO_ELEMENT *
ccxStaIpAddrInsert(WLAN_DEV_INFO *pDevInfo, CCX_AP_ADDR *ccxApAddrIe,
                   A_UINT32 ipAddr);

INFO_ELEMENT *
ccxCkipStaRequest(WLAN_DEV_INFO *pDevInfo, BSSDESCR *pBss, AIRONET_IE *pAie);

void
ccxApAddrAssocRespProcess(WLAN_DEV_INFO *pDevInfo, CCX_AP_ADDR *pApAddr);

void
ccxAIEAssocRespProcess(WLAN_DEV_INFO *pDevInfo, AIRONET_IE *pAie);


A_STATUS
ccxAuthStatusProcess(WLAN_DEV_INFO *pDev, void *pData, A_UINT32 dataLen,
                     A_UINT32 *pBytesNeeded);

A_UINT16
ccxGetCckmIeSize(void);


#else /* defined(WLAN_CONFIG_CCX) */

#define ccxInit(WLAN_DEV_INFO) A_OK

#define ccxFree(WLAN_DEV_INFO)

#define ccxDisassocCallback(WLAN_DEV_INFO)

#define ccxAssocCallback(WLAN_DEV_INFO)

#define ccxKeyPlumbedCallback(WLAN_DEV_INFO)

#define ccxInitPreferredAps(WLAN_DEV_INFO, A_UINT32, WLAN_MACADDR)

#define ccxProcessPreferredAps(WLAN_DEV_INFO, BSSDESCR_SET)

#define ccxSendRogueApFrame(WLAN_DEV_INFO, WLAN_MACADDR, A_UINT16) A_ERROR

#define ccxRogueListAdd(WLAN_DEV_INFO, WLAN_MACADDR, A_UINT16) A_ERROR

#define ccxRogueListFlush(WLAN_DEV_INFO, WLAN_MACADDR)

#define ccxLeapAuthCallback(WLAN_DEV_INFO, WLAN_MACADDR, MLME_RESULT)

#define ccxCckmMicCalc(WLAN_DEV_INFO, WLAN_MACADDR)

#define ccxCckmAddIe(SIB_ENTRY, A_UINT8) 0

#define ccxCckmKrkInvalidate(WLAN_DEV_INFO)

#define ccxCckmKrkAdd(WLAN_DEV_INFO, PNDIS_802_11_KEY) A_ERROR

#define ccxMixedPrivacyOptionConfigure(WLAN_DEV_INFO, A_BOOL)

#define ccxMixedPrivacyPolicyCheck(WLAN_DEV_INFO) A_ERROR

#define ccxAironetIeProcess(WLAN_DEV_INFO, BSSDESCR, AIRONET_IE)

#define ccxStaIpAddrInsert(WLAN_DEV_INFO, CCX_AP_ADDR, A_UINT32) ((INFO_ELEMENT *)(CCX_AP_ADDR))

#define ccxCkipStaRequest(WLAN_DEV_INFO, BSSDESCR, AIRONET_IE) ((INFO_ELEMENT *)(AIRONET_IE))

#define ccxApAddrAssocRespProcess(WLAN_DEV_INFO, CCX_AP_ADDR)

#define ccxAIEAssocRespProcess(WLAN_DEV_INFO, AIRONET_IE)

#define ccxProcessRxFrame rxNullHandler

#define ccxAuthStatusProcess(_pDev, _pData, _dataLen, _pBytesNeeded) (A_ERROR)

#define ccxGetCckmIeSize() 0

#endif /* defined(WLAN_CONFIG_CCX) */

#ifdef WIN32
#pragma pack (pop)
#endif

#ifdef __cplusplus
}
#endif

#endif /* _CCX_H_ */
