/*
 * Copyright (c) 2001-2002 Atheros Communications, Inc., All Rights Reserved
 *
 * AP CLI interface definitions.
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/cli.h#1 $
 */

#ifndef _CLI_H_
#define _CLI_H_

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* VxWorks Standard Input, output, error file descriptors */
#define STD_IN          0
#define STD_OUT         1
#define STD_ERR         2

#define MAX_TOKEN       50
#define CLI_INBUF       256
#define CLI_BANNER      "\nAtheros Access Point Rev " ATHEROS_SW_VERSION "\n"
#define CLI_WLAN_PROMPT "wlan"
#define CLI_PROMPT      "->"
#define CLI_SUPERUSER   "atheros"
#define CLI_HIDDENCMD   "."

#define CLI_PARSE_OK                    A_OK            /*  0 */
#define CLI_PARSE_ERROR                 A_ERROR         /* -1 */
#define CLI_PARSE_NO_TBL                1
#define CLI_PARSE_NO_VALUE              2
#define CLI_PARSE_TOO_FEW               3
#define CLI_PARSE_TOO_MANY              4
#define CLI_PARSE_UNKNOWN               5
#define CLI_PARSE_INPUT_ERROR           6
#define CLI_PARSE_INVALID_PARAMETER     7
#define CLI_PARSE_QUIT                  9999

#define CLI_TOKEN_WILDCARD              "*"
#define CLI_TOKEN_NULL_STRING           "\"\""

#define CLI_MAX_IO_DEV                  10

#define CLI_FTP_CMD_PARM_DNLOAD         "download"
#define CLI_FTP_CMD_PARM_UPLOAD         "upload"

void    cliConsoleTask(int fin, int fout);      /* called as a task */

#if defined(TELNET_202_WAR)
#define TELNETD_MAX_CLIENTS     4
#define TELNETD_TASKFLAG        FALSE
#define TELNETD_PARSER_HOOK     cliTelnetHook
#define TELNETD_PORT            23
STATUS  cliTelnetHook(int, UINT32, int *, int *);
#endif

/* For http/ftp based cli scripting. */
int  runFtpScriptRestore(void);
int  runFtpScriptHandler(int, int);

A_STATUS PasswordHash(char *password, A_UCHAR *ssid, int ssidlength, A_UCHAR *output);

typedef enum {
    CLI_STATIC_TURBO = 1,
    CLI_DYNAMIC_TURBO = 2
} CLI_TURBO_TYPE;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _CLI_H_ */

