/*
 * Copyright 2003 Atheros Communications Inc
 * All rights reserved
 *
 * Module which implements the aes key wrap algorithm as specified in
 * RFC-3394.
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/crypto/aes_keywrap.h#1 $
 */

#ifndef _INCLUDE_CRYPTO_AES_KEYWRAP_H_
#define _INCLUDE_CRYPTO_AES_KEYWRAP_H_

#ifdef __cplusplus
extern "C" {
#endif

A_STATUS
aes_keywrap_encrypt(char *dest, const char *src, unsigned long buflen,
                    const char *keyptr, unsigned long keylen);


A_STATUS
aes_keywrap_decrypt(char *dest, const char *src, unsigned long buflen,
                    const char *keyptr, unsigned long keylen);


#ifdef __cplusplus
}
#endif

#endif /* _INCLUDE_CRYPTO_AES_KEYWRAP_H_ */
