/*
 * ccm.h
 *
 */

#ifndef __CCM__H
#define __CCM__H

/*
 * "ccm_init" optionally creates an ccm_private keystructure in key structure
 * and then initializes it using the key values supplied in the key structure. 
 * If "ccm keystruc" is NULL a new structure will be created, but if 
 * "ccm_private" is non-NULL, then it is assumed that it points to a previously 
 * allocated structure, and that structure is initialized. 
 *
 * "ccm_init" returns status of the initialization 
 */
int
ccm_init(WLAN_PRIV_RECORD *pk);     /* CCM key structure */


/* "ccm_close deallocates a ccm_private structure and returns NULL */
void
ccm_close(WLAN_PRIV_RECORD *pk);    /* CCM key structure */

/*
 * "ccm_encipher" takes a key structure, header buffer, header length,
 * data payload buffer and pay load length, excluding IV and ICV.
 * it is assumed that there is space beginning at &data[dlen]
 * for the 8-byte MIC.
 *
 * "ccm_encipher" returns 1 if encryption successes, otherwise 0
 */
int
ccm_encipher(WLAN_PRIV_RECORD *pk,  /* decrypt key structure             */
             unsigned char *mpdu,   /* start address of the frame header */
             int hdrlen,            /* header length including 8-byte IV */
             unsigned char *data,   /* start address of the data payload */
             int dlenn);            /* payload length, excluding IV, ICV */


/*
 * "ccm_decipher" takes a key structure, MPDU buffer and a length
 * parameter as input. "len" excludes fcs, includes header, IV, payload, 
 * and MIC bytes that are pointed to by "mpdu" are decrypted and written 
 * to the buffer pointed to by "mpdu" again. 
 * "ccm_decipher" returns 0 if the MIC check fails, 
 * otherwise 1 is returned if the MIC check passes.
 */
int                                
ccm_decipher(WLAN_PRIV_RECORD *pk,  /* decrypt key structure            */
             unsigned char *mpdu,   /* Buffer for (incoming) ciphertext */
             int len);              /* Byte length of mpdu              */

#endif /* __CCM__H */


