/*
 *  Copyright (c) 2002 Atheros Communications Inc.  All rights reserved
 */
#ifndef _CRYPTO_CKIP_H
#define _CRYPTO_CKIP_H

#ifndef Linux
typedef unsigned char u8;
typedef const unsigned char cu8;
typedef unsigned short u16;
typedef long s32;
#endif
#ifdef WIN32
typedef unsigned __int64        u64;
typedef __int64                 s64;
#elif !defined(Linux)
typedef unsigned long long u64;
typedef long long s64;
#endif

/* macro for fetching unaligned big endian unsigned 32-bit integers */
#define GB(p,i,s)               ( ((u32) *((u8*)(p)+i) ) << (s) )
#define GETBIG32(p)             GB(p,0,24)|GB(p,1,16)|GB(p,2,8)|GB(p,3,0)

#define PB(p, v, ss)            p = (v>>ss)&0xff;
#define PUTBIG32(p, v)          PB(p[0],v,24); PB(p[1],v,16); PB(p[2],v,8); PB(p[3],v,0)

typedef struct {            /* --- MMH context                            */
    u8  CK[16];             /* the key                                    */
    u8  coefficient[16];    /* current aes counter mode coefficients      */
    u64 accum;              /* accumulated mic, reduced to u32 in final() */
    int position;           /* current position (byte offset) in message  */
    u8  part[4];            /* for conversion of message to u32 for mmh   */
    u8  aes_precomp[1600];  /* precomp aes coefficients */
    u8  aes_savcomp[1600];
    u8  precomp_valid;
    u8  prevcomp_valid;
} mic_context;

struct ckip_private {
    mic_context ctx;
    u8 valid_aes_precomp, valid_aes_savcomp;
    u32 seq_uplink;
    u32 seq_dnlink;
};


/*===========================================================================*/
/*=================== CKIP KEY PERMUTATION ==================================*/
/*===========================================================================*/

/* 2-byte by 2-byte subset of the full AES table */
static const u16 Sbox[256] =
{
    0xC6A5,0xF884,0xEE99,0xF68D,0xFF0D,0xD6BD,0xDEB1,0x9154,
    0x6050,0x0203,0xCEA9,0x567D,0xE719,0xB562,0x4DE6,0xEC9A,
    0x8F45,0x1F9D,0x8940,0xFA87,0xEF15,0xB2EB,0x8EC9,0xFB0B,
    0x41EC,0xB367,0x5FFD,0x45EA,0x23BF,0x53F7,0xE496,0x9B5B,
    0x75C2,0xE11C,0x3DAE,0x4C6A,0x6C5A,0x7E41,0xF502,0x834F,
    0x685C,0x51F4,0xD134,0xF908,0xE293,0xAB73,0x6253,0x2A3F,
    0x080C,0x9552,0x4665,0x9D5E,0x3028,0x37A1,0x0A0F,0x2FB5,
    0x0E09,0x2436,0x1B9B,0xDF3D,0xCD26,0x4E69,0x7FCD,0xEA9F,
    0x121B,0x1D9E,0x5874,0x342E,0x362D,0xDCB2,0xB4EE,0x5BFB,
    0xA4F6,0x764D,0xB761,0x7DCE,0x527B,0xDD3E,0x5E71,0x1397,
    0xA6F5,0xB968,0x0000,0xC12C,0x4060,0xE31F,0x79C8,0xB6ED,
    0xD4BE,0x8D46,0x67D9,0x724B,0x94DE,0x98D4,0xB0E8,0x854A,
    0xBB6B,0xC52A,0x4FE5,0xED16,0x86C5,0x9AD7,0x6655,0x1194,
    0x8ACF,0xE910,0x0406,0xFE81,0xA0F0,0x7844,0x25BA,0x4BE3,
    0xA2F3,0x5DFE,0x80C0,0x058A,0x3FAD,0x21BC,0x7048,0xF104,
    0x63DF,0x77C1,0xAF75,0x4263,0x2030,0xE51A,0xFD0E,0xBF6D,
    0x814C,0x1814,0x2635,0xC32F,0xBEE1,0x35A2,0x88CC,0x2E39,
    0x9357,0x55F2,0xFC82,0x7A47,0xC8AC,0xBAE7,0x322B,0xE695,
    0xC0A0,0x1998,0x9ED1,0xA37F,0x4466,0x547E,0x3BAB,0x0B83,
    0x8CCA,0xC729,0x6BD3,0x283C,0xA779,0xBCE2,0x161D,0xAD76,
    0xDB3B,0x6456,0x744E,0x141E,0x92DB,0x0C0A,0x486C,0xB8E4,
    0x9F5D,0xBD6E,0x43EF,0xC4A6,0x39A8,0x31A4,0xD337,0xF28B,
    0xD532,0x8B43,0x6E59,0xDAB7,0x018C,0xB164,0x9CD2,0x49E0,
    0xD8B4,0xACFA,0xF307,0xCF25,0xCAAF,0xF48E,0x47E9,0x1018,
    0x6FD5,0xF088,0x4A6F,0x5C72,0x3824,0x57F1,0x73C7,0x9751,
    0xCB23,0xA17C,0xE89C,0x3E21,0x96DD,0x61DC,0x0D86,0x0F85,
    0xE090,0x7C42,0x71C4,0xCCAA,0x90D8,0x0605,0xF701,0x1C12,
    0xC2A3,0x6A5F,0xAEF9,0x69D0,0x1791,0x9958,0x3A27,0x27B9,
    0xD938,0xEB13,0x2BB3,0x2233,0xD2BB,0xA970,0x0789,0x33A7,
    0x2DB6,0x3C22,0x1592,0xC920,0x8749,0xAAFF,0x5078,0xA57A,
    0x038F,0x59F8,0x0980,0x1A17,0x65DA,0xD731,0x84C6,0xD0B8,
    0x82C3,0x29B0,0x5A77,0x1E11,0x7BCB,0xA8FC,0x6DD6,0x2C3A
};


#define Lo8(v16)     ((v16)       & 0xFF)
#define Hi8(v16)    (((v16) >> 8) & 0xFF)
#define u16Swap(i)  ( (((i) >> 8) & 0xFF) | (((i) << 8) & 0xFF00) )
#define _S_(i)      (Sbox[Lo8(i)] ^ u16Swap(Sbox[Hi8(i)]))

#define rotLeft_1(x) ((((x) << 1) | ((x) >> 15)) & 0xFFFF)

/* mic accumulate */
#define MIC_ACCUM(v)    context->accum += (u64)v * mic_getcoefficient(context)
#define FAST_MIC_ACCUM(v, context, aes)    (context->accum += (u64)((u64)v * (u64)(MIC_GETCOEFF(aes, context))))

static mic_context ctx;
static u8 mic_snap[] = { 0xAA, 0xAA, 0x03, 0x00, 0x40, 0x96, 0x00, 0x02 };
u8 calcmic[4];      /* calculated mic */

#endif /* _CRYPTO_CKIP_H */
