/*
 *  Copyright (c) 2002, Atheros Communications Inc.  All rights reserved 
 */

#ifndef __SWCRYPTO_COMMON__
#define	__SWCRYPTO_COMMON__

// compile environment
#ifdef	EVA		
#define	nonalignedbuffers
#define	ASSERT(a)
#include "swcrypto_selftest.h"
#elif	PCI_NDIS
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <stdio.h>
#include "assert.h"
#include "wlandrv.h"
#include "ndisdrvext.h"
#include "crypto/rijndael-alg-fst.h"
#elif	VXWORKS
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <stdio.h>
#include "wlandrv.h"
#include "assert.h"
#include "crypto/rijndael-alg-fst.h"
#elif   Linux
#include "wlandrv.h"
#include "linuxdefs.h"
#include "crypto/rijndael-alg-fst.h"
#endif

#ifdef	SELFTEST
//#define	MPX	mpx
//#define	INLINE	__INLINE__
#include "swcrypto_selftest.h"
#endif

#ifdef CCMTEST
#define ASSERT(a)
#endif

// null out the mpx print function unless MPX is defined
#ifdef	MPX
#define	mpx(a,b,c)  mpx(a,b,c)
#else
#define	mpx(a,b,c)
#endif

static INLINE void
xor_block(dest, a)
unsigned long a[], dest[];
{
    if (((int)dest&3) || ((int)a&3)) {
        unsigned char *cdest, *ca;
        int i;

        cdest = (unsigned char *)dest;
        ca = (unsigned char *)a;

        for (i = 0; i < 16; i++) {
            cdest[i] ^= ca[i];
        }
    } else {
        dest[0] ^= a[0];
        dest[1] ^= a[1];
        dest[2] ^= a[2];
        dest[3] ^= a[3];
    }
}

static INLINE void
xor3_block(dest, a, b)
unsigned long dest[], a[], b[];
{
    if (((int)dest & 3) || ((int)a & 3) || ((int)b & 3)) {
        unsigned char *cdest, *ca, *cb;
        int i;

        cdest = (unsigned char *)dest;
        ca = (unsigned char *)a;
        cb = (unsigned char *)b;

        for (i=0; i < 16; i++) {
            cdest[i] = ca[i] ^ cb[i];
        }
    } else {
        dest[0] = a[0] ^ b[0];
        dest[1] = a[1] ^ b[1];
        dest[2] = a[2] ^ b[2];
        dest[3] = a[3] ^ b[3];
    }
}


/*
 * compare two mic values (8 bytes)
 * return zero if equal
 */
static INLINE int
cmp_mic_err(a, b)
unsigned long a[], b[];
{
    if (((int)b & 3) || ((int)a & 3)) {
        unsigned char *cb, *ca;

        cb = (unsigned char *)b; ca = (unsigned char *)a;

        if (ca[0]!=cb[0] || ca[1]!=cb[1] || ca[2]!=cb[2] || ca[3]!=cb[3]
            || ca[4]!=cb[4] || ca[5]!=cb[5] || ca[6]!=cb[6] || ca[7]!=cb[7])
        {
            return(1);
        } else {
            return(0);
        }
    } else {
        if (a[0]==b[0] && a[1]==b[1]) {
            return(0);
        } else {
            return(1);
        }
    }
}

#if SELFTEST
/*
 * compare two keys (16 bytes)
 * return zero if equal
 */
static INLINE int
cmp_key_err(a, b)
unsigned long a[], b[];
{
	ASSERT(((int)a&3)==0);
	ASSERT(((int)b&3)==0);


#ifdef nonalignedbuffers
	if (((int)b&3)||((int)a&3)) {
		unsigned char *cb, *ca;

		cb = (unsigned char *)b; ca = (unsigned char *)a;

		if (ca[0]!=cb[0] || ca[1]!=cb[1] || ca[2]!=cb[2] || ca[3]!=cb[3]
			|| ca[4]!=cb[4] || ca[5]!=cb[5] || ca[6]!=cb[6] || ca[7]!=cb[7]
			|| ca[8]!=cb[8] || ca[9]!=cb[9] || ca[10]!=cb[10] || ca[11]!=cb[11]
			|| ca[12]!=cb[12] || ca[13]!=cb[13] || ca[14]!=cb[14] || ca[15]!=cb[15] )
			return(1); else
			return(0);
	}
#endif

	if (a[0]!=b[0]) return(1);
	if (a[1]!=b[1]) return(1);
	if (a[2]!=b[2]) return(1);
	if (a[3]!=b[3]) return(1);
	return(0);
}

#endif

#define	dot11ADDR1  4
#define	dot11ADDR2  10
#define	dot11ADDR3  16
#define	dot11SEQ    22
#define	dot11ADDR4  24
#define	dot11QOS    30
#define	B_TODS		0
#define	B_FROMDS	1
#define	B_MOREFRAG	2
#define	B_RETRY		3
#define	B_PWR		4
#define	B_MOREDATA	5
#define	B_WEP		6
#define	B_ORDER		7

#define	B_0		0x1
#define	B_1		0x2
#define	B_2		0x4
#define	B_3		0x8
#define	B_4		0x10
#define	B_5		0x20
#define	B_6		0x40
#define	B_7		0x80


#define	RSN_NONE	0
#define	RSN_WEP		1
#define	RSN_TKIP	2
#define	RSN_OCB		3
#define	RSN_CCM		4

#endif
