/*
 * Copyright 2003 Atheros Communications Inc.
 */
#ifndef _CRYPTO_TKIP
#define _CRYPTO_TKIP

A_STATUS
tkipEnmic(WLAN_PRIV_RECORD *pKey, A_UINT8 *pkt, A_UINT32 pktlen);

A_STATUS
tkipDemic(WLAN_PRIV_RECORD *pKey, A_UINT8 *pkt, A_UINT32 pktlen, WLAN_MACADDR *src, WLAN_MACADDR *dest, void *qosInfo);

typedef enum {
    TKIP_IV_UPDATE = 0,
    TKIP_REKEY,
} TKIP_OP;

A_STATUS
tkipIVSet(WLAN_PRIV_RECORD *pk, A_UINT8 *ivp, TKIP_OP op);

A_STATUS
tkipEncipher(WLAN_PRIV_RECORD *pk, A_UINT8 *mpdu, int pktlen);

A_STATUS
tkipDecipher(WLAN_PRIV_RECORD *pk, A_UINT8 *mpdu, A_UINT32 flen);

void Phase1(A_UINT8 *P1K, A_UINT8 *TK, A_UINT8 *TA, A_UINT32 IV32);
void Phase2();

A_STATUS
michael(A_UINT8 *key, A_UINT8 *buf, A_UINT32 blen, A_UINT8 *h, A_UINT32 hlen, A_UINT8 *qos);

A_UINT64
tkipSeqCtrGet(A_UINT8 *ivp);

void
tkip_close(WLAN_PRIV_RECORD *);

#endif
