/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/diags/display.h#1 $
 *
 * Copyright  2000-2003 Atheros Communications, Inc.,  All Rights Reserved.
 */

/* display.h - definitions for display processing */

#ifndef _DISPLAY_H_
#define _DISPLAY_H_

#ifdef __cplusplus
extern "C" {
#endif

/* includes */
#include "wlanproto.h"
#include "wlansme.h"
#include "wlandrv.h"

/* defines for test to display descriptor fields */
#define DESC_ADDR       "This Desc:     "
#define	NEXT_DESC		"Next Desc:     "
#define BUFFER_PTR		"Buff Ptr:      "
#define CONTROL_1		"Control 1:     "
#define CONTROL_2		"Control 2:     "
#define CONTROL_3		"Control 3:     "
#define CONTROL_4		"Control 4:     "
#define FRAME_LEN		"Frame Len:     "
#define HDR_LEN			"Hdr Len:       "
#define XMIT_RATE		"Xmit Rate:     "
#define XMIT_POWER      "Xmit Power     "
#define RTS_CTS_EN		"RTS/CTS En:    "
#define LONG_PKT		"Long Pkt:      "
#define CLR_DEST_MSK	"Clr Dest Msk:  "
#define ANT_MODE_TX		"Ant Mode Xmit: "
#define ATIM			"ATIM:          "
#define INT_REQ			"Inter Req:     "
#define ENCRYPT_KEY_VLD "Crypt Key Vld: "
#define BUFFER_LEN		"Buff Len:      "
#define MORE			"More:          "
#define ENCRYPT_KEY_IDX "Crypt Key Idx: "
#define RTS_DURATION	"RTS Duration:  "
#define COMP_PROC   	"Comp process:  "
#define COMP_IV_LEN 	"comp IV len:   "
#define COMP_ICV_LEN	"comp ICV len:  "


#define ORIG_BUFVIRT_PTR "Orig Buff Ptr:"
#define STATUS_1		"Status 1:      "
#define STATUS_2		"Status 2:      "
#define DATA_LEN		"Data Len:      "
#define RX_ANT			"RX Ant:        "
#define RX_RATE			"RX Rate:       "
#define RX_RSSI			"RX RSSI:       "
#define DONE			"Done:          "
#define PKT_RX_OK		"Pkt RX Ok:     "
#define CRC_ERROR		"RX CRC Error:  "
#define FIFO_OVERRUN	"FIFO Overrun:  "
#define DECRYPT_CRC_ERR	"DecryptCRCerr: "
#define PHY_ERROR       "PHY Error:     "
#define DECRYPT_KEY_VLD "DeCrypt KeyVld:"
#define DECRYPT_KEY_IDX "Decrypt KeyIdx:"
#define RX_TIMESTAMP	"RX TimeStamp:  "

/* defines for packet header data fields */
#define PROTO_VER		"Protocol ver  "
#define TYPE			"Type          "
#define MGT_TYPE		"Type        MGT"
#define CTRL_TYPE		"Type       CTRL"
#define DATA_TYPE		"Type       DATA"
#define SUBTYPE			"Subtype       "
#define TO_DS			"To DS         "
#define FROM_DS			"From DS       "
#define MORE_FRAG		"More Frag     " 
#define RETRY			"Retry         "
#define PWR_MGT			"Pwr Mgt       "
#define MORE_DATA		"More Data     "
#define WEP				"WEP           "
#define PRIVACY			"Privacy       "
#define ALLOW_SHORT     "Allow ShortP  "
#define ALLOW_SSLOT     "Allow ShortS  "
#define ORDER			"Order         "
#define DUR_ID			"Duration/ID   "
#define ADDRESS_1		"Address 1     "
#define ADDRESS_2		"Address 2     "
#define ADDRESS_3		"Address 3     "
#define ADDRESS_4		"Address 4     "
#define SEQ_NUM			"Sequence Num  "
#define FRAG_NUM		"Fragment Num  "
#define SRC_ADDR		"Src Address   "
#define DEST_ADDR		"Dest Address  "
#define TRANS_ADDR		"Transmit Addr "
#define REC_ADDR		"Receive Addr  "
#define BSSID_ADDR		"BSS Id        "
#define STA_ADDR		"STA MAC Addr  "
#define LISTEN_INT		"Listen Intrv  "
#define ASSOC_ID		"Assoc Id      "
#define CURAP_ADDR		"Current AP    "
#define CF_POLLABLE		"CF Pollable   "
#define CF_POLLREQ		"CF Poll Req   "
#define ESS_CAP			"ESS           "
#define IBSS_CAP		"IBSS          "
#define STATUS_CODE		"Status Code   "
#define REASON_CODE		"Reason Code   "
#define ALGO_NO			"Algorithm Num "
#define TRANS_SEQ		"Transact Num  "
#define FCS_STR			"FCS           "
#define TIMESTAMP_STR	"Timestamp     "
#define BEACON_INTRV	"Beacon Intrv  "
#define FCS_FIELD_NAME	"FCS		 "

/* PLCP header fields */
#define PLCP_RSSI		"rssi        "
#define PLCP_RATE		"rate        "
#define PLCP_LENGTH		"length      "
#define PLCP_PARITY		"parity      "
#define PLCP_TAIL		"tail        "
#define PLCP_SERVICE	"service     "

/* Information element names */
#define SSID_VALUE      "SSID                "
#define SUPP_RATES      "Supported Rates     "
#define FH_SET          "FH Parameter Set    "
#define DS_SET          "DS Parameter Set    "
#define CF_SET          "CF Parameter Set    "
#define TIM_DISP        "TIM                 "
#define IBSS_DISP       "IBSS Parameter Set  "
#define CHLG_DISP       "Challenge Text      "
#define UCSE_DISP       "Unicast Ciphers     "
#define MCSE_DISP       "Multicast Ciphers   "
#define COUNTRY_INFO_DISP \
                        "Country Info        "
#define NONERP_DISP     "NONERP element      "
#define VENPRIV_DISP    "Vendor Private      "
#define EXT_SUPP_RATES  "Ext Supported Rates "
#define UNKNOWN_DISP    "Unknown             "

/* PERL global variable name definitions */
#define	GV_RATE				"dk::rate      = "
#define	GV_TO_DS			"dk::toDS      = "
#define	GV_FROM_DS			"dk::fromDS    = "
#define	GV_RTS_CTS			"dk::rtscts    = "
#define	GV_PROTO_VER		"dk::protoVer  = "
#define	GV_RETRY			"dk::retry     = "
#define	GV_PWR_MGT			"dk::pwrMgt    = "
#define	GV_MORE_DATA		"dk::moreData  = "
#define	GV_ORDER			"dk::order     = "
#define	GV_DATA_FILL		"dk::dataFill  = "
#define	GV_AUTO_QUEUE		"dk::autoQueue = "
#define GV_DESC_INTR		"dk::descIntr  = "


/**************************************************************************
* displayDataPacket - Display contents of packet from virtual contiguous 
*					  buffer
*
* Given a pinter to a buffer, will display the contents are a data packet
* packet data must be in a single contiguous buffer for this function
*
* RETURNS: N/A
*/
void displayDataPacket
	(
	void		*pData,			/* pointer to packet data */
	A_UINT32	physAddress,	/* physical address of packet data */
	A_UINT16	pktLength,		/* length of packet (hdr + data) */
	A_BOOL		rxPkt			/* true is this is a receive packet, false otherwise */
	);

/**************************************************************************
* displayPktHeader - Display contents of packet header
*
* 
*
* RETURNS:
*/
void displayDataPktHeader
	(
	void		*pData,			/* virtual pointer to pkt header */
	A_UINT16	hdrLength		/* length of packet header */
	);

/**************************************************************************
* displayPlcpHeader - Display contents of PLCP header
*
* 
*
* RETURNS:
*/
void displayPlcpHeader
	(
	WLAN_PLCP_HEADER *pHeader		/* pointer to PLCP header */
	);

/**************************************************************************
* printframeControl - Print the Frame control fields of header
* 
*
* RETURNS: N/A
*/
void printFrameControl
	(
	FRAME_CONTROL* frameControl
	);


/**************************************************************************
* printMacAddress - Print a MAC address
* 
*
* RETURNS: N/A
*/
void printMacAddress
	(
	WLAN_MACADDR macAddress
	);

/**************************************************************************
* printSsid - Print SSID
*
*
* RETURNS: N/A
*/
void printSsid
    (
    SSID *pSsid
    );

/**************************************************************************
* displayTxDescContents - Display contents of transmit ATHEROS_DESC(s)
*
* Given a pointer to a queue of transmit ATHEROS_DESC, this function will either 
* display a single descriptor, or display all the descriptors linked
* together depending on displayAll flag.
*
* RETURNS: N/A
*/
void displayTxDescContents
	(
	ATHEROS_DESC *pDesc,			/* pointer to descriptors to display */
	A_BOOL		 displayAll,		/* TRUE to display all, FALSE to display 1 */
	A_UINT32		 physAddr			/* physical address of this descriptor */
	);

/**************************************************************************
* displayRxDescContents - Display contents of receive ATHEROS_DESC(s)
*
* Given a pointer to a queue of received ATHEROS_DESC, this function will either 
* display a single descriptor, or display all the descriptors linked
* together depending on displayAll flag.
*
* RETURNS: N/A
*/
void displayRxDescContents
	(
	ATHEROS_DESC *pDesc,			/* pointer to descriptors to display */
	A_BOOL		 displayAll,		/* TRUE to display all, FALSE to display 1 */
	A_UINT32		 physAddr			/* physical address of this descriptor */
	);

/**************************************************************************
 * displayCapInfo - displays various fields of Capabilities Info structure
 *
 * Takes pointer to the CAP_INFO structure (which is only 2 bytes) and prints
 * the bit fields.
 *
 * RETURNS: N/A
 */

void displayCapInfo
	(
	CAP_INFO	*capInfo
	);

/**************************************************************************
 * displayInfoElement - displays Information elements in mgt frame
 *
 * Takes pointer to the INFO_ELEMENT structure and prints the element ID,
 * length and variable length value in hex dump.
 *
 * RETURNS: N/A
 */

void displayInfoElement
	(
		INFO_ELEMENT	*infoEle
	);

/**************************************************************************
 * displayMgtFrameHdr - Display header of a management frame
 *
 * Displays only the frame header of a management frame.
 *
 * RETURNS: N/A
 */

void displayMgtFrameHdr
	(
	WLAN_MGT_MAC_HEADER	*pmacHdr
	);


/**************************************************************************
 * displayMgtFrame - Display a complete management frame
 *
 * Displays a complete management frame.
 *
 * RETURNS: N/A
 */

void displayMgtFrame
	(
	WLAN_MGT_MAC_HEADER	*pmacHdr,	/* pointer to MAC hdr of the frame*/
	A_UINT16	frameSize			/* Size of complete frame */
	);

/**************************************************************************
 * displayMgtFrameShort - Display a complete management frame, shorter format
 *
 * Displays a complete management frame, shorter format
 *
 * RETURNS: N/A
 */

void displayMgtFrameShort
	(
	WLAN_MGT_MAC_HEADER	*pmacHdr,	/* pointer to MAC hdr of the frame*/
	A_UINT16	frameSize			/* Size of complete frame */
	);

/**************************************************************************
 * displayCtrlFrame - Display a complete controlframe
 *
 * Displays a complete control frame.
 *
 * RETURNS: N/A
 */

void displayCtrlFrame
	(
	WLAN_MGT_MAC_HEADER	*pmacHdr	/* pointer to MAC hdr of the frame*/
	);

/**************************************************************************
 * displayStates - Display a SIB Station state and transitional state
 *
 * RETURNS: N/A
 */

void displayStates
	(
	A_UINT32	sState,
	A_UINT32	tState
	);

/**************************************************************************
 * displaySib - Display a SIB Station Information Block
 *
 * Command exported to user to important fields of SIB , by supplying
 * the pointer.
 *
 * RETURNS: N/A
 */

void displaySib
	(
	SIB_ENTRY	*pSib	/* Pointer to SIB */
	);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __INCdisplayh */
