/* 
 *  Copyright (c) 2002, Atheros Communications Inc., All Rights Reserved
 *  $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/eap.h#1 $
 */

#ifndef __INC_EAP_H
#define __INC_EAP_H

#ifdef WIN32
#pragma pack (push, 1)
#endif

/*
 *  An EAPOL header
 */
typedef struct eapolHdr_s {
    A_UINT8	eapolProtoVers;
    A_UINT8	eapolType;
    A_UINT16	eapolBodyLength;
} __ATTRIB_PACK EAPOL_HEADER;

#define EAPOL_PROTOVERS			0x01
#define EAPOL_TYPE_PACKET		0x00
#define EAPOL_TYPE_START		0x01
#define	EAPOL_TYPE_LOGOFF		0x02
#define EAPOL_TYPE_KEYMSG		0x03
#define	EAPOL_TYPE_ASF_ALERT		0x04

/* These are control messages that will never go on the air */
/* they're just for the Authenticator's internals */
#define EAPOL_TYPE_PORTENABLED		0xFD
#define EAPOL_TYPE_PORTDISABLED		0xFE

/*
 *  An EAP header, used only if eapolType == EAP_TYPE_PACKET.
 *  Do NOT use sizeof on this...use the constants below
 */
typedef struct eap_s {
    A_UINT8		eapCode;
    A_UINT8		eapIdentifier;
    A_UINT16		eapLength; // inc code and ident fields
    A_UINT8		eapType;
#define EAP_HDRLEN	5
    A_UINT8		eapData[1]; // variable size
} __ATTRIB_PACK EAP;

/*
 *  EAPOL-Key message, type 1-RC4
 */
typedef struct eapolKey_s {
    A_UINT8	keyType;
    A_UINT16	keyLength;
    A_UINT64	keyReplayCtr;
    A_UINT8	keyIV[16];
    A_UINT8	keyIndex;
#define KEY_USAGE_BROADCAST	0x00
#define KEY_USAGE_UNICAST	0x80
    A_UINT8	keySig[16];
    /* secret goes here */
} __ATTRIB_PACK EAPOL_KEY;

#define	EAPOL_KEY_TYPE_RC4		0x01
#define EAPOL_KEY_TYPE_WPA              0xFE

typedef struct EAPOL_KEY_INFO_s {
    A_UINT16     type:3,      // 1 for HMAC-MD5, 2 for AES-KEYWRAP
		 keyType:1,   // 1 = PW, 0 = group
		 keyIndex:2,  // 802.11 key index
		 keyUsage:1,  // if PW, this is install bit
                              // if group, it's rx/both bit
		 ack:1,       // STA sets this, AP clears it
		 mic:1,       // set iff msg is MICd
		 secure:1,    // set if PW keys in use
		 error:1,     // STA saw a MIC error
	         request:1,   // STA wants a new key
		 reserved:4;
} __ATTRIB_PACK EK_INFO;

/*
 * The type field specifies the EAPOL-KEY MIC algorithm and the
 * GTK encryption algorithm
 * These are defined in LE order
 */
#define EKI_TYPE_TKIP   4       // HMAC-MD5 and RC4
#define EKI_TYPE_AES    2       // HMAC_SHA1 and AES-KEYWRAP

/*
 *  HMAC-SHA1-128 is the EAPOL-Key MIC; HMAC is defined in RFC 2104, 
 *  and SHA1 by FIPS-180-1. The output of the HMAC-SHA1 shall be 
 *  truncated to its most significant 128-bits (octets 0-15 of the 
 *  digest output by HMAC-SHA1).
 */

#define EKI_KEYTYPE_PAIRWISE   1
#define EKI_KEYTYPE_GROUP      0

typedef struct eapolKeyWPA_s {
    A_UINT8     descType;
    EK_INFO     keyInfo;
    A_UINT16    keyLength;
    A_UINT64    replayCtr;
    A_UINT8     keyNonce[32];
    A_UINT8     keyIV[16];
    A_UINT64    keyRSC;
    A_UINT64    keyID;
    A_UINT8     keyMIC[16];
    A_UINT16    keyDataLength;
    A_UINT8     keyData[1]; // 0 or more octets
} __ATTRIB_PACK EAPOL_KEY_WPA;

#define EAP_SUCCFAIL_LEN		0x0004
#define EAP_RQ_IDENTITY_LEN		0x0005

/* values for code field in EAP pkt */
#define EAP_CODE_REQUEST		0x01
#define EAP_CODE_RESPONSE		0x02
#define EAP_CODE_SUCCESS		0x03
#define EAP_CODE_FAILURE		0x04

/* values for type field in EAP pkt */
#define EAP_TYPE_IDENTITY		0x01
#define EAP_TYPE_NOTIFICATION		0x02
#define EAP_TYPE_NAK			0x03	
#define EAP_TYPE_MD5CHALLENGE		0x04
#define EAP_TYPE_EAPTLS			0x0D
#define EAP_TYPE_LEAP			0x11

#define EAP_MAX_LEN			0xffff

#ifdef WIN32
#pragma pack (pop)
#endif

#endif /* __INC_EAP_H */
