/*
 * Copyright (c) 2000-2003, Atheros Communications Inc.
 *
 * See the corresponding .c file for additional usage information.
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/intercept.h#1 $
 */

#ifndef _INTERCEPT_H_

#include "wlantype.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INTERCEPT_ENABLED

#define ENTRY_FN(_type, _fn, _paramTypes, _params, _locn) \
_type _fn _paramTypes
#define ENTRY_FN_VOID(_fn, _paramTypes, _params, _locn)   \
void _fn _paramTypes

#define ICEPT_INIT()
#define ICEPT_POLL()

#else // INTERCEPT_ENABLED

/*
 * These fancy macro allows us to create a stub function that places calls to
 * iceptEntry() and iceptExit() around our entry points.  We need two macros.
 * One for functions which return something, and another for those with void
 * return types.
 */
#define ENTRY_FN(_type, _fn, _paramTypes, _params, _locn) \
_type _fn _paramTypes                                     \
{                                                         \
    extern _type _fn##_real _paramTypes;                  \
    _type temp;                                           \
    iceptEntry(_locn);                                    \
    temp = _fn##_real _params;                            \
    iceptExit(_locn);                                     \
    return temp;                                          \
}                                                         \
_type _fn##_real _paramTypes

#define ENTRY_FN_VOID(_fn, _paramTypes, _params, _locn)   \
void _fn _paramTypes                                      \
{                                                         \
    extern void _fn##_real _paramTypes;                   \
    iceptEntry(_locn);                                    \
    _fn##_real _params;                                   \
    iceptExit(_locn);                                     \
}                                                         \
void _fn##_real _paramTypes

#define ICEPT_INIT()   iceptInit()
#define ICEPT_POLL()   iceptPoll()

#define MAX_ENTRY_POINTS 22

/*
 * NOTE: Be sure to increase MAX_ENTRY_POINTS if the enumerated value
 *       gets too large. Be sure that profNames[] in intercept.c
 *       is also changed accordingly.
 */
typedef enum {
    ICEPT_STAPOLL    = 0,
    ICEPT_OIDGET     = 1,
    ICEPT_OIDSET     = 2,
    ICEPT_SEND       = 3,
    ICEPT_RETURNRX   = 4,
    ICEPT_CHECKHANG  = 5,
    ICEPT_SMETIMER   = 6,
    ICEPT_CAL        = 7,
    ICEPT_ISR        = 8,
    ICEPT_DPC        = 9,
    ICEPT_INITIALIZE = 10,
    ICEPT_HALT       = 11,
    ICEPT_SHUTDOWN   = 12,
    ICEPT_RESET      = 13,
    ICEPT_RESETDONE  = 14,
    ICEPT_PNP        = 15,
    ICEPT_SLEEPTRACK = 16,
    ICEPT_LEAP       = 17,
    ICEPT_MACSTOP    = 18,
    ICEPT_HIBERNATE  = 19
} ICEPT_ENUM;

/*
 * Exported interceptor code. Can place these in other locations as
 * necessary.
 */
VOID iceptInit();
VOID iceptPoll();
VOID iceptEntry(ICEPT_ENUM locn);
VOID iceptExit(ICEPT_ENUM locn);

#endif // INTERCEPT_ENABLED

#ifdef __cplusplus
}
#endif

#endif // _INTERCEPT_H_
