/*************************************************************************
 * Copyright © 2000-2002 Atheros Communications, Inc., All Rights Reserved
 *
 * Atheros and the Atheros logo and design are trademarks of Atheros
 * Communications, Inc.
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/linuxdrvext.h#3 $
 * NDIS data structs and macros
 */

#ifndef _LINUXDRVEXT_H_
#define _LINUXDRVEXT_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Given a MiniportContextHandle return the WLAN_DEV_INFO* it represents. */
#define DEVINFO_FROM_CONTEXT(Handle) ((WLAN_DEV_INFO *)(Handle->priv))

/* Miniport Reserved Area macros */
#define MP_RSRVD_GET_REF_COUNT(_pNdisPkt) (0)

#define MP_RSRVD_SET_REF_COUNT(_pNdisPkt, value)

#define MP_RSRVD_INC_REF_COUNT(_pNdisPkt)

#define MP_RSRVD_DEC_REF_COUNT(_pNdisPkt)

#define ATH_OSPKTREF_DUP(_pOrig, _pDup)

#define ATH_OSPKTREF_FREE(_pDesc)

#define ATH_OSBUFREF_DUP(_pOrig, _pDup)             do {                    \
    (_pDup)->OSspecificInfo  = (_pOrig)->OSspecificInfo;                    \
	if((_pOrig)->OSbuffer) {                                              \
		(_pDup)->OSbuffer = skb_clone((_pOrig)->OSbuffer, GFP_ATOMIC);  \
	}                                                                       \
    (_pOrig)->OSspecificInfo = -1;                                          \
} while (0)

#define NdisWriteErrorLogEntry(_Adapt, _ErrCode, _NumErrs, _ProcId, _Spec1, _Spec2, Spec3)                                                                   \
        athLogError(_Adapt, _ProcId, _ErrCode, _Spec1)

/* Error logging macro. */
#define athLogError(_Adapt, _ProcId, _ErrCode, _Spec1)                      \
        printk(KERN_ERR "%s %s Line %d, Dev %p : Error %d, ProcId %p, Code : %x\n",\
        __FILE__, __FUNCTION__, __LINE__,                                    \
        (_Adapt), (_ErrCode), (_ProcId), (_Spec1))

typedef PVOID  FHANDLE;

/*
 * Device structure is for each instance of the adapter, hence multiple
 * instances of WLAN_DEV_INFO. This is equivalent to Adapter data structure
 * in sample driver.
 */
/*
 * GCC Note - Forward declaration for a previously typedefed struct is not
 * acceptable to GCC compiler;  Remove the typedef from here and leave the one
 * available in linuxdefs.h intact
 */
struct osDevInfo {
    WLAN_DEV_INFO           *pdevInfo;   // pointer back to its own devinfo

    /* NDIS adapter initialization related fields */

    // Driver descriptor; the vendor's name from Registry
    ANSI_STRING             driverDesc; 
    // one extra for null-terminator
    CHAR                    driverDescBuffer[133];  

    /* Timer structure used for asyncronous resets */
    A_TIMER                 NicAsyncResetTimer;

    /* Timer structure used for standby/hibernate events */
    A_TIMER                 NicPnPEventTimer;

    // Timer structure used for sleep tracking
    A_TIMER                 NicSleepLogTimer;
    struct SleepBin         *pSleepBins;

    /* Handle given by NDIS when the Adapter registered itself */
    struct net_device       *NicAdapterHandle;

    /* Blowfish key used to encrypt WEP keys in the registry. 36 char + null term */
    ANSI_STRING             cardCfgId; 
    CHAR                    cardCfgIdBuffer[37];

    /* Clist string from registry */
    ANSI_STRING             clist; 
    CHAR                    clistBuffer[80];

    /* Country Name string from registry */
    ANSI_STRING             countryName; 
    CHAR                    countryNameBuffer[4];

    NDIS_ENVIRONMENT_TYPE   Environment;            // Windows NT or Windows

    USHORT                  ndisDriverMajorVersion; // Major version of NDIS that this driver supports
    USHORT                  ndisDriverMinorVersion; // Minor version of NDIS that this driver supports

    /* Memory management related fields */
    NDIS_HANDLE             rxBufferPool;
    NDIS_HANDLE             rxPacketPool;
    USHORT                  mapRegArray[MAX_MAP_REGISTERS];
    int                     numMapRegisters;
    int                     mapIndexFirst;
    int                     mapIndexLast;
    int                     mapRegsAvail;

    A_BOOL                  connectionStatus;      // connection status indicated to upper layer
    A_BOOL                  resetConnectionStatus; // connection status when NDIS reset began
    A_UINT32                resetCheckCounter;     // check for connection until connected or zero
    A_BOOL                  resourceAvail;         // false if NDIS_STATUS_RESOURCES reported to ndis

    A_BOOL                  registeredSDH;         // registered the ShutDown Handler
    A_BOOL                  postInit;              // allows some initialization to be done outside of init context
    A_BOOL                  postInitLinkSpeed;     // YAF to handle initial link speed reporting
    A_UINT32                wzcInfrastructureMode; // BSS type set by zero-config
    A_BOOL                  openForBusiness;       // whether to block all incoming calls from the OS
    A_UINT32                startTime;             // System uptime when device is attached, in seconds
    A_ATOMIC                txFramesPended;        // keep track of the # of frames the OS has given us
    SSID_ARRAY              ssids;                 // SSIDs given to us by the OS
    A_BOOL                  wzcActive;             // TRUE if the WZC service is controlling us
    A_ATOMIC                txIrpPended;

    A_UINT32                systemState;           // used to track the system state for the timers.
    struct net_device_stats stats;
    struct iw_statistics    wi_stats;
    A_UINT32                scan_timestamp;
};

/*
 * Large buffer descriptor, mapped onto the beginning of the DMA buffer
 * given by NDIS. The Atheros descriptor will point into this buffer, offset
 * by this descriptor.
 *
 * Note: If this struct is changed, make sure its size is a dword-multiple
 * for DMA engine efficiency.
 */
typedef struct drvBufDesc {
    A_UINT32            thisPhysAddr;
    struct drvBufDesc   *nextBufDesc;
} DRV_BUF_DESC;

typedef ULONGLONG   NDIS_802_11_KEY_RSC;

// Key mapping keys require a BSSID
typedef struct LINUX_NDIS_802_11_KEY
{
    ULONG           Length;             // Length of this structure
    ULONG           KeyIndex;           
    ULONG           KeyLength;          // length of key in bytes
    WLAN_MACADDR    BSSID;
    NDIS_802_11_KEY_RSC KeyRSC;
    UCHAR           KeyMaterial[1];     // variable length depending on above field
} NDIS_802_11_KEY, *PNDIS_802_11_KEY;

typedef struct LINUX_NDIS_802_11_WEP
{
    ULONG           Length;             // Length of this structure
    ULONG           KeyIndex;           // 0 is the per-client key, 1-N are the
                                        // global keys
    ULONG           KeyLength;          // length of key in bytes
    UCHAR           KeyMaterial[1];     // variable length depending on above field
} NDIS_802_11_WEP, *PNDIS_802_11_WEP;


#define A_MS_TICKGET()                  tickGet()

/* Other misc. macros */

/* NDIS wants RSSI indicated relative to -95 dBm */
#define RSSI_TO_NDIS(x)                 ((x) - 95)

/* assuming that msIndex is a valid index */
#define MS_TO_ATH_KEYINDEX(msIndex)                      \
        ((A_UINT16)(((msIndex & 0x7FFFFFFF) > 3) ?       \
        UNIQ_KEY_INDEX : (msIndex & 0x7FFFFFFF)))

#define MS_IS_DEFAULT_KEY(msIndex)                       \
        ((msIndex & 0x80000000) == 0x80000000)

/*
 * NDIS doesn't define this yet, though they should.  So we'll define it here
 * and remove it once they catch up.
 */
typedef struct ndisKeyProps {
    A_UINT32 index:8,            // Index of key
             mbz:20,             // Must be zero
             authenticatorKey:1, // This key desc came from the authenticator
             initSC:1,           // Should init the TKIP SC
             pairWise:1,         // Key is a pairwise (unique) key
             usageTransmit:1;    // Key can be used for xmit
} NDIS_KEY_PROPS;

/* Not supported for now! */
#define A_DELAYED_EXEC(_pDev, _delay, _func)        A_OK

/*
 * Locking macros
 */

#define CREATE_LOCKED                   1
#define CREATE_UNLOCKED                 0
#define A_SEM_INIT(sem, type, isLocked) do {    \
    (sem).initialized = 0xabcddcba;             \
    atomic_set(&(sem).num,0);                   \
    spin_lock_init(&((sem).spinLock));          \
}while (0)

/*
    if (isLocked == CREATE_LOCKED) {            \
        atomic_inc(&(sem).num);                 \
        spin_lock_irqsave(&(sem).spinLock,(sem).flags);             \
    }                                           \
*/
/*
 * We cant really find out if a semaphore is valid with a true/false condition
 * If the semaphore is not initialized we might have some junk.  Introduce
 * a magic number for verifying the validity
 */
#define A_SEM_VALID(sem)                ((sem).initialized == 0xabcddcba)

#define A_SEM_DELETE(sem)               do {    \
    sem.initialized = FALSE;                    \
} while (0)

#define A_SEM_LOCK(sem, param) do {                                         \
    atomic_inc(&(sem.num));                                                 \
    lockPrintf("==>%s() line%d: Acquire Semlock, num = %d\n",               \
                __FUNCTION__,__LINE__,atomic_read(&sem.num));                             \
    spin_lock(&((sem).spinLock));                                           \
} while (0)

#define A_SEM_UNLOCK(sem) do {                                              \
    atomic_dec(&(sem.num));                                                 \
    lockPrintf("<==%s() line%d: Release Semlock,num=%d\n",                  \
                __FUNCTION__,__LINE__,atomic_read(&sem.num));                             \
    ASSERT(atomic_read(&sem.num) >= 0);                                                   \
    spin_unlock(&((sem).spinLock));                                         \
} while (0)

#define A_SIB_TAB_LOCK(sibTab) do {                                         \
    atomic_inc(&((sibTab->sibTableSem).num));                               \
    lockPrintf("==>%s() line%d: Acquire SibTablock, num = %d\n",            \
                __FUNCTION__,__LINE__,atomic_read(&(sibTab->sibTableSem).num));           \
    spin_lock(&((sibTab->sibTableSem).spinLock));                           \
} while (0)

#define A_SIB_TAB_UNLOCK(sibTab) do {                                       \
    atomic_dec(&((sibTab->sibTableSem).num));                               \
    lockPrintf("<==%s() line%d: Release SibTablock, num = %d\n",            \
                __FUNCTION__,__LINE__,atomic_read(&(sibTab->sibTableSem).num));           \
    ASSERT(atomic_read(&(sibTab->sibTableSem).num) >= 0);                                 \
    spin_unlock(&((sibTab->sibTableSem).spinLock));                         \
} while (0)

#define A_SIB_ENTRY_LOCK(sib) do {                                          \
    atomic_inc(&((sib->sibLock).num));                                      \
    lockPrintf("==>%s() line%d: Acquire SibEntrylock, num = %d\n",          \
                __FUNCTION__,__LINE__,atomic_read(&(sib->sibLock).num));                  \
    spin_lock(&((sib->sibLock).spinLock));                                  \
} while (0)

#define A_SIB_ENTRY_UNLOCK(sib)   do {                                      \
    atomic_dec(&((sib->sibLock).num));                                      \
    lockPrintf("<==%s() line%d: Release SibEntrylock, num = %d\n",          \
                __FUNCTION__,__LINE__,atomic_read(&(sib->sibLock).num));                  \
    ASSERT(atomic_read(&(sib->sibLock).num) >= 0);                                        \
    spin_unlock(&((sib->sibLock).spinLock));                                \
} while (0)

#define ATH_GET_PACKET_MR(_p)         (_p)

#define A_TASK_LOCK()
#define A_TASK_UNLOCK()

/*
 * Define isrPrintf() for printing from ISR context.  Things are different
 * for the VXWORKS and NDIS drivers, hence the following somewhat-less-than-elegant
 * solution until we have a common, comprehensive tracing facility.
 */
#define isrPrintf                       uiPrintf

/* Timer macros */

#define A_INIT_TIMER(pd, pt, pf, rep)   (drvLinuxTimerInit(pd, pt, pf, rep)) 
#define A_TIMEOUT(pt, per, par, op)     (drvLinuxTimerSet(pt, per, par, op))
#define A_UNTIMEOUT(pt)                 (drvLinuxTimerCancel(pt))
#define A_DELETE_TIMER(pt)              (drvLinuxTimerDelete(pt)) 
#define A_USLEEP(usec)                  (drvLinuxSleep(usec))

/*
 * Cache flushing macros
 * These are empty for now as we're running on a cache-coherent platform
 */

#define A_DATA_CACHE_INVAL(addr, len)
#define A_DATA_CACHE_FLUSH(addr, len)
#define A_DESC_CACHE_INVAL(addr)
#define A_DESC_CACHE_FLUSH(addr)

#define A_PIPEFLUSH()

/* Memory access macros */

#define hwMemWrite8(pd, addr, value)    (*((UCHAR *)(addr) ) = (UCHAR)(value))
#define hwMemWrite16(pd, addr, value)   (*((UINT  *)(addr) ) = (UINT) (value))
#define hwMemWrite32(pd, addr, value)   (*((ULONG *)(addr) ) = (ULONG)(value))

#define hwMemRead8(pd, addr)            (*((volatile UCHAR *)(addr)))
#define hwMemRead16(pd, addr)           (*((volatile UINT  *)(addr)))
#define hwMemRead32(pd, addr)           (*((volatile ULONG *)(addr)))

/* External function declarations */

NDIS_STATUS
mapRegistersGet(WLAN_DEV_INFO *pDevInfo, int num, USHORT *pArray);

void
mapRegistersReturn(WLAN_DEV_INFO *pDevInfo, int num, USHORT *pArray);

ATHEROS_DESC *
osPacketToAthDesc(WLAN_DEV_INFO *pDevInfo, void *pOsPacket,A_STATUS * status);

void *
athDescToOsPacket(WLAN_DEV_INFO *pDevInfo, ATHEROS_DESC *pDesc);

void
athTxFrameReleaseBufferMaps(WLAN_DEV_INFO *pDevInfo, ATHEROS_DESC *pDesc);

void
athNdisRxComplete(WLAN_DEV_INFO *pDevInfo, PNDIS_PACKET pOsPacket);

A_UINT32
tickGet(void);

// =============================================
// Routines in receive.c
// =============================================

VOID
StartReceiveUnit(WLAN_DEV_INFO *pdevInfo, A_UINT32 newFilter);

VOID
staFrameReceive(WLAN_DEV_INFO *pdevInfo, ATHEROS_DESC *pRxDesc);

BOOLEAN
ProcessRXInterrupt(WLAN_DEV_INFO *pdevInfo);

void
hostRxCallback(
    IN  WLAN_DEV_INFO       *pDevInfo,
    IN  ATHEROS_DESC        *pDesc,
    IN  HOST_CONN_HANDLE    hostConnHandle,
    IN  RECEIVE_INFO        *pInfo);

NDIS_STATUS
SetupReceiveQueues(WLAN_DEV_INFO *pDev);

VOID
StopReceive(WLAN_DEV_INFO *pDevInfo);

VOID
StopSwReceive(WLAN_DEV_INFO *pDev);

#ifdef __cplusplus
}
#endif

#endif /* _LINUXDRVEXT_H_ */

