/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/linuxext.h#2 $
 *
 * NDIS routine prototypes
 *
 * Copyright (c) 2000-2003 Atheros Communications, Inc., All Rights Reserved
 *
 * Sample Code from Microsoft Windows 2000 Driver Development Kit is
 * used under license from Microsoft Corporation and was developed for
 * Microsoft by Intel Corp., Hillsboro, Oregon: Copyright (c) 1994-1997
 * by Intel Corporation.
 */

#ifndef _NDISDRVEXT_H_
#define _NDISDRVEXT_H_

// =============================================
// Routines in ar5210.c
// =============================================

A_STATUS
ResetOnError(WLAN_DEV_INFO *pdevInfo, CLEAR_TX_Q_ENUM clearTxQueue,
             RESET_CTR_ENUM ctrEnum, DRAIN_ENUM waitForDrain);

typedef enum {
    SHUTDOWN_EVENT,
    HIBERNATE_EVENT,
    CONFIG_EVENT,
    SHUTDOWN_TYPE_MAX
} SHUTDOWN_TYPE;

void
athShutdownDriver(IN WLAN_DEV_INFO *pDevInfo, IN SHUTDOWN_TYPE event);

NDIS_STATUS
athRestartDriver(IN WLAN_DEV_INFO *pDevInfo);

NDIS_STATUS
initNdisTimers(WLAN_DEV_INFO *pDevInfo);

void
stopNdisTimers(IN WLAN_DEV_INFO *pDevInfo, A_BOOL delete);

void
startNdisTimers(IN WLAN_DEV_INFO *pDevInfo);

A_STATUS
securityInitialization(IN WLAN_DEV_INFO *pDevInfo);

void
phyHangCheck(WLAN_DEV_INFO *pDevInfo);

// =============================================
// Routines in hw.c
// =============================================

#ifndef Linux
VOID
udelay(ULONG useconds);
#endif

// =============================================
// Routines in init.c
// =============================================

NDIS_STATUS
ClaimAdapter(WLAN_DEV_INFO *pDevInfo, NDIS_HANDLE ConfigurationHandle);

NDIS_STATUS
SetupAdapterInfo(WLAN_DEV_INFO *pdevInfo);

NDIS_STATUS
SetupSharedAdapterMemory(WLAN_DEV_INFO *pdevInfo);

// =============================================
// Routines in hw.c
// =============================================

A_STATUS
hwAllocateBufMemory(struct wlanDevInfo *pDevInfo, A_UINT16 memSize);

A_STATUS
hwAllocateDescMemory(struct wlanDevInfo *pdevInfo, A_UINT16 size);

// =============================================
// Routines in interrup.c
// =============================================

/*
 * some timer macros
 */

#define ATHUSB_SYSTEM_INIT        0x00000001  // athInitialize in progress or completed
#define ATHUSB_SYSTEM_TIMER_INIT  0x00000002  // System Timer initialized
#define ATHUSB_SYSTEM_TIMER_STOP  0x00000100  // System Timers stopped
#define ATHUSB_SYSTEM_HALT        0x00010000  // Driver is halting or unloading
#define ATHUSB_SYSTEM_SHUTDOWN    0x00020000  // System is shutting down

#define ATHUSB_SYSTEM_VALID       (ATHUSB_SYSTEM_INIT | ATHUSB_SYSTEM_TIMER_INIT)

#define SYSTEMSTATE_CHECK(context, state) ((context)->pOSHandle->systemState & (state) ? 1 : 0)
#define SYSTEMSTATE_SET(context, state)   ((context)->pOSHandle->systemState |= (state))
#define SYSTEMSTATE_CLEAR(context, state) ((context)->pOSHandle->systemState &= ~(state))
#define SYSTEMSTATE_VALID(context)        (((context)->pOSHandle->systemState & ATHUSB_SYSTEM_VALID) == ATHUSB_SYSTEM_VALID ? TRUE : FALSE)

VOID
athIsr(PBOOLEAN pIsRecognized, PBOOLEAN pQueueHandler, NDIS_HANDLE context);

VOID
athHandleInterrupt(NDIS_HANDLE context);

// =============================================
// routines in osfunc.c
// =============================================

A_STATUS
athNdisAllocMem(WLAN_DEV_INFO *pdevInfo, A_UINT32 buffSize,
                A_UINT32 *pPhysAddress, VOID **ppVirtAddress);

A_STATUS
athNdisFreeMem(WLAN_DEV_INFO *pdevInfo, A_UINT32 buffSize,
               A_UINT32 pPhysAddress, VOID *ppVirtAddress);

A_STATUS
drvLinuxTimerInit(WLAN_DEV_INFO *pdevInfo, A_TIMER *pTimer, void *pFunc,
                 A_BOOL repeat);

A_STATUS
drvLinuxTimerSet(A_TIMER *pTimer, A_UINT32 timeVal, A_UINT32 param,
                A_UINT32 oper);

A_BOOL
drvLinuxTimerCancel(A_TIMER *pTimer);

A_STATUS
drvLinuxTimerDelete(A_TIMER *pTimer);

void
athTimerHandler(PVOID context);

void
mlmePollHandler(void *pContext);

void
osIndicateAuth(WLAN_DEV_INFO *pDevInfo, ULONG flags, WLAN_MACADDR *pBssid);

// =============================================
// routines in parse.c
// =============================================

NDIS_STATUS
ParseRegistryParameters(WLAN_DEV_INFO *pdevInfo, NDIS_HANDLE ConfigHandle,
                        WLAN_STA_CONFIG *pConfig);

// =============================================
// routines in pci.c
// =============================================

USHORT
FindPciDevice50Scan(WLAN_DEV_INFO *pdevInfo, NDIS_HANDLE ConfigurationHandle,
                    USHORT VendorID, USHORT DeviceID,
                    PPCI_CARDS_FOUND_STRUC PciCardsFound);

void
WritePCISlotInfo(WLAN_DEV_INFO *pdevInfo, ULONG Slot);

#ifdef NDIS40_MINIPORT
USHORT
FindPciDeviceScanNT4(WLAN_DEV_INFO *pdevInfo, NDIS_HANDLE ConfigurationHandle,
                     USHORT VendorID, USHORT DeviceID,
                     PPCI_CARDS_FOUND_STRUC pPciCardsFound);

#endif

// =============================================
// Routines in receive.c
// =============================================

VOID
StartReceiveUnit(WLAN_DEV_INFO *pdevInfo, A_UINT32 newFilter);

VOID
staFrameReceive(WLAN_DEV_INFO *pdevInfo, ATHEROS_DESC *pRxDesc);

BOOLEAN
ProcessRXInterrupt(WLAN_DEV_INFO *pdevInfo);

void
hostRxCallback(
    IN  WLAN_DEV_INFO       *pDevInfo,
    IN  ATHEROS_DESC        *pDesc,
    IN  HOST_CONN_HANDLE    hostConnHandle,
    IN  RECEIVE_INFO        *pInfo);

NDIS_STATUS
SetupReceiveQueues(WLAN_DEV_INFO *pDev);

VOID
StopReceive(WLAN_DEV_INFO *pDevInfo);

VOID
StopSwReceive(WLAN_DEV_INFO *pDev);

// =============================================
// Routines in request.c
// =============================================

NDIS_STATUS
athSetInformation(NDIS_HANDLE MiniportAdapterContext, NDIS_OID Oid,
                  PVOID InformationBuffer, ULONG InformationBufferLength,
                  PULONG BytesRead,PULONG BytesNeeded);

NDIS_STATUS
athQueryInformation(NDIS_HANDLE MiniportAdapterContext, NDIS_OID Oid,
                    PVOID InformationBuffer, ULONG InformationBufferLength,
                    PULONG BytesWritten, PULONG BytesNeeded);
typedef enum {
    ADD_KEY = 0,
    ADD_WEP,
} KEY_STRUCT_TYPE;

A_STATUS
athKeyPlumb(WLAN_DEV_INFO *pDevInfo, void *pBuf, KEY_STRUCT_TYPE type);
// =============================================
// routines in send.c
// =============================================

VOID
athMultipleSend(NDIS_HANDLE context, PPNDIS_PACKET pArray, UINT numPackets);

void
TransmitCompletion(WLAN_DEV_INFO *pDevInfo, ATHEROS_DESC *pDesc,
                   A_BOOL success, COMPLETION_ENUM completePacket);

#if NDIS_WDM
void
txHostCallback(WLAN_DEV_INFO *pdevInfo, ATHEROS_DESC *pDesc,  
	       TRANSMIT_INFO *pInfo);
#endif

NDIS_STATUS
athSendSinglePacket(WLAN_DEV_INFO *pDevInfo, PNDIS_PACKET Packet);

VOID
drainSendWaitQueue(WLAN_DEV_INFO *pDevInfo);

VOID
abortSendWaitQueue(WLAN_DEV_INFO *pDevInfo);

// =============================================
// routines in powermgt.c
// =============================================

void
dataFrameHdrFill(WLAN_DEV_INFO *pdevInfo, WLAN_DATA_MAC_HEADER3 *pFrame,
                 WLAN_MACADDR *destAddr, int subtype);

// =============================================
// routines in osfunc.c
// =============================================

VOID
athResetComplete(void *pContext);

VOID
athPnPEventComplete(void *pContext);

VOID
athSleepTrack(void *pContext);

void
osIndicateConnectStatus(WLAN_DEV_INFO *pDevInfo, A_BOOL connectStatus);

void
osIndicateResourcesAvailable(WLAN_DEV_INFO *pdevInfo);

// =============================================
// routines in leapsupp.c
// =============================================

A_STATUS
leapInit(WLAN_DEV_INFO *);

void
leapReceive(WLAN_DEV_INFO *pDevInfo, ATHEROS_DESC *pDesc);

void
leapTimerSvc(void *pContext);

// =============================================
// routines in stapoll.c
// =============================================

void
staPollHandler(void *pContext);

#ifdef NDIS40_MINIPORT
NTSTATUS
TpaConnect(
    IN  PDRIVER_OBJECT DriverObject
    );
#endif // NDIS40_MINIPORT


#endif  // _NDISDRVEXT_H_


