/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/radardefs.h#1 $
 *
 * DFS and radar detection data structures and definitions
 *
 * Copyright (c) 2001-2003 Atheros Communications, Inc., All Rights Reserved
 */

#ifndef _RADARDEFS_H_
#define _RADARDEFS_H_

#ifdef __cplusplus
extern "C" {
#endif

#define RADAR_ARRAY_SIZE    1000
#define NUM_WBUCKETS        256
#define MIL_1               0x100000    // Approx 1 million
#define MIL_1_SHIFT         20          // Bits to shift for multiply&divide
#define MIL_1_MASK          0xfff00000  // mask off lower 20 bits
#define KIL_1               1024
#define KIL_1_SHIFT         10
#define KIL_1_MASK          0xffffffc00  // mask off lower 10 bits
#define DELTA_USEC          50           // 10 microseconds margin for timestamp
#define DELTA_MAX           30000        // Maximum delta between two phy errors
#define PPS_ARRAY_SIZE      20
#define KIL_TO_FREQ(x)      (((x) * 1000) / KIL_1)

typedef struct genStruct {
    A_INT32 arraySize;
    A_INT32 count;
    A_INT32 value[RADAR_ARRAY_SIZE];
} GEN_ARRAY;

/*
 * Structure to hold the event array. Event time deltas are stored in the
 * circular array eStamp[].
 */
typedef struct event_struct {
    A_INT32 arraySize;                // max size of array
    A_INT32 count;                    // current no of events.
    A_INT32 eFirst;                   // first valid event
    A_INT32 eLast;                    // last valid event (can wrap around)
    A_INT32 totalDelta;               // time delta spanning across first to last
    A_INT32 eStamp[RADAR_ARRAY_SIZE]; // circular array for time deltas
    A_INT32 rssi[RADAR_ARRAY_SIZE];   // circular array for time rssi
    A_INT32 width[RADAR_ARRAY_SIZE];  // circular array for time pulse width
} EVENT_ARRAY;

/* Information about radar patterns */
typedef struct ppsArray {
    A_INT32 arraySize;
    A_INT32 count;
    struct ppsInfo {
        A_INT32 freq;               // value of pps
        A_INT32 totalNumPulses;     // burst size
        A_INT32 silentPeriod;       // scan rate in seconds
        A_INT32 minPulsesToDetect;  // minimum pulses required for +ve identification
        A_INT32 stepFrom;           // finer search from this pps
        A_INT32 stepIncr;           // with this increment
        A_INT32 stepTo;             // to this pps
        A_INT32 wideMargin;         // wide margin percentage * 1000 for first search, e.g. 5% = 50
        A_INT32 narrowMargin;       // narrow margin percentage * 1000 for finer search  
    } info[PPS_ARRAY_SIZE];
} PPS_ARRAY;

typedef struct radarInfoStruct {
    A_SEM_TYPE  radarTaskSemId;
    A_SEM_TYPE  radarDataSemId;
    A_BOOL      radarTaskInited;
    A_UINT32    radarTid;
    A_UINT32    radarTstamp;
    A_UINT32    prevLast;
    EVENT_ARRAY eArray;
    EVENT_ARRAY wevents;
    GEN_ARRAY   pulse1;
    A_UINT32    detectCount;
    A_UINT32    radarDropCount1;    // count of dropping too many phy per millisecond
    A_UINT32    radarDropCount2;    // count of dropping too many total samples in the array
    A_UINT32    wBuckets[NUM_WBUCKETS];
} RADAR_INFO;

#define NEXT_EVENT_INDEX(pArray, index) (((index + 1) >= (pArray)->arraySize) ? 0 : (index + 1))

#ifdef __cplusplus
}
#endif

#endif /* _RADARDEFS_H_ */
