/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/radarext.h#1 $
 *
 * Copyright (c) 2001-2003 Atheros Communications, Inc., All Rights Reserved
 */

#ifndef _RADAREXT_H_
#define _RADAREXT_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "radardefs.h"
#include "wlansme.h"
#include "wlandrv.h"

extern A_BOOL       radarReboot;
extern A_UINT32     radarScanTime;
extern A_SEM_TYPE   radarDataSemId;

void
recordRadarEvent(WLAN_DEV_INFO *pDev, A_UINT32 delta, A_UINT32 rssi, A_UINT32 width);

void
wakeupRadarEventHandler(WLAN_DEV_INFO *pDev);

void
initRadarDetect(WLAN_DEV_INFO *pDev);

void
hwRadarInit(WLAN_DEV_INFO *pDev);

void
etsiFeaturesEnable(WLAN_DEV_INFO *pDev);

#ifdef __cplusplus
}
#endif

#endif /* _RADAREXT_H_ */
