/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/stacserv.h#2 $
 *
 * Copyright © 2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * Connection Services
 */

#ifndef _STACSERV_H_
#define _STACSERV_H_

#ifdef __cplusplus
extern "C" {
#endif


/*
 * Debugging facility (crude)
 *
 * This is exported for now as some AP files use it.  We should move to a system
 * where each subsystem contains its own debugging trace facility based off of
 * a some generic, common facility.
 */
#ifdef DEBUG

extern int cservDebugLevel;

#define cservPrintf            if (cservDebugLevel) uiPrintf
#define cservPrintMacAddress   if (cservDebugLevel) printMacAddress
#define cservPrintSsid         if (cservDebugLevel) printSsid
#define cservPrintFlags        if (cservDebugLevel) wlanPrintFlags

#define cservL2Printf            if (cservDebugLevel == 2) uiPrintf
#define cservL2PrintMacAddress   if (cservDebugLevel == 2) printMacAddress
#define cservL2PrintSsid         if (cservDebugLevel == 2) printSsid
#define cservL2PrintFlags        if (cservDebugLevel == 2) wlanPrintFlags

#else /* DEBUG */

#define cservDebugLevel      0

#ifdef VXWORKS
#define cservPrintf(vargs...)
#define cservPrintMacAddress(vargs...)
#define cservPrintSsid(vargs...)
#define cservPrintFlags(vargs...)

#define cservL2Printf(vargs...)
#define cservL2PrintMacAddress(vargs...)
#define cservL2PrintSsid(vargs...)
#define cservL2PrintFlags(vargs...)
#else
#define cservPrintf(...)
#define cservPrintMacAddress(...)
#define cservPrintSsid(...)
#define cservPrintFlags(...)

#define cservL2Printf(...)
#define cservL2PrintMacAddress(...)
#define cservL2PrintSsid(...)
#define cservL2PrintFlags(...)
#endif

#endif /* DEBUG */

/* Define policy and other mnemonics */
#define CSERV_JOIN_CONFIGBSS        0x1 // Join configured BSS only
#define CSERV_JOIN_FIRSTBSS         0x2 // Join first BSS found
#define CSERV_JOIN_BESTSIGNAL       0x3 // Join BSS with best signal strength
#define CSERV_JOIN_BESTRATE         0x4 // Join BSS with best rate match
#define CSERV_JOIN_CONFIGSSID       0x5 // Join configured SSID with best signal strength

#define CSERV_OP_SCAN               0x1
#define CSERV_OP_JOIN               0x2
#define CSERV_OP_AUTH               0x4
#define CSERV_OP_ASSOC              0x8
#define CSERV_OP_REASSOC            0x10

/* State of what CS is doing right now */
#define CSERV_STATE_IDLE            0x0
#define CSERV_STATE_BKSCANNING      0x1
#define CSERV_STATE_OTHER_CHANNEL   0x2
#define CSERV_STATE_CONNECTING      0x4
#define CSERV_STATE_ROAMING         0x8


/* cserv11dHandler return codes */
#define CSERV_11D_NO_BSS_FOUND      0x0
#define CSERV_11D_COUNTRY_FOUND     0x1
#define CSERV_11D_NEW_COUNTRY_FOUND 0x2
#define CSERV_11D_MAX_SCAN          0x3
#define CSERV_11D_NOT_FOUND         0x4
#define CSERV_11D_START_ADHOC       0x5
#define CSERV_11D_JOIN_ADHOC        0x6
#define CSERV_11D_JOIN_NETWORK      0x7
#define CSERV_11D_SELECT_BSS        0x8

/* ccFinder data structure and return codes */
typedef struct ccbss {
    A_UINT32    count;
    A_UINT32    idx;
} BSS_TYPE;

typedef struct _ccfinder {
    A_UINT32    numBss;
    A_UINT16    num11a;
    A_UINT16    num11b;    
    CTRY_CODE   country_code;
    REG_DOMAIN  reg_dom;
    BSS_TYPE    bss11d;
    BSS_TYPE    bssAdHoc;
    BSS_TYPE    bssNo11d;
    A_BOOL      adHocFound;
    A_BOOL      ccFound;
    A_BOOL      implicitRd;
} CC_FINDER;

#define CCFINDER_NO_BSS                 0
#define CCFINDER_11D_FOUND              1
#define CCFINDER_IMPLICIT_RD_FOUND      2
#define CCFINDER_11D_NOT_FOUND          3


/*
 * Connection services, power management, tx rate adaptation, etc. run
 * off of a polling routine staPollFunction(). Define timer values for
 * all such services.
 *
 * staPollTimer provides a logical clock for rest of the timers.
 * CSERV_TIME_STAPOLL is period in milliseconds for staPollTimer. 100 ms works well.
 */
#define CSERV_TIME_STAPOLL           100     // in ms
#define SECS_TO_STAPOLL(x)           ((x) * 1000 / CSERV_TIME_STAPOLL)

/* The rest of the timers are defined as multiples of CSERV_TIME_STAPOLL */
#define CSERV_TIME_AUTOCONN          20      // 2 second period for checking connection status
#define CSERV_TIME_RATECHECK         10      // 1 second auto tx rate check period
#define CSERV_TIME_BKSCAN            5       // 400 ms background scan intervals

#define CSERV_TIME_SCANMIN_ACTIVE    80  //50      // ms for 1 Probe Response (2nd scan will get hidden SSIDs)
#define CSERV_TIME_SCANMAX_ACTIVE    135 //105     // ms maximum wait in active normal scan.
#define CSERV_TIME_SCANMIN_PASSIVE   135 //105     // ms for some chance of catching a beacon.
#define CSERV_TIME_SCANMAX_PASSIVE   135 //105     // ms maximum wait in passive normal scan
                                             // to collect slowest beacons
#define CSERV_TIME_BKSCANMAX_ACTIVE  80  //50      // ms to stay on other channel during active bk scan
#define CSERV_TIME_BKSCANMAX_PASSIVE 180 //150     // ms to stay on other channel during passive bk scan
#define CSERV_TIME_SCANLIMIT         3000    // upper limit for scanmax time & beacon period 3 seconds
#define CSERV_MAX_ATTEMPTS           6       // max of 6 auth-assoc attempts before giving up
#define CSERV_TIME_AA_MAX            1000    // max time for auth and assoc operations
#define CSERV_VALID_SCAN_TIME        120000  // 2 minutes. time to keep scan list valid in milliseconds
#define CSERV_DISCONNECT_TIMEOUT     100     // wait 10 seconds before reporting disconnect to OS
#define CSERV_INIT_DISCONNECT_TIME   1       // time to wait before indicating disconnected on driver load
#define CSERV_JOIN_BEACON_CNT        21       // max number of beacon intervals to wait while joining.

typedef struct cservInfoStruct {
    A_UINT32        joinPolicy;
    A_UINT32        apConnAttemptsMax;
    A_UINT32        apConnAttemptCur;
    A_INT32         cservPollInterval;
    A_INT32         cservPollCur;
    A_INT32         rateCheckInterval;
    A_INT32         rateCheckCur;
    A_INT32         scanBeforeSleepInterval;
    A_INT32         scanBeforeSleepCur;
    A_INT32         sleepBetweenScanInterval;
    A_INT32         sleepBetweenScanCur;
    A_INT32         bkScanInterval;
    A_INT32         bkScanCur;
    A_INT32         bkPowerReq;
    A_UINT32        cservOp;            // Bits to indicate which CS operation to do next.
    A_UINT32        cservState;         // state of CS, bkscan, normal scan, switching AP
    A_UINT32        opRetryScaleIndex;
    A_INT16         bkChannelIndex;
    A_INT16         bkChannelCnt;    
    CHAN_VALUES     *bkChannel;
    WLAN_SCAN_LIST  *bkScanList;    
    SCAN_INFO       scanInfo;           // Beacons received during scan
    SSID_ARRAY      desSsids;           // SSIDs to be joined after scan.
    A_INT32         disconnectInterval; // how long to wait before indicating media disconnect
    A_INT32         disconnectCur;
    A_UINT64        lastRxBeacons;      // used to keep track of the AP at the fringe
    A_UINT16        bss11d11aIdx;       // BSS index to 802.11a's 802.11d
    A_UINT16        bss11d11bIdx;       // BSS index to 802.11a's 802.11d
    A_BOOL          isScanCycleComplete;
    A_BOOL          scanPending;        // whether a bg scan is waiting for traffic to die down
    A_BOOL          hiddenScan;         // whether current scan is only for hidden SSIDs
    A_BOOL          resetScanBeforeSleep; // used to reset the scanBeforeSleep timer
    A_BOOL          cservForcedSleep;   // conn servs in deep sleep between long scans
    A_BOOL          cservFakeSleep;     // conn servs in fake sleep for background scan
    A_BOOL          wasDisassociated;
    A_UINT32        lastActivityTime;   // used to stave off background scanning
    A_BOOL          isScanRunDone;
    A_INT32         statusPollInterval;
    A_INT32         statusPollCount;
} CSERV_INFO;

/*
 * ENUMERATED TYPES
 */

/*
 * Definition of AdhocBand registry field is copied from src\sta\ndis\stacfg\stacfg.h
 * Should go into a shared include file later.
 */
enum ATH_ADHOCBAND {
    ATH_ADHOCBAND_BONLY,
    ATH_ADHOCBAND_AONLY,
    ATH_ADHOCBAND_TONLY,            // 11a Turbo
    ATH_ADHOCBAND_GONLY,            // 11g
    ATH_ADHOCBAND_108GONLY,         // 11g Turbo    
    ATH_ADHOCBAND_NONE,
    ATH_ADHOCBAND_END
};

typedef enum {
    SCAN_NOW,
    SCAN_WHEN_IDLE
} BKSCAN_ENUM;

/*
 * FUNCTION PROTOTYPES
 */

MLME_RESULT
cservAssociate(WLAN_DEV_INFO *pdevInfo, A_UINT32 assocTimeout, A_UINT32 listenInterval);

MLME_RESULT
cservDeauthenticate(WLAN_DEV_INFO *pdevInfo);

MLME_RESULT
cservScan(WLAN_DEV_INFO *pdevInfo, SCANTYPE scanType, A_UINT32 extraOps, A_BOOL hiddenOnly);

MLME_RESULT
cservJoin(WLAN_DEV_INFO *pdevInfo);

MLME_RESULT
cservStartAdhoc(WLAN_DEV_INFO *pDevInfo, SSID *pSsid, BSSDESCR_SET *pBssSet);

MLME_RESULT
cservAuthAssoc(WLAN_DEV_INFO *pDevInfo);

MLME_RESULT
cservScanJoinAuthAssoc(WLAN_DEV_INFO *pDevInfo, SCANTYPE scanType, A_BOOL hiddenOnly);

MLME_RESULT
cservBkScan(WLAN_DEV_INFO *pdevInfo, CHAN_VALUES *pChval, SCANTYPE scanType);

MLME_RESULT
cservBkScanAll(WLAN_DEV_INFO *pDevInfo, BKSCAN_ENUM scanType);

void
cservInit(WLAN_DEV_INFO *pDev);

A_INT32
cserv11dHandler(WLAN_DEV_INFO *pDevInfo, BSSDESCR_SET *pbssSet);

A_INT32
cservSelectBss(WLAN_DEV_INFO *pDevInfo, BSSDESCR_SET *pbssSet, BSSTYPE bssType,
               SSID_ARRAY *pSsids, BSSID *pBssid, A_UINT32 minRssi);

MLME_RESULT
cservSwitchAP(WLAN_DEV_INFO *pdevInfo, BSSDESCR *pbssDescr);

#ifndef BUILD_AP
#define IS_WZC_ACTIVE(p)            (p)->pOSHandle->wzcActive
#define GET_CONNECTION_STATUS(p)    (p)->pOSHandle->connectionStatus
#define SET_SSID_COUNT(p, cnt)      (p)->pOSHandle->ssids.count = cnt
#ifndef OID_802_11_SSID
#if !defined(MDK_BUILD) && !defined(Linux)
#error ntddndis.h from Windows XP DDK required.
#endif /* BUILD_AP */
#endif /* MDK_BUILD */
#else
#define IS_WZC_ACTIVE(p)            FALSE
#define GET_CONNECTION_STATUS(p)    (p)->pOSHandle->flags
#define SET_SSID_COUNT(p, cnt)
#define powerSetResyncToBeacon(p)   (p)->powerMgmt.needResyncToBeacon = TRUE
#endif /* !BUILD_AP */

MLME_RESULT
cservSwitchSsid(WLAN_DEV_INFO *pdevInfo, SSID_ARRAY *pSsids, A_BOOL fromWzc);

void
cservStopBss(WLAN_DEV_INFO *pDev, DISCONNECT_ENUM discMode,
             REMOVE_BSS_ENUM removeBss, SEND_DEAUTH_ENUM sendDeauth);

void
cservPollReset(WLAN_DEV_INFO *pDevInfo);

void
cservBmissNotify(WLAN_DEV_INFO *pDevInfo);

void
cservPollFunction(WLAN_DEV_INFO *pDevInfo);

void
cservSelectAdhocChannel(WLAN_DEV_INFO *pDevInfo, CSERV_INFO *pCsInfo);

void
cservCreateAdhocBssid(WLAN_DEV_INFO *pDevInfo, WLAN_MACADDR *pMacaddr);

void
txRateFree(void);

void
cservOperationCancel(WLAN_DEV_INFO *pDevInfo);

#define ADHOC_2STA_B4_CONNECTED

#ifndef ADHOC_2STA_B4_CONNECTED
#define cservAdHocTrafficReceived
#else
void
cservAdHocTrafficReceived(WLAN_DEV_INFO *pDev);
#endif

void
cservStartDisconnectTimer(WLAN_DEV_INFO *pDev);

void
cservClearDisconnectTimer(WLAN_DEV_INFO *pDev);

void
cservUpdateLastActivityTime(WLAN_DEV_INFO *pDev);

A_UINT32
cservAdHocBand2Wmode (A_UINT16 adhocBand);
    
A_BOOL
cservChooseApAndSwitch(WLAN_DEV_INFO *pDev, A_UINT32 rssiToBeat);

void
cservNearbyApReport(WLAN_DEV_INFO *pDev, A_UINT16 channel,
                    WLAN_MACADDR *pBssid, SSID *pSsid);
 

#ifdef __cplusplus
}
#endif

#endif /* _STACSERV_H_ */


