/*
 *  Copyright (c) 2000-2002 Atheros Communications, Inc., All Rights Reserved
 *
 *  $Header: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/trace.h#1 $
 */

#ifndef _INC_TRACE_H_
#define _INC_TRACE_H_

#ifndef NDEBUG                    /* AP debug image */
// #define INCLUDE_TRACE
// #define TRACEBUF
#endif

#ifdef BUILD_AP
#ifdef INCLUDE_TRACE

/* Data types for event logging library */

#define MAX_EVENTS      512
#define N_EVENT_ARGS    4       /* enough for now */

/*
 *  The event record
 */
struct event_s {
    A_UINT16    subSys:15,
                wasAlloced:1;
    A_UINT16    eventID;
    char        *msg;
    union {
        A_UINT32 word;
        void    *ptr;
    } arg[N_EVENT_ARGS];
    A_UINT32    time;
    A_UINT32    totalCount;
};

/*
 *  Subsystem list
 */
typedef enum {
    SUBSYS_INVALID = 0,
    SUBSYS_WLANTX,
    SUBSYS_WLANRX,
    SUBSYS_WLANINTR,
    SUBSYS_WLANKEY,
    N_SUBSYS
} evSubSystem;

/*
 *  WLAN TX (including software retry) events
 */
#define EV_TX_NOMEM             (0<<8 | 1)
#define EV_TX_NODUPREQ          (3<<8 | 2)
#define EV_TX_DUPREQ            (3<<8 | 3)
#define EV_TX_PKTOK             (3<<8 | 4)
#define EV_TX_XSR               (3<<8 | 5)
#define EV_TX_FILTER            (3<<8 | 6)
#define EV_TX_FILTNEEDCDM       (3<<8 | 7)
#define EV_TX_XSRDROP           (3<<8 | 8)
#define EV_TX_NORSRC            (3<<8 | 9)
#define EV_TX_QDOK              (3<<8 | 10)
#define EV_TX_CDM               (3<<8 | 11)
#define EV_TX_RETRYQFLUSH       (3<<8 | 12)
#define EV_TX_MUSTEAT           (3<<8 | 13)
#define EV_TX_TXDITER           (3<<8 | 14)
#define EV_TX_NOFRAME           (0<<8 | 15)
#define EV_TX_SQUASH            (3<<8 | 16)
#define EV_TX_Q                 (2<<8 | 17)

/*
 *  WLAN Rx events
 */
#define EV_RX_OK                (4<<8 | 1)
#define EV_RX_ERR               (4<<8 | 2)
#define EV_RX_SIBFIND           (1<<8 | 3)
#define EV_RX_OVF               (2<<8 | 4)
#define EV_RX_EOLREC            (1<<8 | 5)

extern void eventPost(A_UINT32 subSys, A_UINT16 num, char *str, ...);
extern void eventPost_Alloc(A_UINT32 subSys, UINT16 num, char *str, ...);
extern void eventDump(A_UINT32 subSys, int count);
extern void eventDisplayFuncRegister(A_UINT32, void (*)());
extern void eventImmed(A_UINT32 subSys, int on);
extern void eventLibInit(void);

#else
#define eventPost(s, n, str, args...)
#define eventPost_Alloc(s, n, str, args...)
#define eventDump(s, n)
#define eventDisplayFuncRegister(n, func)
#define eventLibInit()
#define eventDumpAll()

#endif
#endif


#if defined(BUILD_AP) && defined(TRACEBUF)

#define TRACEBUF_SIZE   128
#define TRACEBUF_MASK   (TRACEBUF_SIZE - 1)

struct atherosDesc;
typedef struct {
    A_UINT32 _startAt, _doneAt;
    struct atherosDesc* _desc;
    A_BOOL _powersave;
    int _size;
    int _completionCode;
} TRACEBUF_EVENT;

#define TRACEBUF_DEFINE(_name)                                                          \
    TRACEBUF_EVENT tracebuf##_name[TRACEBUF_SIZE];                                      \
    int tracebufIdx##_name;

#define TRACEBUF_PRINT(_log, _msg)                                                      \
{                                                                                       \
    uiPrintf("%06d: %p %s @ %06d (%04db with 0x%02x)%s\n",                              \
            (_log)->_startAt, (_log)->_desc, _msg, (_log)->_doneAt,                     \
            (_log)->_size, (_log)->_completionCode,                                     \
            (_log)->_powersave ? " [ps]" : "");                                         \
}

#define TRACEBUF_INIT(_name, _pSib)                                                     \
{                                                                                       \
    (_pSib)->tracebufIdx##_name = 0;                                                    \
}

#define TRACEBUF_LOG_START(_name, _pSib)                                                \
{                                                                                       \
    if (_pSib) {                                                                        \
        TRACEBUF_EVENT *pLog                                                            \
            = &((_pSib)->tracebuf##_name[(_pSib)->tracebufIdx##_name++]);               \
                                                                                        \
        (_pSib)->tracebufIdx##_name &= TRACEBUF_MASK;                                   \
        pLog->_startAt = A_MS_TICKGET();                                                \
        pLog->_desc = NULL;                                                             \
        pLog->_powersave = FALSE;                                                       \
        pLog->_doneAt = 0;                                                              \
        pLog->_completionCode = 0;                                                      \
    }                                                                                   \
}

#define TRACEBUF_LOOKUP(_pLog, _name, _pSib, _cond)                                     \
{                                                                                       \
    if (_pSib) {                                                                        \
        int n = ((_pSib)->tracebufIdx##_name + TRACEBUF_MASK) & TRACEBUF_MASK;          \
                                                                                        \
        while (TRUE) {                                                                  \
            if ((_pSib)->tracebuf##_name[n]._cond) {                                    \
                _pLog = &((_pSib)->tracebuf##_name[n]);                                 \
                break;                                                                  \
            }                                                                           \
            if (n == (_pSib)->tracebufIdx##_name) {                                     \
                break;                                                                  \
            }                                                                           \
            n = (n + TRACEBUF_MASK) & TRACEBUF_MASK;                                    \
        }                                                                               \
    }                                                                                   \
}

#define TRACEBUF_LOG(_name, _pSib, _cond, _log)                                         \
{                                                                                       \
    TRACEBUF_EVENT *pLog = NULL;                                                        \
                                                                                        \
    TRACEBUF_LOOKUP(pLog, _name, _pSib, _cond);                                         \
    if (pLog) {                                                                         \
        pLog->_log;                                                                     \
    }                                                                                   \
}

#define TRACEBUF_LOG_DONE(_name, _pSib, _cond, _log)                                    \
{                                                                                       \
    TRACEBUF_EVENT *pLog = NULL;                                                        \
                                                                                        \
    TRACEBUF_LOOKUP(pLog, _name, _pSib, _cond);                                         \
    if (pLog) {                                                                         \
        pLog->_doneAt = A_MS_TICKGET();                                                 \
        pLog->_log;                                                                     \
    }                                                                                   \
}

extern int tbDump(int assocId, int count);

#else
#define TRACEBUF_DEFINE(_name)
#define TRACEBUF_PRINT(_log, _msg)
#define TRACEBUF_INIT(_name, _pSib)
#define TRACEBUF_LOG_START(_name, _pSib)
#define TRACEBUF_LOOKUP(_pLog, _name, _pSib, _cond)
#define TRACEBUF_LOG(_name, _pSib, _cond, _log)
#define TRACEBUF_LOG_DONE(_name, _pSib, _cond, _log)

#define tbDump(assocId, count)
#endif

#ifdef DEBUG_PKT_LOG
void logEventGetHeader(A_UINT32 *len, A_UINT32 *logVer);

void logEventGet(A_UINT32 *len, A_UINT32 *maxCnt, A_UINT32 *currIdx,
                 A_UINT32 getIdx, void *data);
void logEventClear(void);
void logEventDelete(void);
void logEventRxPkt(A_UINT32 length, A_UINT32 rate, A_UINT32 rssi,
        A_UINT32 frameType, A_UINT32 seqNum, A_UINT32 status, A_UINT32 antRx,
        A_UINT16 timeStamp);
void logEventTxPkt(A_UINT32 length, A_UINT32 rate, A_UINT32 ackRssi,
        A_UINT32 retries, A_UINT32 status, A_UINT32 frameCtrl, A_UINT32 seqCtrl,
        A_UINT32 antTx, A_UINT16 timeStamp);
#endif

#endif /*  _INC_TRACE_H_ */
