/*
 * Copyright (c) 2000-2004 Atheros Communications, Inc., All Rights Reserved
 *
 * Definitions for core driver
 * This is a common header file for usb stub
 */

#ifndef	__USBSTUB_H
#define	__USBSTUB_H

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

VOID
athUsbRecvIndication(IN  void     *pStubHandle,
                     IN  A_UINT8   epNum,
                     IN  A_UINT8  *buffer,
                     IN  A_UINT32  bytesReceived);

VOID
athUsbSendConfirm(IN  void     *pStubHandle,
                  IN  A_UINT8   epNum,
                  IN  A_UINT8  *buffer,
                  IN  A_UINT32  bytesSent);

VOID
athUsbStatusIndication(IN  void     *pStubHandle,
                       IN  A_UINT32  status);

VOID 
athConvertChanValue(IN   CHAN_VALUES     *pChannel,
                   OUT  A_UINT16        *pChannelBand,
                   OUT  CHANNEL_FREQ    *pChannelFrequency,
                   OUT  PHY_MODS        *pPhyModulations);

VOID
randomInit(A_UINT32 seed);
/********************************************************************************/
/*
 * (LW)
 * !!! Please attention !!!
 * All the following function should be remove after we implement
 * all stub layer WDC call, we just put those function on here to
 * let our complier happy for NDIS_WDM project.
 */
#if NDIS_WDM

#define __WLAN_DEV_INFO struct wlanDevInfo
#define HACK_TO_PARDEV(pDev) ((struct ArDevInfo *)   pDev)

/* Forward Definition - Keep the compiler happy */
struct ArDevInfo;

void
athAttachRateTables(WLAN_DEV_INFO *pDev);

typedef enum {
    UPDATE_SW_COMMON = 1,
    UPDATE_SW_ALL,
    GET_CCA_PERCENTAGE,
    CLEAR_ALL_COUNTERS
} HAL_MIB_CMD;

typedef enum {
    SET_NOISE_IMMUNITY_LEVEL = 1,
    SET_OFDM_WEAK_SIGNAL_DETECTION,
    SET_CCK_WEAK_SIGNAL_THR,
    SET_FIRSTEP_LEVEL,
    SET_SPUR_IMMUNITY_LEVEL
} HAL_ANI_CMD;

/*
 * NOTE WELL:
 * These are mapped to take advantage of the common locations for many of
 * the bits on all of the currently supported MAC chips. This is to make the ISR
 * as efficient as possible, while still abstracting HW differences. When new
 * hardware breaks this commonality this enumerated type, as well as the HAL
 * functions using it, must be modified. All values are directly mapped unless
 * commented otherwise.
 */
typedef enum HalIntType {
    HAL_INT_RX      = 0x00000001,   /* Non-common mapping */
    HAL_INT_RXEOL   = 0x00000010,
    HAL_INT_RXORN   = 0x00000020,
    HAL_INT_TX      = 0x00000040,   /* Non-common mapping */
    HAL_INT_TXDESC  = 0x00000080,   /* Non-common mapping */
    HAL_INT_TXURN   = 0x00000800,
    HAL_INT_MIB     = 0x00001000,
    HAL_INT_RXPHY   = 0x00004000,   /* Never really used as we get a RXERR interrupt also */
    HAL_INT_RXKCM   = 0x00008000,
    HAL_INT_SWBA    = 0x00010000,
    HAL_INT_BMISS   = 0x00040000,
    HAL_INT_BNR     = 0x00100000,   /* Non-common mapping */
    HAL_INT_BCNMISC = 0x00800000,   /* Venice, 'or' of misc beacon bits from ISR_S2 */
    HAL_INT_GPIO    = 0x01000000,

    /* The following are special values which don't map directly to ISR bits */
    HAL_INT_DTIM    = 0x20000000,   /* Virtual map of DTIM interrupt in ISR_S2 */
    HAL_INT_FATAL   = 0x40000000,   /* Non-common mapping */
    HAL_INT_GLOBAL  = 0x80000000,   /* To set/clear IER. Don't combine with other ints. */

    HAL_INT_COMMON  =  (HAL_INT_RXEOL | HAL_INT_RXORN | HAL_INT_TXURN | HAL_INT_MIB   |
                        HAL_INT_RXKCM | HAL_INT_SWBA  | HAL_INT_BMISS | HAL_INT_GPIO  |
                        HAL_INT_RXPHY),
    HAL_INT_INVALID = ~(HAL_INT_RX    | HAL_INT_RXEOL | HAL_INT_RXORN | HAL_INT_TX    |
                        HAL_INT_TXDESC| HAL_INT_TXURN | HAL_INT_MIB   | HAL_INT_RXKCM | 
                        HAL_INT_SWBA  | HAL_INT_BMISS | HAL_INT_BNR   | HAL_INT_GPIO  | 
                        HAL_INT_FATAL | HAL_INT_RXPHY | HAL_INT_GLOBAL),
    HAL_INT_NOCARD  = 0xffffffff    /* To signal that the card has been removed */
} HAL_INT_TYPE;

enum halPowerModes {
    AWAKE,
    FULL_SLEEP,
    NETWORK_SLEEP
};

#define MAX_TX_POWER 0xffffffff


A_UINT32
halMibControl(__WLAN_DEV_INFO *pDev, HAL_MIB_CMD cmd);

A_STATUS
halPhyDisable(struct ArDevInfo *pArDev);

void
halReleaseTxQueue(struct ArDevInfo *pDev, int queueNum);

void
halGpioCfgOutput(__WLAN_DEV_INFO *pDev, A_UINT32 gpio);

A_UINT32
halGpioGet(__WLAN_DEV_INFO *pDev, A_UINT32 gpio);

void
halGpioSet(__WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 val);

void
halGpioSetIntr(__WLAN_DEV_INFO *pDev, A_UINT32 gpio, A_UINT32 ilevel);

A_UINT32
halGetRandomSeed(__WLAN_DEV_INFO *pDev);

void
halAniControl(__WLAN_DEV_INFO *pDev, HAL_ANI_CMD cmd, int param);

/* Key Cache Functions */
A_UINT32
halGetKeyCacheSize(__WLAN_DEV_INFO *pDev);

void
halResetKeyCache(__WLAN_DEV_INFO *pDev);

void
halResetKeyCacheEntry(__WLAN_DEV_INFO *pDev, A_UINT16 keyCacheIndex);

void
halSetKeyCacheEntry(__WLAN_DEV_INFO *pDev, A_UINT16 keyCacheIndex,
                    WLAN_MACADDR *pMacAddr, struct WlanPrivStruct *pWlanPrivRecord,
                    A_BOOL bXorKey);

void
halKeyCacheFree(__WLAN_DEV_INFO *pDev, A_UINT16 hwIndex);

/* Power Management Functions */
A_STATUS
halSetPowerMode(struct ArDevInfo *pArDev, A_UINT32 powerRequest, A_BOOL setChip);

A_UINT32
halGetPowerMode(struct ArDevInfo *pArDev);

A_BOOL
halGetPowerStatus(struct ArDevInfo *pArDev);


void
halEnableInterrupts(struct ArDevInfo *pArDev, HAL_INT_TYPE ints);

void
halDisableInterrupts(struct ArDevInfo *pArDev, HAL_INT_TYPE ints);


#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __usbstub.h */
