
/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/vport.h#1 $
 *
 * This file contains the information that is common for all virtual ports.
 *
 * Copyright  2000-2003 Atheros Communications, Inc.,  All Rights Reserved.
 */


#ifndef _VPORT_H_
#define _VPORT_H_

#ifdef __cplusplus
extern "C" {
#endif

typedef enum Vport_cmd {
    VPORT_STOP = 0,
    VPORT_START,
    VPORT_IF_UP,
    VPORT_IF_DOWN
} VPORT_CMND;

typedef struct Vport_cmn {
    OS_DEV_INFO *pOSHandle;
    VPORT_TYPE vport_type;
    A_UINT32   phyDevNo;
    A_UINT32   vportNum;    /* Virtual Port Number  */
    A_UINT32   vportDevNo;  /* Virtual Port Devno - for the OS */
    void       *pPhyPort;   /* The physical port handle */
    VPORT_CNTR  vportCntr;
} VPORT_CMN;

typedef struct Vport_param_cmn {
    VPORT_TYPE  vport_type;
    A_UINT32    phyDevNo;    /* Physical Port Device Number */
    A_UINT32    vportNum;  /* Virtual Port Number */
} VPORT_PARAM_CMN;

/*
 * The parametr index table is used to communicated information to the Load Function
 * The virtual port number and physical device number are passed as arguments to the
 * Load function via the init string.
 */
#define VPORT_PARAM_IDX(p,v)  ((p)*MAX_VPORT_WDS_NUM+(v))



#ifdef __cplusplus
}
#endif

#endif /* _VPORT_H_ */
