/*
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/vxdrv.h#1 $
 *
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * vxWorks specific function wrappers.
 */

#include "apdefs.h"

#ifndef __INCvxdrvh
#define __INCvxdrvh

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "config.h"
#include "cacheLib.h"
#include "taskLib.h"
#include "sysLib.h"
#include "netLib.h"
#include "inetLib.h"
#include "tickLib.h"
#include "intLib.h"
#include "logLib.h"
#include "stat.h"
#include "ioLib.h"
#ifdef DEBUG
#include "dbgLib.h"
#endif

extern int netJobRegister(FUNCPTR routine, void *param);
#if !NETDEVS_POLLED
extern void netJobActivate(int index);
#endif

#define A_DRIVER_MALLOC(a)              (malloc(a))
#define A_DRIVER_FREE(a, b)             (free(a))
#define A_MEM_SET(addr, value, size)    memset((char *)(addr), (int)(value), (int)(size))
#define A_MEM_ZERO(addr, size)          bzero((char *)(addr), (int)(size))
#define A_DRIVER_BCOPY(from, to, len)   bcopy((char *)(from), (char *)(to), (int)(len))
#define A_BCOPY(a, b, n)                bcopy((char *)(a), (char *)(b), (int)(n))
#define A_BCOMP(p1, p2, n)              bcmp((char *)(p1), (char *)(p2), (int)(n))

/*
 * Words (16b) should be aligned correctly on all platforms, so it
 * can be used even on platforms (mips) with strict alignment
 * requirements.
 */
#define A_MACADDR_COPY(from, to)              \
    do {                                      \
        (to)->words[0] = (from)->words[0];    \
        (to)->words[1] = (from)->words[1];    \
        (to)->words[2] = (from)->words[2];    \
    } while (0)

#define A_MACADDR_COMP(m1, m2)                \
    ((((m1)->words[2] == (m2)->words[2]) &&   \
      ((m1)->words[1] == (m2)->words[1]) &&   \
      ((m1)->words[0] == (m2)->words[0])) == 0)

/* Satisfy overly-picky compilers */
#define CONTRIVED_REFERENCE(target) \
    if (0) {                   \
        target;                \
    }


/*
 * Get the number of millisecond ticks since the system was started.
 *
 * For the AP, absolute accuracy is not all that important.  Use
 * an approximation of the conversion of ticks @ 60Hz to that does
 * not require any expensive math (multiply or divide).
 *
 * 60 ticks -> 997ms, or a 0.3% shortfall error, although there are
 * cases where the error is worse.
 *
 * vxAbsTicks.lower the same as getTick().
 */
static INLINE A_UINT32
A_MS_TICKGET(void)
{
#if !VXWORKS55 && (SYS_CLK_RATE == 60)
    A_UINT32 ts = *(volatile A_UINT32 *)(&vxAbsTicks.lower);
    CONTRIVED_REFERENCE(A_MS_TICKGET());
    return (ts << 4) + (ts >> 1) + (ts >> 3);
#else
    A_UINT32 ts = (A_UINT32)(tickGet());
    return ts;
#endif
}

#define ATH_OSPKTREF_DUP(_pOrig, _pDup)
#define ATH_OSPKTREF_FREE(_pDesc)

#define ATH_OSBUFREF_DUP(_pOrig, _pDup)     do {            \
    if ((_pOrig)->pOSDescPtr) {                             \
        (_pOrig)->pOSDescPtr->clRefCnt++;                   \
        (_pDup)->pOSDescPtr = (_pOrig)->pOSDescPtr;         \
    }                                                       \
} while (0)

/*
 * Define isrPrintf() for printing from ISR context.  Things are different
 * for the AP and NDIS drivers, hence the following somewhat-less-than-elegant
 * solution until we have a common, comprehensive tracing facility.
 */
#define isrPrintf                   logMsg

/* Timer macros */

#define A_INIT_TIMER(pd, pt, pf, rep)   (drvVxTimerInit(pd, pt, pf, rep)) 
#define A_TIMEOUT(pt, per, par, op)     (drvVxTimerSet(pt, per, par, op))
#define A_UNTIMEOUT(pt)                 (drvVxTimerCancel(pt))
#define A_DELETE_TIMER(pt)              (drvVxTimerDelete(pt)) 

#define udelay                      sysUDelay
#define FIELD_OFFSET(type, field)   ((int)(&((type *)0)->field))

/* Allow dynamic disabling/enabling of assertions */
extern int asserts; // defined in wlanglobal.c
#define ASSERT(x) if (asserts) assert(x)

#define A_STRCPY    strcpy
#define A_STRNCPY   strncpy
#define A_STRLEN    strlen
#define A_STRCMP    strcmp
#define A_STRNCMP   strncmp
#define A_RAND      rand

/*
 * Locking macros
 */
#define CREATE_LOCKED   1
#define CREATE_UNLOCKED 0
#ifdef DEBUG
#define A_SEM_INIT(sem_val, sem_type, make_locked)      \
    do { \
        (sem_val) = semBCreate((sem_type), (make_locked) ? SEM_EMPTY : SEM_FULL); \
         if ((sem_val) == NULL) \
            apPanic("Could not allocate lock."); \
    } while (0)
#else
#define A_SEM_INIT(sem_val, sem_type, make_locked)      \
    do { \
        (sem_val) = semBCreate((sem_type), (make_locked) ? SEM_EMPTY : SEM_FULL); \
         if ((sem_val) == NULL) \
            uiPrintf("Could not allocate lock."); \
    } while (0)
#endif /* not DEBUG */

#define A_SEM_VALID(_sem)           ((_sem) != NULL)
#define A_SEM_LOCK(sem, timeout)    semTake(sem, timeout)
#define A_SEM_UNLOCK(sem)           semGive(sem)
#define A_SEM_DELETE(_sem)          do { \
    if (_sem) { \
        semDelete(_sem); \
        _sem = NULL; \
    } \
} while (0)

#define A_SIB_TAB_LOCK(sibTab)      semTake(sibTab->sibTableSem, WAIT_FOREVER)
#define A_SIB_TAB_UNLOCK(sibTab)    semGive(sibTab->sibTableSem)
#define A_SIB_ENTRY_LOCK(sib)       do {    \
    semTake(sib->sibLock, WAIT_FOREVER);    \
    ASSERT(sib->used & SIB_VALID);          \
} while (0)
#define A_SIB_ENTRY_UNLOCK(sib)     semGive(sib->sibLock)

#define A_TASK_LOCK()   taskLock()
#define A_TASK_UNLOCK() taskUnlock()

/*
 * Cache flushing and virtual address translation support.  vxWorks macros
 * handle things cleanly but with some overhead, so optimize for supported
 * platforms.
 *   - A_DATA_() routines are for frame data buffers.
 *   - A_DESC_() macros are for DMA descriptors.  Currently
 *     hardware descriptors are cached as they share memory
 *     with the software frame description.
 *
 * SWCOHERENCY   - descriptors and data are cached
 * SWCOHERENCYWB - SWCOHERENCY with a write back cache
 *
 * Systems with cache line sizes larger than 16 bytes need
 * to access the descriptor uncached as cache flushing is
 * not practical with the DMA control and status on the same
 * cache line.
 */
#if defined(AR531X) 
/*
 * AR531X uses a write back cache, with it's own lower overhead
 * cache invalidation routine.  V != P, but upper bits are
 * ignored by the DMA bus so a null V2P/P2V macros are used.
 */
#define SWCOHERENCY
#include "ar531x.h"
#define A_DATA_CACHE_INVAL(addr, len)   cacheDataInvalidate(addr.ptr, (len))
#define A_DATA_CACHE_FLUSH(addr, len)
#define A_DATA_V2P(addr)                ((A_UINT32)(addr))
#define A_DATA_P2V(addr)                (addr)
#define A_DESC_CACHE_INVAL(addr)        cacheDescInvalidate((void *)(&(addr)->hw.word[2]))
#define A_DESC_CACHE_FLUSH(addr)
#define A_DESC_V2P(addr)                ((A_UINT32)(addr))
#define A_DESC_P2V(addr)                (addr)
#define A_PIPEFLUSH()                   sysWbFlush()

#elif defined(PPC8240) || (USER_D_CACHE_MODE & CACHE_SNOOP_ENABLE)
/*
 * MPC8245 is a fully coherent writeback cache with V==P.
 */
#define A_DATA_CACHE_INVAL(addr, len)
#define A_DATA_CACHE_FLUSH(addr, len)
#define A_DATA_V2P(addr)                ((A_UINT32)(addr))
#define A_DATA_P2V(addr)                (addr)
#define A_DESC_CACHE_INVAL(addr)
#define A_DESC_CACHE_FLUSH(addr)
#define A_DESC_V2P(addr)                ((A_UINT32)(addr))
#define A_DESC_P2V(addr)                (addr)
#define A_PIPEFLUSH()

#elif defined (AR_PB32)
#define SWCOHERENCY
#include "pb32.h"
#define A_DATA_CACHE_INVAL(addr, len)   cacheDataInvalidate(addr.ptr, (len))
#define A_DATA_CACHE_FLUSH(addr, len)
#define A_DATA_V2P(addr)                ((A_UINT32)(CACHE_DRV_VIRT_TO_PHYS(&cacheDmaFuncs, addr)))
#define A_DATA_P2V(addr)                ((void *)PHYS_TO_K0(addr))
#define A_DESC_CACHE_INVAL(addr)        cacheDescInvalidate((void *)(&(addr)->hw.word[2]))
#define A_DESC_CACHE_FLUSH(addr)
#define A_DESC_V2P(addr)                ((A_UINT32)A_DATA_V2P(addr))
#define A_DESC_P2V(addr)                ((void *)PHYS_TO_K0(addr))
#define A_PIPEFLUSH()                   sysWbFlush()

#elif defined(CACHE_PROTO_COPYBACK) || (USER_D_CACHE_MODE & CACHE_COPYBACK)
/*
 * Sample writeback cache implementation keeping the desc/buffers in
 * the cached.  This code has not been tested, so it is not enabled
 * by default.
 */
#define SWCOHERENCY
#define SWCOHERENCYWB
#define A_DATA_CACHE_INVAL(addr, len)   CACHE_USER_INVALIDATE(addr, len)
#define A_DATA_CACHE_FLUSH(addr, len)   CACHE_USER_FLUSH(addr, len)
#define A_DATA_V2P(addr)                ((A_UINT32)CACHE_DRV_VIRT_TO_PHYS(&cacheUserFuncs, addr))
#define A_DATA_P2V(addr)                CACHE_DRV_PHYS_TO_VIRT(&cacheUserFuncs, addr)
#define A_DESC_CACHE_INVAL(addr)        A_DATA_CACHE_INVAL(addr, 32)
#define A_DESC_CACHE_FLUSH(addr)        A_DATA_CACHE_FLUSH(addr, 32)
#define A_DESC_V2P(addr)                A_DATA_V2P(addr)
#define A_DESC_P2V(addr)                A_DATA_P2V(addr)
#define A_PIPEFLUSH()                   CACHE_PIPE_FLUSH()

#else

/*
 * Sample code to use cacheDmaAlloc() which is uncached on non-coherent
 * platforms.  This is the default case for non-coherent copyback
 * caches.  This code has not been extensively tested, but should
 * be safe on most platforms.
 */
#define VX_CACHE_DMA_MALLOC
#define SWCOHERENCY
#define A_DATA_CACHE_INVAL(addr, len)   CACHE_DRV_INVAL(&cacheDmaFuncs, addr, len)
#define A_DATA_CACHE_FLUSH(addr, len)   CACHE_DRV_FLUSH(&cacheDmaFuncs, addr, len)
#define A_DATA_V2P(addr)                ((A_UINT32)CACHE_DRV_VIRT_TO_PHYS(&cacheDmaFuncs, addr))
#define A_DATA_P2V(addr)                CACHE_DRV_PHYS_TO_VIRT(&cacheDmaFuncs, addr)
#define A_DESC_CACHE_INVAL(addr)        A_DATA_CACHE_INVAL(addr, 32)
#define A_DESC_CACHE_FLUSH(addr)        A_DATA_CACHE_FLUSH(addr, 32)
#define A_DESC_V2P(addr)                A_DATA_V2P(addr)
#define A_DESC_P2V(addr)                A_DATA_P2V(addr)
#define A_PIPEFLUSH()                   CACHE_PIPE_FLUSH()

#endif /* PLATFORM */

#ifdef __cplusplus
}
#endif

#endif /* not __INCvxdrvh */
