/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * This file contains the function prototypes, helpful macros and data
 * structure declarations specific to the wlan device functions.  It is the
 * same for both the station and access point.
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/wlanDev.h#1 $
 */

#ifndef _WLAN_DEV_H_
#define _WLAN_DEV_H_

#ifdef __cplusplus
extern "C" {
#endif

A_STATUS
wlanDevInit(WLAN_DEV_INFO *, WLAN_SERVICE);

A_STATUS
wlanDevStart(WLAN_DEV_INFO *, WLAN_SERVICE);

void
wlanDevStop(WLAN_DEV_INFO *);

void
wlanDevRelease(WLAN_DEV_INFO *);

A_STATUS
wlanDevReset(WLAN_DEV_INFO *, WLAN_SERVICE, CHAN_VALUES *, A_BOOL, A_BOOL);

A_BOOL
wlanDevPresent(WLAN_DEV_INFO *);


#ifdef __cplusplus
}
#endif

#endif /* _WLAN_DEV_H_ */
