/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * This file contains the function prototypes, helpful macros and data
 * structure declarations specific to the transmit functions.  It is the
 * same for both the station and access point.
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/wlanReceive.h#1 $
 */

#ifndef _WLANRECEIVE_H_
#define _WLANRECEIVE_H_

#ifdef __cplusplus
extern "C" {
#endif

typedef enum wlanRxFilterOper {
    /* The Rx Filter Operations Types have the following affect on the
     * hardware register and the software copy of the hardware register.
     *
     *                          Hardware Register   Software Copy
     *
     * HAL_RX_FILTER_INIT       Updated             Updated
     * HAL_RX_FILTER_SET        Updated             Updated
     * HAL_RX_FILTER_CLEAR      Updated             Updated
     * HAL_RX_FILTER_TEMP       Updated             unmodified
     * HAL_RX_FILTER_RESTORE    Updated             unmodified
     */

    RX_FILTER_INIT,         // Init hardware register and software copy
    RX_FILTER_SET,          // Set frame type bits
    RX_FILTER_CLEAR,        // Clear frame type bits
    RX_FILTER_TEMP,         // Temporarily set hardware register ONLY.
    RX_FILTER_RESTORE       // Restore hardware register with software copy

} RX_FILTER_OPER;

void
wlanRxFilter(WLAN_DEV_INFO *pDev, RX_FILTER_FLAGS bits, RX_FILTER_OPER oper);


#ifdef __cplusplus
}
#endif

#endif /* _WLANRECEIVE_H_ */
