/*
 * Copyright  2000-2002 Atheros Communications, Inc.,  All Rights Reserved.
 *
 * This file contains the function prototypes, helpful macros and data
 * structure declarations specific to the transmit functions.  It is the
 * same for both the station and access point.
 *
 * $Id: //depot/sw/branches/1.3_USB_LINUX_port/src/USB/wlan/host/include/wlanSend.h#1 $
 */

#ifndef _WLANSEND_H_
#define _WLANSEND_H_

#ifdef __cplusplus
extern "C" {
#endif


/*
 * Some function are meaningful only in context of the AP or the
 * STA - e.g. powersave handling related AP routines, 
 * thus they are defined for one and stubbed out for the other
 */
#ifdef BUILD_AP

#define apUpdateTimForSib(_pDev, _pSib)              do {   \
    if ((!(_pSib)->numTxPending)                            \
        && (!(_pSib)->txPSQueue.qFrameCount)                \
        && ((_pSib)->staState & STATE_ASSOC)                \
        && (!(_pSib)->pBridgeApSibEntry))                   \
    {                                                       \
        wlanTimUpdate(_pDev, (_pSib)->assocId, FALSE);      \
    }                                                       \
} while (0)

#define apDeviceIsUp(_pDev)                                 \
    (END_FLAGS_GET((_pDev)->pOSHandle) & (IFF_UP | IFF_RUNNING))

#define staTxCompletion(_pDev, pDesc, success, flag)
#define powerFrameTransmit                           wlanMgmtFrameTransmit

/*
 * no need to update beacon/cab queue on AP
 * since its params don't change
 */
#define wlanUpdateTxQueues(_pDev)                    do {   \
    wlanTransmitStop(_pDev);                                \
    wlanTransmitStart(_pDev);                               \
} while (0)


void     apMovePsToSwRetryQueue(SIB_ENTRY *pSib);
A_STATUS apHandlePowerMgt(WLAN_DEV_INFO *pdevInfo, ATHEROS_DESC **ppHead,
            ATHEROS_DESC *pLastTail, ATHEROS_DESC *pTxDesc);

/* aging out the buffered traffic from PS queue */
void ageQueue(struct wlanDevInfo *pdevInfo, struct queueDetails *pQueue,
              A_UINT32 agingInterval, A_UINT32 now);

#else // BUILD_STA

#define IS_DEVICE_DOWN(_pDev)                        ((_pDev)->NicResetInProgress)
#define END_ERR_ADD(handle, type, op)
#define DRV_LOG(flags, msg)
#define logMsg                                       uiPrintf
#define apPanic(msg)                                 ASSERT(0)
#define apMovePsToSwRetryQueue(_pSib)
#define apHandlePowerMgt(_pDev, a, b, c)             A_ERROR
#define apUpdateTimForSib(_pDev, _pSib)
#define apDeviceIsUp(_pDev)                          TRUE
#define staTxCompletion                              TransmitCompletion

/*
 * no need to update beacon queue on STA since
 * param changing isn't supported for adhoc
 */
#define wlanUpdateTxQueues(_pDev)                    do {   \
    wlanTransmitStop(_pDev);                                \
    wlanTransmitStart(_pDev);                               \
    powerPSPollInit(_pDev);                                 \
} while (0)


A_STATUS powerFrameTransmit(WLAN_DEV_INFO *pdevInfo, ATHEROS_DESC *pDesc);

#endif

/*
 * macro to initialize txQHandle to proper default value.
 */
#ifdef WME
#define SETQHANDLE(_pDesc, txQId)                           \
        ((_pDesc)->targetTxQId = (_pDesc)->pOpBss->wmeQueues[txQId].targetQueueId)
#else
#define SETQHANDLE(_pDesc, txQId)                           \
        ((_pDesc)->targetTxQId = (_pDesc)->pOpBss->txQueue.targetQueueId)
#endif


/*
 * Helper macro useful to splice out a minichain from a chain of
 * frames; pLastTail->next to pThisTail is spliced out - callee
 * should save its own ptr to the spliced out minichain prior to
 * calling this macro; pHead is used if the minichain happens to
 * be at the head of the main chain
 */
#define spliceFrame_HELPER(_ppH, _pLastT, _pThisT)  do {    \
    if (_pLastT) {                                          \
        (_pLastT)->pNextVirtPtr = (_pThisT)->pNextVirtPtr;  \
        (_pLastT)->nextPhysPtr  = (_pThisT)->nextPhysPtr;   \
    } else {                                                \
        (*(_ppH)) = (_pThisT)->pNextVirtPtr;                \
    }                                                       \
    (_pThisT)->pNextVirtPtr = NULL;                         \
    (_pThisT)->nextPhysPtr = 0;                             \
} while (0)

A_STATUS wlanFrameTransmit(WLAN_DEV_INFO *pdevInfo, QUEUE_DETAILS *pTxQueue,
            ATHEROS_DESC *pDesc);

void wlanResetUpsdQueue(WLAN_DEV_INFO *pDevInfo, SIB_ENTRY *pSIB);
void wlanResetTransmit(WLAN_DEV_INFO *pdevInfo, COMPLETION_ENUM complete);

A_STATUS wlanTransmitInit(WLAN_DEV_INFO *pdevInfo);
A_STATUS wlanTransmitStart(WLAN_DEV_INFO *pdevInfo);
void     wlanTransmitStop(WLAN_DEV_INFO *pdevInfo); 
void     wlanTransmitRelease(WLAN_DEV_INFO *pdevInfo);

/* JK - should be removed later */
#define  StopTransmit(_pDev, clearTxQueue, completePacket, waitForDrain)
#define  RestartTransmit(_pDev)

/**************************************************************************
* Resource usage tracking macros
*/

#define LOG_DROP_FRAME(_p, _r)                  (++((_p)->_r##FramesDropped))
#define debugTxHung(_pDev)                      0

#if defined(DEBUG) && defined(VXWORKS)
void dumpFrame(WLAN_DEV_INFO *pDev, ATHEROS_DESC *pDesc, char *pMsg,
               int verbosity);
#else
#define dumpFrame(_pDev, _pDesc, _pMsg, _verbosity)
#endif

#ifdef __cplusplus
}
#endif

#endif /* _WLANSEND_H_ */
